<?php
require_once 'config.php';

/* ==== Utilities: Telegram ==== */
$RAW = file_get_contents('php://input');
file_put_contents('updatelog.txt',$RAW."\n----\n",FILE_APPEND);
$update = json_decode($RAW,true); if(!$update) exit;

function api($m,$p=[]){ global $botToken;
  $ch=curl_init("https://api.telegram.org/bot{$botToken}/{$m}");
  curl_setopt_array($ch,[CURLOPT_RETURNTRANSFER=>true, CURLOPT_POST=>true, CURLOPT_POSTFIELDS=>$p, CURLOPT_CONNECTTIMEOUT=>10, CURLOPT_TIMEOUT=>30]);
  $r=curl_exec($ch); if($r===false) file_put_contents('error_log.txt',"cURL: ".curl_error($ch)."\n",FILE_APPEND);
  curl_close($ch); return $r;
}
function sendMessage($cid,$t,$kb=null){ $p=['chat_id'=>$cid,'text'=>$t,'parse_mode'=>'HTML']; if($kb)$p['reply_markup']=json_encode(['inline_keyboard'=>$kb],JSON_UNESCAPED_UNICODE); api('sendMessage',$p); }
function sendDocument($cid,$path,$caption=''){ $c=new CURLFile($path,mime_content_type($path),basename($path)); api('sendDocument',['chat_id'=>$cid,'document'=>$c,'caption'=>$caption]); }
function answerCb($id,$t=''){ api('answerCallbackQuery',['callback_query_id'=>$id,'text'=>$t]); }
function greeting(){ $h=intval(date('H')); if($h>=5&&$h<12)return"☀️ صبح بخیر"; if($h>=12&&$h<17)return"🌞 ظهر بخیر"; if($h>=17&&$h<21)return"🌇 عصر بخیر"; if($h>=21||$h<2)return"🌙 شب بخیر"; return"🌌 بامداد بخیر"; }
function welcomeText(){ return greeting()." دوست خوبم 💛\nبه <b>دستیار هوشمند ویژن مدیا</b> خوش اومدی!\nنقش خودت رو انتخاب کن:"; }

/* ==== Helpers: DB & state ==== */
function getUser($tg){ global $pdo;$s=$pdo->prepare("SELECT * FROM users WHERE tg_id=?");$s->execute([$tg]);return $s->fetch(); }
function upUser($tg,$f,$v){ global $pdo;$pdo->prepare("UPDATE users SET {$f}=? WHERE tg_id=?")->execute([$v,$tg]); }
function addUser($tg,$role,$st){ global $pdo;$pdo->prepare("INSERT INTO users(tg_id,role,status) VALUES(?,?,?)")->execute([$tg,$role,$st]); }
function setState($tg,$st,$data=[]){ global $pdo;$pdo->prepare("REPLACE INTO bot_states(tg_id,state,data) VALUES(?,?,?)")->execute([$tg,$st,json_encode($data,JSON_UNESCAPED_UNICODE)]); }
function getState($tg){ global $pdo;$q=$pdo->prepare("SELECT state,data FROM bot_states WHERE tg_id=?");$q->execute([$tg]); if(!$r=$q->fetch()) return [null,[]]; return [$r['state'], json_decode($r['data']?:'[]',true)]; }
function clearState($tg){ global $pdo;$pdo->prepare("DELETE FROM bot_states WHERE tg_id=?")->execute([$tg]); }
function isApprover($tg){ global $pdo,$adminId; if($tg==$adminId)return true; $s=$pdo->prepare("SELECT 1 FROM users WHERE tg_id=? AND role='Accountant' AND status='approved' LIMIT 1");$s->execute([$tg]);return (bool)$s->fetchColumn(); }
function notifyApprovers($emp){ global $pdo,$adminId; $cid=$emp['tg_id'];$name=$emp['name']??'—';$phone=$emp['phone']??'—';$role=$emp['role']??'—';
  $kb=[[['text'=>'✅ تأیید','callback_data'=>'approve_'.$cid],['text'=>'❌ رد','callback_data'=>'reject_'.$cid]]];
  $msg="👤 <b>پرسنل جدید</b>\nنام: <b>{$name}</b>\nنقش: <b>{$role}</b>\nموبایل: <b>{$phone}</b>\n—\nآیا تأیید می‌کنید؟";
  sendMessage($adminId,$msg,$kb);
  foreach($pdo->query("SELECT tg_id FROM users WHERE role='Accountant' AND status='approved'") as $r){ if($r['tg_id']!=$adminId) sendMessage($r['tg_id'],$msg,$kb); }
}

/* ==== JALALI & PDF ==== */
$USE_JALALI = true;
function greg2jal($gy,$gm,$gd){
  $g_d_m=[0,31,($gy%4==0 && $gy%100!=0)||($gy%400==0)?29:28,31,30,31,30,31,31,30,31,30,31];
  $gy2=$gy-1600; $gm2=$gm-1; $gd2=$gd-1; $g_day=365*$gy2 + intdiv($gy2+3,4) - intdiv($gy2+99,100) + intdiv($gy2+399,400);
  for($i=0;$i<$gm2;++$i) $g_day += $g_d_m[$i+1]; $g_day += $gd2; $j_day = $g_day - 79;
  $j_np=intdiv($j_day,12053); $j_day%=12053; $jy=979 + 33*$j_np + 4*intdiv($j_day,1461); $j_day%=1461;
  if($j_day>=366){ $jy += intdiv($j_day-1,365); $j_day=($j_day-1)%365; }
  $jm=($j_day<186)? 1+intdiv($j_day,31) : 7+intdiv($j_day-186,30);
  $jd=1+(($j_day<186)? $j_day%31 : ($j_day-186)%30);
  return [$jy,$jm,$jd];
}
function jdate($dt){ if(!$dt)return''; $parts=explode(' ',trim($dt)); [$y,$m,$d]=array_map('intval',explode('-',$parts[0])); [$jy,$jm,$jd]=greg2jal($y,$m,$d); $date=sprintf('%04d/%02d/%02d',$jy,$jm,$jd); if(count($parts)>1){ $t=substr($parts[1],0,5); return $date.' '.$t; } return $date; }
function dt($greg){ global $USE_JALALI; return $USE_JALALI ? jdate($greg) : $greg; }
function pdf_esc($s){ return str_replace(['\\','(',')'], ['\\\\','\\(','\\)'], $s); }
function pdf_make_table($title,$headers,$rows){
  $w=595; $h=842; $left=40; $top=780;
  $text = "BT /F1 14 Tf 1 0 0 1 {$left} {$top} Tm (".pdf_esc($title).") Tj T* /F1 10 Tf ";
  $text.= "(--------------------------------) Tj T* (".pdf_esc(implode(' | ',$headers)).") Tj T* (--------------------------------) Tj T* ";
  foreach($rows as $r){ $line = implode(' | ', array_map(fn($x)=>str_replace([\"\r\",\"\n\"],' ', (string)$x), $r)); $text.= "(".pdf_esc($line).") Tj T* "; }
  $text.= "ET";
  $objects=[];
  $objects[]="1 0 obj << /Type /Catalog /Pages 2 0 R >> endobj";
  $objects[]="2 0 obj << /Type /Pages /Kids [3 0 R] /Count 1 >> endobj";
  $objects[]="3 0 obj << /Type /Page /Parent 2 0 R /MediaBox [0 0 {$w} {$h}] /Contents 4 0 R /Resources << /Font << /F1 5 0 R >> >> >> endobj";
  $objects[]="4 0 obj << /Length ".strlen($text)." >> stream\n{$text}\nendstream endobj";
  $objects[]="5 0 obj << /Type /Font /Subtype /Type1 /BaseFont /Helvetica >> endobj";
  $pdf="%PDF-1.4\n"; $xref="xref\n0 ".(count($objects)+1)."\n0000000000 65535 f \n";
  $ofs=[0]; $pos=strlen($pdf);
  foreach($objects as $i=>$obj){ $ofs[]=$pos; $pdf.=$obj."\n"; $pos=strlen($pdf); }
  foreach($ofs[1:] as $o){ $xref.=sprintf("%010d 00000 n \n",$o); }
  $trailer="trailer << /Size ".(count($objects)+1)." /Root 1 0 R >>\nstartxref\n".$pos."\n%%EOF";
  return $pdf.$xref.$trailer;
}
function pdf_send_doc($chat_id,$filename,$title,$headers,$rows){
  $dir=__DIR__.'/tmp'; if(!is_dir($dir)) @mkdir($dir,0775,true);
  $path=$dir.'/'.$filename; file_put_contents($path, pdf_make_table($title,$headers,$rows));
  $cFile = new CURLFile($path,'application/pdf',basename($path));
  api('sendDocument',['chat_id'=>$chat_id,'document'=>$cFile,'caption'=>$title]);
}

/* ==== CSV helper ==== */
function csvTemp($filename,$headers,$rows){
  $dir=__DIR__.'/tmp'; if(!is_dir($dir)) @mkdir($dir,0775,true);
  $p=$dir.'/'.$filename; $f=fopen($p,'w'); fprintf($f,chr(0xEF).chr(0xBB).chr(0xBF)); fputcsv($f,$headers); foreach($rows as $r){ fputcsv($f,$r); } fclose($f); return $p;
}

/* ==== Menus ==== */
function customerMenu($cid){
  $kb=[
    [ ['text'=>'🛒 فروشگاه','callback_data'=>'cust_shop'], ['text'=>'🧺 سبد خرید','callback_data'=>'cust_cart'], ['text'=>'📦 پیگیری','callback_data'=>'cust_track'] ],
    [ ['text'=>'🎫 پشتیبانی','callback_data'=>'cust_support'] ]
  ];
  sendMessage($cid,"✅ خوش اومدی! از منو انتخاب کن:",$kb);
}
function ceoMenu($cid){
  $kb=[
    [ ['text'=>'📊 داشبورد','callback_data'=>'ceo_dashboard'], ['text'=>'🧾 Pending','callback_data'=>'ceo_pending'], ['text'=>'👥 کاربران','callback_data'=>'ceo_users'] ],
    [ ['text'=>'⬇️ CSV','callback_data'=>'ceo_export_menu'], ['text'=>'📄 PDF','callback_data'=>'ceo_export_pdf_menu'], ['text'=>'⏰ یادآورها','callback_data'=>'rem_menu'] ],
    [ ['text'=>'💰 حسابدار','callback_data'=>'acc_menu'], ['text'=>'🧩 مدیر دپارتمان','callback_data'=>'dm_menu'], ['text'=>'🛠 ادمین','callback_data'=>'ad_menu'] ],
    [ ['text'=>'🏠 شروع','callback_data'=>'back_home'] ]
  ];
  sendMessage($cid,"👑 <b>پنل مدیرعامل</b>",$kb);
}
function ceoExportMenu($cid){
  $kb=[
    [ ['text'=>'👥 کاربران','callback_data'=>'exp_users'], ['text'=>'📦 سفارش‌ها','callback_data'=>'exp_orders'], ['text'=>'🧾 فاکتورها','callback_data'=>'exp_invoices'] ],
    [ ['text'=>'💳 پرداخت‌ها','callback_data'=>'exp_payments'], ['text'=>'📂 پروژه‌ها','callback_data'=>'exp_projects'], ['text'=>'📝 تسک‌ها','callback_data'=>'exp_tasks'] ],
    [ ['text'=>'↩️ بازگشت','callback_data'=>'ceo_menu'] ]
  ];
  sendMessage($cid,"⬇️ انتخاب CSV:",$kb);
}
function ceoExportPdfMenu($cid){
  $kb=[
    [ ['text'=>'👥 کاربران (PDF)','callback_data'=>'exp_users_pdf'], ['text'=>'📦 سفارش‌ها (PDF)','callback_data'=>'exp_orders_pdf'] ],
    [ ['text'=>'🧾 فاکتورها (PDF)','callback_data'=>'exp_invoices_pdf'], ['text'=>'💳 پرداخت‌ها (PDF)','callback_data'=>'exp_payments_pdf'] ],
    [ ['text'=>'📂 پروژه‌ها (PDF)','callback_data'=>'exp_projects_pdf'], ['text'=>'📝 تسک‌ها (PDF)','callback_data'=>'exp_tasks_pdf'] ],
    [ ['text'=>'↩️ بازگشت','callback_data'=>'ceo_menu'] ]
  ];
  sendMessage($cid,"📄 انتخاب PDF:",$kb);
}
function accMenu($cid){
  $kb=[
    [ ['text'=>'➕ صدور فاکتور','callback_data'=>'acc_new_invoice'], ['text'=>'🧾 فاکتورهای پرداخت‌نشده','callback_data'=>'acc_unpaid'], ['text'=>'💵 ثبت پرداخت','callback_data'=>'acc_new_payment'] ],
    [ ['text'=>'⏰ یادآورها','callback_data'=>'rem_menu'], ['text'=>'🏠 شروع','callback_data'=>'back_home'] ]
  ];
  sendMessage($cid,"💰 <b>پنل حسابدار</b>",$kb);
}
function dmMenu($cid){
  $kb=[
    [ ['text'=>'🆕 ساخت پروژه','callback_data'=>'dm_new_project'], ['text'=>'📂 پروژه‌های من','callback_data'=>'dm_my_projects'], ['text'=>'📝 افزودن تسک','callback_data'=>'dm_new_task'] ],
    [ ['text'=>'📋 تسک‌های تیم','callback_data'=>'dm_team_tasks'], ['text'=>'⏰ یادآورها','callback_data'=>'rem_menu'] ],
    [ ['text'=>'🏠 شروع','callback_data'=>'back_home'] ]
  ];
  sendMessage($cid,"🧩 <b>پنل مدیر دپارتمان</b>",$kb);
}
function adMenu($cid){
  $kb=[
    [ ['text'=>'🛍 محصولات','callback_data'=>'ad_products'], ['text'=>'➕ محصول جدید','callback_data'=>'ad_new_product'], ['text'=>'📦 سفارش‌ها','callback_data'=>'ad_orders'] ],
    [ ['text'=>'⏰ یادآورها','callback_data'=>'rem_menu'], ['text'=>'🏠 شروع','callback_data'=>'back_home'] ]
  ];
  sendMessage($cid,"🛠 <b>پنل ادمین</b>",$kb);
}

/* ==== Shop helpers ==== */
function shopList($cid,$page=1){
  global $pdo; $limit=6; $off=($page-1)*$limit;
  $s=$pdo->prepare("SELECT id,title,price FROM products WHERE active=1 ORDER BY id ASC LIMIT :o,:l");
  $s->bindValue(':o',$off,PDO::PARAM_INT); $s->bindValue(':l',$limit,PDO::PARAM_INT); $s->execute(); $rows=$s->fetchAll();
  if(!$rows){ sendMessage($cid,"📭 محصولی موجود نیست."); return; }
  $txt="🛒 <b>فروشگاه ویژن مدیا</b>\nبرای افزودن، دکمه هر محصول را بزن:";
  $kb=[]; foreach($rows as $r){ $kb[]=[ ['text'=>"➕ {$r['title']} — ".number_format($r['price'])." ریال",'callback_data'=>"shop_add_".$r['id']] ]; }
  $nav=[]; if($page>1)$nav[]=['text'=>'⬅️ قبلی','callback_data'=>'shop_page_'.($page-1)]; $nav[]=['text'=>'🧺 سبد','callback_data'=>'cust_cart']; $nav[]=['text'=>'خالی','callback_data'=>'cart_clear']; if(count($rows)==$limit)$nav[]=['text'=>'بعدی ➡️','callback_data'=>'shop_page_'.($page+1)];
  $kb[]=$nav; sendMessage($cid,$txt,$kb);
}
function cartGet($cid){ list($st,$d)=getState($cid); return $d['cart']??[]; }
function cartSave($cid,$c){ list($st,$d)=getState($cid); if(!$st)$st='cart'; $d['cart']=$c; setState($cid,$st,$d); }
function cartAdd($cid,$pid,$q){ $c=cartGet($cid); $c[$pid]=($c[$pid]??0)+$q; if($c[$pid]<=0)unset($c[$pid]); cartSave($cid,$c); }
function cartClear($cid){ list($st,$d)=getState($cid); $d['cart']=[]; if(!$st)$st='cart'; setState($cid,$st,$d); }
function cartRender($cid){
  global $pdo; $c=cartGet($cid); if(!$c){ sendMessage($cid,"🧺 سبد شما خالی است."); return; }
  $ids=implode(',',array_map('intval',array_keys($c))); $q=$pdo->query("SELECT id,title,price FROM products WHERE id IN ($ids)"); $p=[]; foreach($q as $r){ $p[$r['id']]=$r; }
  $txt="🧺 <b>سبد خرید</b>\n"; $tot=0; $kb=[];
  foreach($c as $pid=>$qty){ if(!isset($p[$pid]))continue; $line=$p[$pid]['title']." × ".$qty." = ".number_format($p[$pid]['price']*$qty)." ریال"; $txt.="\n• ".$line; $tot+=$p[$pid]['price']*$qty;
    $kb[]=[ ['text'=>"➖",'callback_data'=>"cart_dec_".$pid], ['text'=>"➕",'callback_data'=>"cart_inc_".$pid], ['text'=>"🗑",'callback_data'=>"cart_del_".$pid] ];
  }
  $txt.="\n\n💵 جمع کل: <b>".number_format($tot)." ریال</b>";
  $kb[]=[ ['text'=>'🧾 ثبت سفارش','callback_data'=>'cart_checkout'], ['text'=>'🛒 ادامه خرید','callback_data'=>'cust_shop'], ['text'=>'🧹 خالی','callback_data'=>'cart_clear'] ];
  sendMessage($cid,$txt,$kb);
}
function cartCheckout($cid){
  global $pdo; $u=getUser($cid); if(!$u||empty($u['name'])||empty($u['phone'])){ sendMessage($cid,"⚠️ ابتدا ثبت‌نام مشتری را کامل کن (نام و شماره)."); return; }
  $c=cartGet($cid); if(!$c){ sendMessage($cid,"🧺 سبد شما خالی است."); return; }
  $ids=implode(',',array_map('intval',array_keys($c))); $q=$pdo->query("SELECT id,title,price FROM products WHERE id IN ($ids)"); $p=[]; foreach($q as $r){$p[$r['id']]=$r;}
  $tot=0; foreach($c as $pid=>$qty){ if(isset($p[$pid])) $tot+=$p[$pid]['price']*$qty; }
  $pdo->prepare("INSERT INTO orders(user_tg,total,status) VALUES(?,?,'new')")->execute([$cid,$tot]); $oid=$pdo->lastInsertId();
  $ins=$pdo->prepare("INSERT INTO order_items(order_id,product_id,qty,price) VALUES(?,?,?,?)");
  foreach($c as $pid=>$qty){ if(isset($p[$pid])) $ins->execute([$oid,$pid,$qty,$p[$pid]['price']]); }
  cartClear($cid); sendMessage($cid,"🎉 سفارش ثبت شد. شماره: #{$oid} | وضعیت: جدید | تاریخ: ".dt(date('Y-m-d H:i:s')));
}
function trackOrders($cid){
  global $pdo; $s=$pdo->prepare("SELECT id,total,status,created_at FROM orders WHERE user_tg=? ORDER BY id DESC LIMIT 10"); $s->execute([$cid]); $rows=$s->fetchAll();
  if(!$rows){ sendMessage($cid,"📦 سفارشی ندارید."); return; }
  $t="📦 <b>سفارش‌های شما</b>\n"; foreach($rows as $r){ $t.="\n• #{$r['id']} | ".number_format($r['total'])." ریال | {$r['status']} | ".dt($r['created_at']); } sendMessage($cid,$t);
}

/* ==== Dashboards & CSV/PDF exports ==== */
function ceoDashboard($cid){
  global $pdo;
  $totUsers=(int)$pdo->query("SELECT COUNT(*) c FROM users")->fetch()['c'];
  $approved=(int)$pdo->query("SELECT COUNT(*) c FROM users WHERE status='approved'")->fetch()['c'];
  $pending=(int)$pdo->query("SELECT COUNT(*) c FROM users WHERE status='pending'")->fetch()['c'];
  $customers=(int)$pdo->query("SELECT COUNT(*) c FROM users WHERE role='Customer'")->fetch()['c'];
  $ord=$pdo->query("SELECT SUM(total) tot, COUNT(*) cnt FROM orders")->fetch(); $totSales=(int)($ord['tot']??0); $cntOrders=(int)($ord['cnt']??0);
  $invSum=(int)($pdo->query("SELECT SUM(amount) s FROM invoices")->fetch()['s']??0);
  $paySum=(int)($pdo->query("SELECT SUM(amount) s FROM payments")->fetch()['s']??0);
  $proj=$pdo->query("SELECT SUM(status='open') o, SUM(status='in_progress') p, SUM(status='done') d FROM projects")->fetch();
  $task=$pdo->query("SELECT SUM(status='todo') t, SUM(status='doing') g, SUM(status='done') dd FROM tasks")->fetch();
  $txt="📊 <b>داشبورد</b>\n👥 کاربران: کل <b>{$totUsers}</b> | تأیید <b>{$approved}</b> | انتظار <b>{$pending}</b> | مشتری <b>{$customers}</b>\n🛒 سفارش‌ها: <b>{$cntOrders}</b> | مجموع <b>".number_format($totSales)." ریال</b>\n💰 مالی: فاکتورها <b>".number_format($invSum)."</b> | پرداخت‌ها <b>".number_format($paySum)."</b>\n📂 پروژه‌ها: باز <b>".(int)($proj['o']??0)."</b> | انجام <b>".(int)($proj['p']??0)."</b> | تمام <b>".(int)($proj['d']??0)."</b>\n📝 تسک‌ها: TODO <b>".(int)($task['t']??0)."</b> | Doing <b>".(int)($task['g']??0)."</b> | Done <b>".(int)($task['dd']??0)."</b>";
  $kb=[ [ ['text'=>'⬇️ CSV','callback_data'=>'ceo_export_menu'], ['text'=>'📄 PDF','callback_data'=>'ceo_export_pdf_menu'] ], [ ['text'=>'🧾 Pending','callback_data'=>'ceo_pending'], ['text'=>'👥 کاربران','callback_data'=>'ceo_users'] ], [ ['text'=>'🏠 منو','callback_data'=>'ceo_menu'] ] ];
  sendMessage($cid,$txt,$kb);
}
function exportUsers($cid){ global $pdo; $rows=$pdo->query("SELECT id,tg_id,name,phone,role,status,created_at FROM users ORDER BY id DESC")->fetchAll(); $d=[]; foreach($rows as $r){ $d[]=[ $r['id'],$r['tg_id'],$r['name'],$r['phone'],$r['role'],$r['status'],$r['created_at'] ]; } $p=csvTemp('users.csv',['id','tg_id','name','phone','role','status','created_at'],$d); sendDocument($cid,$p,'👥 users.csv'); }
function exportOrders($cid){ global $pdo; $rows=$pdo->query("SELECT id,user_tg,total,status,created_at FROM orders ORDER BY id DESC")->fetchAll(); $d=[]; foreach($rows as $r){ $d[]=[ $r['id'],$r['user_tg'],$r['total'],$r['status'],$r['created_at'] ]; } $p=csvTemp('orders.csv',['id','user_tg','total','status','created_at'],$d); sendDocument($cid,$p,'📦 orders.csv'); }
function exportInvoices($cid){ global $pdo; $rows=$pdo->query("SELECT id,user_tg,created_by,amount,status,created_at FROM invoices ORDER BY id DESC")->fetchAll(); $d=[]; foreach($rows as $r){ $d[]=[ $r['id'],$r['user_tg'],$r['created_by'],$r['amount'],$r['status'],$r['created_at'] ]; } $p=csvTemp('invoices.csv',['id','user_tg','created_by','amount','status','created_at'],$d); sendDocument($cid,$p,'🧾 invoices.csv'); }
function exportPayments($cid){ global $pdo; $rows=$pdo->query("SELECT id,invoice_id,amount,paid_by,created_at FROM payments ORDER BY id DESC")->fetchAll(); $d=[]; foreach($rows as $r){ $d[]=[ $r['id'],$r['invoice_id'],$r['amount'],$r['paid_by'],$r['created_at'] ]; } $p=csvTemp('payments.csv',['id','invoice_id','amount','paid_by','created_at'],$d); sendDocument($cid,$p,'💳 payments.csv'); }
function exportProjects($cid){ global $pdo; $rows=$pdo->query("SELECT id,title,manager_tg,status,created_at FROM projects ORDER BY id DESC")->fetchAll(); $d=[]; foreach($rows as $r){ $d[]=[ $r['id'],$r['title'],$r['manager_tg'],$r['status'],$r['created_at'] ]; } $p=csvTemp('projects.csv',['id','title','manager_tg','status','created_at'],$d); sendDocument($cid,$p,'📂 projects.csv'); }
function exportTasks($cid){ global $pdo; $rows=$pdo->query("SELECT id,project_id,title,assignee_tg,status,due_date,created_at FROM tasks ORDER BY id DESC")->fetchAll(); $d=[]; foreach($rows as $r){ $d[]=[ $r['id'],$r['project_id'],$r['title'],$r['assignee_tg'],$r['status'],$r['due_date'],$r['created_at'] ]; } $p=csvTemp('tasks.csv',['id','project_id','title','assignee_tg','status','due_date','created_at'],$d); sendDocument($cid,$p,'📝 tasks.csv'); }
function exportUsersPdf($cid){ global $pdo; $rows=$pdo->query("SELECT id,tg_id,name,phone,role,status,created_at FROM users ORDER BY id DESC")->fetchAll(); $d=[]; foreach($rows as $r){ $d[]=[ $r['id'],$r['tg_id'],$r['name'],$r['phone'],$r['role'],$r['status'], dt($r['created_at']) ]; } pdf_send_doc($cid,'users.pdf','👥 کاربران',['ID','TG','نام','موبایل','نقش','وضعیت','تاریخ'],$d); }
function exportOrdersPdf($cid){ global $pdo; $rows=$pdo->query("SELECT id,user_tg,total,status,created_at FROM orders ORDER BY id DESC")->fetchAll(); $d=[]; foreach($rows as $r){ $d[]=[ $r['id'],$r['user_tg'], number_format($r['total']), $r['status'], dt($r['created_at']) ]; } pdf_send_doc($cid,'orders.pdf','📦 سفارش‌ها',['ID','TG','جمع','وضعیت','تاریخ'],$d); }
function exportInvoicesPdf($cid){ global $pdo; $rows=$pdo->query("SELECT id,user_tg,created_by,amount,status,created_at FROM invoices ORDER BY id DESC")->fetchAll(); $d=[]; foreach($rows as $r){ $d[]=[ $r['id'],$r['user_tg'],$r['created_by'], number_format($r['amount']), $r['status'], dt($r['created_at']) ]; } pdf_send_doc($cid,'invoices.pdf','🧾 فاکتورها',['ID','TG مشتری','ایجادکننده','مبلغ','وضعیت','تاریخ'],$d); }
function exportPaymentsPdf($cid){ global $pdo; $rows=$pdo->query("SELECT id,invoice_id,amount,paid_by,created_at FROM payments ORDER BY id DESC")->fetchAll(); $d=[]; foreach($rows as $r){ $d[]=[ $r['id'],$r['invoice_id'], number_format($r['amount']), $r['paid_by'], dt($r['created_at']) ]; } pdf_send_doc($cid,'payments.pdf','💳 پرداخت‌ها',['ID','فاکتور','مبلغ','پرداخت‌کننده','تاریخ'],$d); }
function exportProjectsPdf($cid){ global $pdo; $rows=$pdo->query("SELECT id,title,manager_tg,status,created_at FROM projects ORDER BY id DESC")->fetchAll(); $d=[]; foreach($rows as $r){ $d[]=[ $r['id'],$r['title'],$r['manager_tg'],$r['status'], dt($r['created_at']) ]; } pdf_send_doc($cid,'projects.pdf','📂 پروژه‌ها',['ID','عنوان','مدیر','وضعیت','تاریخ'],$d); }
function exportTasksPdf($cid){ global $pdo; $rows=$pdo->query("SELECT id,project_id,title,assignee_tg,status,due_date,created_at FROM tasks ORDER BY id DESC")->fetchAll(); $d=[]; foreach($rows as $r){ $d[]=[ $r['id'],$r['project_id'],$r['title'],$r['assignee_tg'],$r['status'], $r['due_date']?jdate($r['due_date']):'-', dt($r['created_at']) ]; } pdf_send_doc($cid,'tasks.pdf','📝 تسک‌ها',['ID','پروژه','عنوان','مسئول','وضعیت','موعد','ثبت'],$d); }

/* ==== Reminders ==== */
function remMenu($cid){
  $kb=[ [ ['text'=>'🆕 ساخت یادآور','callback_data'=>'rem_new'], ['text'=>'🗂 لیست یادآورها','callback_data'=>'rem_list'] ],
        [ ['text'=>'❌ حذف یادآور','callback_data'=>'rem_cancel'] ],
        [ ['text'=>'↩️ بازگشت','callback_data'=>'back_home'] ] ];
  sendMessage($cid,"⏰ <b>مدیریت یادآورها</b>",$kb);
}
function remList($cid,$page=1){
  global $pdo; $lim=10;$off=($page-1)*$lim;
  $s=$pdo->prepare("SELECT id,target_tg,body,run_at,sent FROM reminders ORDER BY run_at DESC LIMIT :o,:l");
  $s->bindValue(':o',$off,PDO::PARAM_INT);$s->bindValue(':l',$lim,PDO::PARAM_INT);$s->execute();$rows=$s->fetchAll();
  if(!$rows){ sendMessage($cid,"📭 هیچ یادآوری ثبت نشده."); return; }
  $txt="🗂 <b>لیست یادآورها</b>\n";
  foreach($rows as $r){ $st=$r['sent']?'ارسال‌شده ✅':'در صف ⏳'; $txt.="\n• #{$r['id']} | TG: {$r['target_tg']} | {$st}\n🗓 ".dt($r['run_at'])."\n📝 ".$r['body']; }
  $nav=[]; if($page>1)$nav[]=['text'=>'⬅️ قبلی','callback_data'=>'rem_list_'.($page-1)]; $nav[]=['text'=>'↩️ بازگشت','callback_data'=>'rem_menu']; if(count($rows)==$lim)$nav[]=['text'=>'بعدی ➡️','callback_data'=>'rem_list_'.($page+1)];
  sendMessage($cid,$txt,[$nav]);
}

/* ==== MESSAGE ==== */
if(isset($update['message'])){
  $m=$update['message']; $cid=$m['chat']['id']; $text=trim($m['text']??'');

  if($text==='/start'){
    global $adminId; $isAdmin=($cid==$adminId);
    $kb=[[['text'=>'👑 مدیرعامل','callback_data'=>'role_CEO'],['text'=>'💰 حسابدار','callback_data'=>'role_Accountant'],['text'=>'🧩 مدیر دپارتمان','callback_data'=>'role_DepartmentManager']],[['text'=>'🛠 ادمین','callback_data'=>'role_Admin'],['text'=>'🧍 مشتری','callback_data'=>'role_Customer']]];
    $msg=welcomeText(); if($isAdmin) $msg.="\n\n👑 <b>شما مدیرعامل هستید.</b>";
    sendMessage($cid,$msg,$kb);
    $me=getUser($cid);
    if($isAdmin) ceoMenu($cid);
    if($me && $me['role']==='Accountant' && $me['status']==='approved') accMenu($cid);
    if($me && $me['role']==='DepartmentManager' && $me['status']==='approved') dmMenu($cid);
    if($me && $me['role']==='Admin' && $me['status']==='approved') adMenu($cid);
    if($me && $me['role']==='Customer') customerMenu($cid);
    exit;
  }

  $u=getUser($cid);

  // ثبت‌نام مشتری
  if($u && $u['role']==='Customer' && $u['status']==='customer'){
    if(empty($u['name'])){ if(mb_strlen($text)<2){ sendMessage($cid,"⚠️ لطفاً نام کامل را وارد کن."); exit; } upUser($cid,'name',$text); sendMessage($cid,"📱 شماره موبایل را بفرست (09XXXXXXXXX):"); exit; }
    elseif(empty($u['phone'])){ if(!preg_match('/^(09[0-9]{9})$/',$text)){ sendMessage($cid,"⚠️ فرمت شماره صحیح نیست."); exit; } upUser($cid,'phone',$text); sendMessage($cid,"🎉 ثبت‌نام کامل شد!"); customerMenu($cid); exit; }
  }

  // پرونده پرسنل pending
  if($u && $u['status']==='pending'){
    if(empty($u['name'])){ if(mb_strlen($text)<2){ sendMessage($cid,"⚠️ نام معتبر نیست."); exit; } upUser($cid,'name',$text); sendMessage($cid,"📱 شماره موبایل را بفرست:"); exit; }
    elseif(empty($u['phone'])){ if(!preg_match('/^(09[0-9]{9})$/',$text)){ sendMessage($cid,"⚠️ فرمت شماره صحیح نیست."); exit; } upUser($cid,'phone',$text); sendMessage($cid,"✅ اطلاعات ثبت شد. ⏳ منتظر تأیید مدیریت باشید."); notifyApprovers(getUser($cid)); exit; }
  }

  // State flows (Reminders + shop/admin/accountant/DM short)
  list($state,$data)=getState($cid);

  // Reminders create
  if($state==='rem_new_target'){
    if(!preg_match('/^[0-9]{5,15}$/',$text)){ sendMessage($cid,"⚠️ TG ID معتبر نیست."); exit; }
    setState($cid,'rem_new_body',['target_tg'=>$text]); sendMessage($cid,"📝 متن یادآور را بفرست:"); exit;
  }
  if($state==='rem_new_body'){
    if(mb_strlen($text)<2){ sendMessage($cid,"⚠️ متن کوتاه است."); exit; }
    $data['body']=$text; setState($cid,'rem_new_datetime',$data);
    sendMessage($cid,"🗓 تاریخ/ساعت را به‌فرمت <code>YYYY-MM-DD HH:MM</code> بفرست. مثال: <code>".date('Y-m-d')." 18:30</code>");
    exit;
  }
  if($state==='rem_new_datetime'){
    if(!preg_match('/^\d{4}-\d{2}-\d{2}\s+\d{2}:\d{2}$/',$text)){ sendMessage($cid,"⚠️ فرمت تاریخ نادرست است."); exit; }
    global $pdo; $pdo->prepare("INSERT INTO reminders(target_tg,created_by,body,run_at,sent) VALUES(?,?,?,?,0)")->execute([$data['target_tg'],$cid,$data['body'],$text]);
    clearState($cid); sendMessage($cid,"✅ یادآور ثبت شد."); exit;
  }

  // Accountant short states
  if($u && $u['role']==='Accountant' && $u['status']==='approved' && $state){
    if($state==='acc_inv_target'){ if(!preg_match('/^[0-9]{5,15}$/',$text)){ sendMessage($cid,"⚠️ tg_id معتبر نیست."); exit; } setState($cid,'acc_inv_amount',['target_tg'=>$text]); sendMessage($cid,"💵 مبلغ (ریال)؟"); exit; }
    if($state==='acc_inv_amount'){ if(!preg_match('/^[0-9]{3,12}$/',$text)){ sendMessage($cid,"⚠️ مبلغ معتبر نیست."); exit; } $GLOBALS['pdo']->prepare("INSERT INTO invoices(user_tg,created_by,amount,status) VALUES(?,?,?, 'unpaid')")->execute([$data['target_tg'],$cid,(int)$text]); clearState($cid); sendMessage($cid,"✅ فاکتور ثبت شد."); exit; }
    if($state==='acc_pay_invoice'){ if(!preg_match('/^[0-9]+$/',$text)){ sendMessage($cid,"⚠️ شماره فاکتور؟"); exit; } setState($cid,'acc_pay_amount',['invoice_id'=>(int)$text]); sendMessage($cid,"💵 مبلغ پرداخت؟"); exit; }
    if($state==='acc_pay_amount'){ if(!preg_match('/^[0-9]{3,12}$/',$text)){ sendMessage($cid,"⚠️ مبلغ معتبر نیست."); exit; } $iid=(int)$data['invoice_id']; $amt=(int)$text; $pdo->prepare("INSERT INTO payments(invoice_id,amount,paid_by) VALUES(?,?,?)")->execute([$iid,$amt,$cid]); $s=$pdo->prepare("SELECT SUM(amount) s FROM payments WHERE invoice_id=?");$s->execute([$iid]);$sum=(int)$s->fetch()['s']; $i=$pdo->prepare("SELECT amount FROM invoices WHERE id=?");$i->execute([$iid]);$tot=(int)$i->fetch()['amount']; if($sum>=$tot){ $pdo->prepare("UPDATE invoices SET status='paid' WHERE id=?")->execute([$iid]); sendMessage($cid,"🎉 فاکتور #{$iid} تسویه شد."); } else { sendMessage($cid,"✅ پرداخت ثبت شد. مجموع: ".number_format($sum)." / ".number_format($tot)); } clearState($cid); exit; }
  }

  // Admin product edit states
  if($u && $u['role']==='Admin' && $u['status']==='approved' && $state){
    if($state==='ad_new_title'){ if(mb_strlen($text)<2){ sendMessage($cid,"⚠️ عنوان کوتاه است."); exit; } setState($cid,'ad_new_price',['title'=>$text]); sendMessage($cid,"💵 قیمت (ریال)؟"); exit; }
    if($state==='ad_new_price'){ if(!preg_match('/^[0-9]{3,12}$/',$text)){ sendMessage($cid,"⚠️ مبلغ صحیح نیست."); exit; } $GLOBALS['pdo']->prepare("INSERT INTO products(title,price,active) VALUES(?,? ,1)")->execute([$data['title'],(int)$text]); clearState($cid); sendMessage($cid,"✅ محصول اضافه شد."); exit; }
    if($state==='ad_edit_choose'){ if(!preg_match('/^[0-9]+$/',$text)){ sendMessage($cid,"⚠️ ID محصول؟"); exit; } setState($cid,'ad_edit_title',['pid'=>(int)$text]); sendMessage($cid,"✏️ عنوان جدید:"); exit; }
    if($state==='ad_edit_title'){ if(mb_strlen($text)<2){ sendMessage($cid,"⚠️ عنوان؟"); exit; } $data['title']=$text; setState($cid,'ad_edit_price',$data); sendMessage($cid,"💵 قیمت جدید (ریال):"); exit; }
    if($state==='ad_edit_price'){ if(!preg_match('/^[0-9]{3,12}$/',$text)){ sendMessage($cid,"⚠️ مبلغ؟"); exit; } $GLOBALS['pdo']->prepare("UPDATE products SET title=?,price=? WHERE id=?")->execute([$data['title'],(int)$text,(int)$data['pid']]); clearState($cid); sendMessage($cid,"✅ محصول بروزرسانی شد."); exit; }
  }

  // DM states
  if($u && $u['role']==='DepartmentManager' && $u['status']==='approved' && $state){
    if($state==='dm_new_project_title'){ if(mb_strlen($text)<2){ sendMessage($cid,"⚠️ عنوان؟"); exit; } setState($cid,'dm_new_project_desc',['title'=>$text]); sendMessage($cid,"📝 توضیح کوتاه:"); exit; }
    if($state==='dm_new_project_desc'){ $GLOBALS['pdo']->prepare("INSERT INTO projects(title,description,manager_tg,status) VALUES(?,?,?,'open')")->execute([$data['title'],$text,$cid]); clearState($cid); sendMessage($cid,"✅ پروژه ساخته شد."); exit; }
    if($state==='dm_new_task_project'){ if(!preg_match('/^[0-9]+$/',$text)){ sendMessage($cid,"⚠️ شماره پروژه؟"); exit; } setState($cid,'dm_new_task_title',['project_id'=>(int)$text]); sendMessage($cid,"📝 عنوان تسک:"); exit; }
    if($state==='dm_new_task_title'){ if(mb_strlen($text)<2){ sendMessage($cid,"⚠️ عنوان؟"); exit; } $data['title']=$text; setState($cid,'dm_new_task_assignee',$data); sendMessage($cid,"👤 TG ID مسئول:"); exit; }
    if($state==='dm_new_task_assignee'){ if(!preg_match('/^[0-9]{5,15}$/',$text)){ sendMessage($cid,"⚠️ TG ID؟"); exit; } $data['assignee_tg']=$text; setState($cid,'dm_new_task_due',$data); sendMessage($cid,"📅 موعد (YYYY-MM-DD) یا «خالی»:"); exit; }
    if($state==='dm_new_task_due'){ $due=null; if(mb_strtolower($text)!=='خالی'){ if(!preg_match('/^\d{4}-\d{2}-\d{2}$/',$text)){ sendMessage($cid,"⚠️ تاریخ نامعتبر."); exit; } $due=$text; } $GLOBALS['pdo']->prepare("INSERT INTO tasks(project_id,title,assignee_tg,due_date,status) VALUES(?,?,?,?, 'todo')")->execute([$data['project_id'],$data['title'],$data['assignee_tg'],$due]); clearState($cid); sendMessage($cid,"✅ تسک ثبت شد."); exit; }
  }

  // Shop qty
  if($state==='cart_qty'){ if(!preg_match('/^[1-9][0-9]*$/',$text)){ sendMessage($cid,"⚠️ یک عدد صحیح وارد کن."); exit; } $qty=(int)$text; $pid=(int)$data['pid']; cartAdd($cid,$pid,$qty); clearState($cid); sendMessage($cid,"✅ اضافه شد."); cartRender($cid); exit; }

  sendMessage($cid,"ℹ️ /start");
  exit;
}

/* ==== CALLBACK ==== */
if(isset($update['callback_query'])){
  $cb=$update['callback_query']; $cid=$cb['from']['id']; $data=$cb['data']; answerCb($cb['id']);

  // نقش
  if(strpos($data,'role_')===0){
    $role=str_replace('role_','',$data); $u=getUser($cid);
    if(!$u){ if($role==='Customer'){ addUser($cid,$role,'customer'); sendMessage($cid,"📝 نام کامل؟"); } else { addUser($cid,$role,'pending'); sendMessage($cid,"📝 نام کامل برای پرونده:"); } }
    else sendMessage($cid,"✅ نقش شما قبلاً ثبت شده.");
    global $adminId; if($cid==$adminId) ceoMenu($cid);
    $me=getUser($cid);
    if($me && $me['role']==='Accountant' && $me['status']==='approved') accMenu($cid);
    if($me && $me['role']==='DepartmentManager' && $me['status']==='approved') dmMenu($cid);
    if($me && $me['role']==='Admin' && $me['status']==='approved') adMenu($cid);
    if($me && $me['role']==='Customer') customerMenu($cid);
    exit;
  }

  // مشترک
  if($data==='back_home'){ api('sendMessage',['chat_id'=>$cid,'text'=>'/start']); exit; }

  // CEO
  if($data==='ceo_menu'){ ceoMenu($cid); exit; }
  if($data==='ceo_dashboard'){ ceoDashboard($cid); exit; }
  if($data==='ceo_export_menu'){ ceoExportMenu($cid); exit; }
  if($data==='ceo_export_pdf_menu'){ ceoExportPdfMenu($cid); exit; }
  if($data==='ceo_pending'){
    global $pdo; $s=$pdo->query("SELECT tg_id,name,phone,role FROM users WHERE status='pending' ORDER BY created_at DESC LIMIT 20");
    $t="🧾 <b>در انتظار تأیید</b>\n"; $kb=[];
    foreach($s as $r){ $nm=$r['name']?:'—'; $t.="\n• {$nm} | {$r['role']} | {$r['phone']}"; $kb[]=[ ['text'=>"✅ تأیید {$nm}",'callback_data'=>"approve_".$r['tg_id']], ['text'=>"❌ رد",'callback_data'=>"reject_".$r['tg_id']] ]; }
    $kb[]=[ ['text'=>'↩️ بازگشت','callback_data'=>'ceo_menu'] ]; sendMessage($cid,$t,$kb); exit;
  }
  if($data==='ceo_users'){
    global $pdo; $s=$pdo->query("SELECT tg_id,name,role,status FROM users ORDER BY created_at DESC LIMIT 30");
    $t="👥 <b>کاربران</b>\n"; foreach($s as $r){ $nm=$r['name']?:'—'; $t.="\n• {$nm} | {$r['role']} | {$r['status']}"; }
    sendMessage($cid,$t,[ [ ['text'=>'↩️ بازگشت','callback_data'=>'ceo_menu'] ] ]); exit;
  }

  // Accountant
  if($data==='acc_menu'){ accMenu($cid); exit; }
  if($data==='acc_unpaid'){
    global $pdo; $s=$pdo->query("SELECT id,user_tg,amount FROM invoices WHERE status='unpaid' ORDER BY id DESC LIMIT 10");
    $t="🧾 <b>فاکتورهای پرداخت‌نشده</b>\n"; $kb=[];
    foreach($s as $r){ $t.="\n• #{$r['id']} | ".number_format($r['amount'])." ریال | TG: {$r['user_tg']}"; $kb[]=[ ['text'=>"💵 ثبت پرداخت #{$r['id']}",'callback_data'=>"acc_pay_".$r['id']] ]; }
    $kb[]=[ ['text'=>'↩️ بازگشت','callback_data'=>'acc_menu'] ]; sendMessage($cid,$t,$kb); exit;
  }
  if($data==='acc_new_invoice'){ setState($cid,'acc_inv_target',[]); sendMessage($cid,"👤 tg_id مقصد؟"); exit; }
  if($data==='acc_new_payment'){ setState($cid,'acc_pay_invoice',[]); sendMessage($cid,"🧾 شماره فاکتور؟"); exit; }
  if(strpos($data,'acc_pay_')===0){ $iid=intval(substr($data,8)); setState($cid,'acc_pay_amount',['invoice_id'=>$iid]); sendMessage($cid,"💵 مبلغ پرداخت برای #{$iid}?"); exit; }

  // Admin
  if($data==='ad_menu'){ adMenu($cid); exit; }
  if($data==='ad_products'){
    global $pdo; $s=$pdo->query("SELECT id,title,price,active FROM products ORDER BY id DESC LIMIT 12");
    $t="🛍 <b>محصولات</b>\n"; $kb=[]; foreach($s as $r){ $st=$r['active']?'فعال ✅':'⛔'; $t.="\n• #{$r['id']} | {$r['title']} | ".number_format($r['price'])." | {$st}"; $kb[]=[ ['text'=>"✏️ ویرایش #{$r['id']}",'callback_data'=>"ad_edit_".$r['id']], ['text'=>$r['active']?'⛔ غیرفعال':'✅ فعال','callback_data'=>"ad_toggle_".$r['id']] ]; } $kb[]=[ ['text'=>'↩️ بازگشت','callback_data'=>'ad_menu'] ]; sendMessage($cid,$t,$kb); exit;
  }
  if($data==='ad_orders'){
    global $pdo; $s=$pdo->query("SELECT id,total,status,created_at FROM orders ORDER BY id DESC LIMIT 10");
    $t="📦 <b>سفارش‌ها</b>\n"; $kb=[]; foreach($s as $r){ $t.="\n• #{$r['id']} | ".number_format($r['total'])." | {$r['status']} | ".dt($r['created_at']); $kb[]=[ ['text'=>'⏳ پردازش','callback_data'=>"ad_ord_status_{$r['id']}_processing"], ['text'=>'✅ تحویل','callback_data'=>"ad_ord_status_{$r['id']}_done"], ['text'=>'❌ لغو','callback_data'=>"ad_ord_status_{$r['id']}_canceled"] ]; } $kb[]=[ ['text'=>'↩️ بازگشت','callback_data'=>'ad_menu'] ]; sendMessage($cid,$t,$kb); exit;
  }
  if($data==='ad_new_product'){ setState($cid,'ad_new_title',[]); sendMessage($cid,"📝 عنوان محصول؟"); exit; }
  if($data==='ad_toggle_product'){ setState($cid,'ad_toggle_id',[]); sendMessage($cid,"🔢 شناسه محصول برای فعال/غیرفعال؟"); exit; }
  if(strpos($data,'ad_toggle_')===0){ global $pdo; $pid=intval(substr($data,10)); $pdo->prepare("UPDATE products SET active=1-active WHERE id=?")->execute([$pid]); sendMessage($cid,"🔁 وضعیت محصول #{$pid} تغییر کرد."); exit; }
  if(strpos($data,'ad_edit_')===0){ $pid=intval(substr($data,8)); setState($cid,'ad_edit_title',['pid'=>$pid]); sendMessage($cid,"✏️ عنوان جدید محصول #{$pid}:"); exit; }
  if(strpos($data,'ad_ord_status_')===0){ $parts=explode('_',$data); $oid=(int)$parts[3]; $st=$parts[4]; if(!in_array($st,['processing','done','canceled'])){ sendMessage($cid,"⚠️ وضعیت نامعتبر."); exit; } global $pdo; $pdo->prepare("UPDATE orders SET status=? WHERE id=?")->execute([$st,$oid]); sendMessage($cid,"✅ سفارش #{$oid} → {$st}"); exit; }

  // Department Manager
  if($data==='dm_menu'){ dmMenu($cid); exit; }
  if($data==='dm_new_project'){ setState($cid,'dm_new_project_title',[]); sendMessage($cid,"🆕 عنوان پروژه؟"); exit; }
  if($data==='dm_my_projects'){
    global $pdo; $s=$pdo->prepare("SELECT id,title,status,created_at FROM projects WHERE manager_tg=? ORDER BY id DESC LIMIT 10"); $s->execute([$cid]);
    $t="📂 <b>پروژه‌های من</b>\n"; $kb=[];
    foreach($s as $r){ $t.="\n• #{$r['id']} | {$r['title']} | {$r['status']} | ".dt($r['created_at']); $kb[]=[ ['text'=>"🔎 جزئیات #{$r['id']}",'callback_data'=>"dm_proj_".$r['id']] ]; }
    $kb[]=[ ['text'=>'↩️ بازگشت','callback_data'=>'dm_menu'] ]; sendMessage($cid,$t,$kb); exit;
  }
  if(strpos($data,'dm_proj_')===0){
    global $pdo; $pid=intval(substr($data,8));
    $p=$pdo->prepare("SELECT * FROM projects WHERE id=? AND manager_tg=?"); $p->execute([$pid,$cid]); if(!$pr=$p->fetch()){ sendMessage($cid,"⚠️ پروژه یافت نشد."); exit; }
    $txt="🔎 <b>پروژه #{$pr['id']}</b>\nعنوان: <b>{$pr['title']}</b>\nوضعیت: <b>{$pr['status']}</b>\n—\n<b>تسک‌ها:</b>";
    $t=$pdo->prepare("SELECT t.id,t.title,t.status,u.name AS ass_name FROM tasks t LEFT JOIN users u ON u.tg_id=t.assignee_tg WHERE t.project_id=? ORDER BY t.id DESC"); $t->execute([$pid]);
    foreach($t as $r){ $who=$r['ass_name']?:'—'; $txt.="\n• #{$r['id']} {$r['title']} | {$r['status']} | {$who}"; }
    $kb=[ [ ['text'=>'📝 افزودن تسک','callback_data'=>"dm_new_task_proj_".$pid], ['text'=>'✅ بستن پروژه','callback_data'=>"dm_proj_close_".$pid] ], [ ['text'=>'↩️ بازگشت','callback_data'=>'dm_menu'] ] ];
    sendMessage($cid,$txt,$kb); exit;
  }
  if($data==='dm_new_task'){ setState($cid,'dm_new_task_project',[]); sendMessage($cid,"🔢 شماره پروژه؟"); exit; }
  if(strpos($data,'dm_new_task_proj_')===0){ $pid=intval(substr($data,17)); setState($cid,'dm_new_task_title',['project_id'=>$pid]); sendMessage($cid,"📝 عنوان تسک:"); exit; }
  if(strpos($data,'dm_proj_close_')===0){ global $pdo; $pid=intval(substr($data,14)); $pdo->prepare("UPDATE projects SET status='done' WHERE id=? AND manager_tg=?")->execute([$pid,$cid]); sendMessage($cid,"✅ پروژه #{$pid} بسته شد."); exit; }

  // Reminders
  if($data==='rem_menu'){ remMenu($cid); exit; }
  if($data==='rem_new'){ setState($cid,'rem_new_target',[]); sendMessage($cid,"👤 TG ID گیرنده را بفرست:"); exit; }
  if($data==='rem_list'){ remList($cid,1); exit; }
  if(strpos($data,'rem_list_')===0){ $p=max(1,intval(substr($data,9))); remList($cid,$p); exit; }
  if($data==='rem_cancel'){ setState($cid,'rem_cancel_id',[]); sendMessage($cid,"🗑 شماره یادآور (ID) را بفرست:"); exit; }

  // Customer shop
  if($data==='cust_shop'){ shopList($cid,1); exit; }
  if(strpos($data,'shop_page_')===0){ $p=max(1,intval(substr($data,10))); shopList($cid,$p); exit; }
  if(strpos($data,'shop_add_')===0){ $pid=intval(substr($data,9)); setState($cid,'cart_qty',['pid'=>$pid]); sendMessage($cid,"🔢 تعداد؟ (مثلاً 1)"); exit; }
  if($data==='cust_cart'){ cartRender($cid); exit; }
  if($data==='cart_clear'){ cartClear($cid); sendMessage($cid,"🧹 سبد خالی شد."); exit; }
  if(strpos($data,'cart_inc_')===0){ cartAdd($cid,intval(substr($data,9)),1); cartRender($cid); exit; }
  if(strpos($data,'cart_dec_')===0){ cartAdd($cid,intval(substr($data,9)),-1); cartRender($cid); exit; }
  if(strpos($data,'cart_del_')===0){ cartAdd($cid,intval(substr($data,9)),-9999); cartRender($cid); exit; }
  if($data==='cart_checkout'){ cartCheckout($cid); exit; }
  if($data==='cust_track'){ trackOrders($cid); exit; }
  if($data==='cust_support'){ sendMessage($cid,"🎫 پیام‌تان را همین‌جا بنویسید."); exit; }

  // Approve/Reject staff
  if(strpos($data,'approve_')===0 || strpos($data,'reject_')===0){
    if(!isApprover($cid)){ sendMessage($cid,"⛔ دسترسی ندارید."); exit; }
    $tg=intval(substr($data,strpos($data,'_')+1)); $e=getUser($tg); if(!$e){ sendMessage($cid,"⚠️ کاربر یافت نشد."); exit; }
    if(strpos($data,'approve_')===0){ upUser($tg,'status','approved'); sendMessage($tg,"🎉 پرونده شما تأیید شد!"); sendMessage($cid,"✅ تأیید شد."); }
    else { sendMessage($tg,"❌ پرونده شما رد شد."); sendMessage($cid,"⛔ رد شد."); }
    exit;
  }
}

/* ==== POST-TEXT for delete reminder & admin toggle & shop qty ==== */
if(isset($update['message'])){
  $m=$update['message']; $cid=$m['chat']['id']; $text=trim($m['text']??'');
  list($state,$data)=getState($cid);
  if($state==='rem_cancel_id'){ if(!preg_match('/^[0-9]+$/',$text)){ sendMessage($cid,"⚠️ عدد ID را درست بفرست."); exit; } $GLOBALS['pdo']->prepare("DELETE FROM reminders WHERE id=?")->execute([(int)$text]); clearState($cid); sendMessage($cid,"🗑 یادآور #{$text} حذف شد."); exit; }
  if($state==='ad_toggle_id'){ if(!preg_match('/^[0-9]+$/',$text)){ sendMessage($cid,"⚠️ شناسه محصول؟"); exit; } $pid=(int)$text; $GLOBALS['pdo']->prepare("UPDATE products SET active=1-active WHERE id=?")->execute([$pid]); clearState($cid); sendMessage($cid,"🔁 وضعیت محصول #{$pid} تغییر کرد."); exit; }
  if($state==='cart_qty'){ if(!preg_match('/^[1-9][0-9]*$/',$text)){ sendMessage($cid,"⚠️ عدد معتبر؟"); exit; } $qty=(int)$text; $pid=(int)$data['pid']; cartAdd($cid,$pid,$qty); clearState($cid); sendMessage($cid,"✅ اضافه شد."); cartRender($cid); exit; }
}
?>
