<?php
require_once 'config.php';
/* ==== Jalali (شمسی) ==== */
$USE_JALALI = true;
function greg2jal($gy,$gm,$gd){
  $g_d_m=[0,31,($gy%4==0&&$gy%100!=0)||($gy%400==0)?29:28,31,30,31,30,31,31,30,31,30,31];
  $gy2=$gy-1600;$gm2=$gm-1;$gd2=$gd-1;
  $g_day=365*$gy2+intdiv($gy2+3,4)-intdiv($gy2+99,100)+intdiv($gy2+399,400);
  for($i=0;$i<$gm2;++$i)$g_day+=$g_d_m[$i+1]; $g_day+=$gd2; $j_day=$g_day-79;
  $j_np=intdiv($j_day,12053); $j_day%=12053;
  $jy=979+33*$j_np+4*intdiv($j_day,1461); $j_day%=1461;
  if($j_day>=366){ $jy+=intdiv($j_day-1,365); $j_day=($j_day-1)%365; }
  $jm=($j_day<186)?1+intdiv($j_day,31):7+intdiv($j_day-186,30);
  $jd=1+(($j_day<186)?$j_day%31:($j_day-186)%30);
  return [$jy,$jm,$jd];
}
function jdate($dt){ if(!$dt)return''; $p=explode(' ',trim($dt));
  [$y,$m,$d]=array_map('intval',explode('-',$p[0])); [$jy,$jm,$jd]=greg2jal($y,$m,$d);
  $date=sprintf('%04d/%02d/%02d',$jy,$jm,$jd);
  return (count($p)>1)? $date.' '.substr($p[1],0,5) : $date;
}
function dt($greg){ global $USE_JALALI; return $USE_JALALI? jdate($greg) : $greg; }

/* ==== Simple PDF (بدون لایبرری) ==== */
function _pdf_esc($s){ return str_replace(['\\','(',')'],['\\\\','\\(','\\)'],$s); }
function _pdf_make_table($title,$headers,$rows){
  $w=595;$h=842;$left=40;$top=780;
  $text="BT /F1 14 Tf 1 0 0 1 {$left} {$top} Tm (". _pdf_esc($title) .") Tj T* /F1 10 Tf ";
  $text.="(--------------------------------) Tj T* (". _pdf_esc(implode(' | ',$headers)) .") Tj T* (--------------------------------) Tj T* ";
  foreach($rows as $r){ $line=implode(' | ',array_map(function($x){return str_replace(["\r","\n"],' ',(string)$x);},$r)); $text.="(". _pdf_esc($line) .") Tj T* "; }
  $text.="ET";
  $objs=[];
  $objs[]="1 0 obj << /Type /Catalog /Pages 2 0 R >> endobj";
  $objs[]="2 0 obj << /Type /Pages /Kids [3 0 R] /Count 1 >> endobj";
  $objs[]="3 0 obj << /Type /Page /Parent 2 0 R /MediaBox [0 0 {$w} {$h}] /Contents 4 0 R /Resources << /Font << /F1 5 0 R >> >> >> endobj";
  $objs[]="4 0 obj << /Length ".strlen($text)." >> stream\n{$text}\nendstream endobj";
  $objs[]="5 0 obj << /Type /Font /Subtype /Type1 /BaseFont /Helvetica >> endobj";
  $pdf="%PDF-1.4\n"; $xref="xref\n0 ".(count($objs)+1)."\n0000000000 65535 f \n"; $pos=strlen($pdf); $ofs=[];
  foreach($objs as $i=>$o){ $ofs[$i+1]=$pos; $pdf.=$o."\n"; $pos=strlen($pdf); }
  foreach($ofs as $o){ $xref.=sprintf("%010d 00000 n \n",$o); }
  $tr="trailer << /Size ".(count($objs)+1)." /Root 1 0 R >>\nstartxref\n".$pos."\n%%EOF";
  return $pdf.$xref.$tr;
}
function pdf_send($chat_id,$filename,$title,$headers,$rows){
  $dir=__DIR__.'/tmp'; if(!is_dir($dir)) @mkdir($dir,0775,true);
  $path=$dir.'/'.$filename; file_put_contents($path,_pdf_make_table($title,$headers,$rows));
  $cFile=new CURLFile($path,'application/pdf',basename($path));
  api('sendDocument',['chat_id'=>$chat_id,'document'=>$cFile,'caption'=>$title]);
}

/* ===== Telegram ===== */
$RAW = file_get_contents('php://input');
file_put_contents('updatelog.txt',$RAW."\n----\n",FILE_APPEND);
$update = json_decode($RAW,true); if(!$update) exit;

function api($m,$p=[]){ global $botToken;
  $ch=curl_init("https://api.telegram.org/bot{$botToken}/{$m}");
  curl_setopt_array($ch,[CURLOPT_RETURNTRANSFER=>true, CURLOPT_POST=>true, CURLOPT_POSTFIELDS=>$p, CURLOPT_CONNECTTIMEOUT=>10, CURLOPT_TIMEOUT=>30]);
  $r=curl_exec($ch); if($r===false) file_put_contents('error_log.txt',"cURL: ".curl_error($ch)."\n",FILE_APPEND);
  curl_close($ch); return $r;
}
function sendMessage($cid,$t,$kb=null){ $p=['chat_id'=>$cid,'text'=>$t,'parse_mode'=>'HTML']; if($kb)$p['reply_markup']=json_encode(['inline_keyboard'=>$kb],JSON_UNESCAPED_UNICODE); api('sendMessage',$p); }
function sendDocument($cid,$path,$caption=''){ $c=new CURLFile($path,mime_content_type($path),basename($path)); api('sendDocument',['chat_id'=>$cid,'document'=>$c,'caption'=>$caption]); }
function answerCb($id,$t=''){ api('answerCallbackQuery',['callback_query_id'=>$id,'text'=>$t]); }

/* ===== Helpers ===== */
function greeting(){ $h=intval(date('H')); if($h>=5&&$h<12)return"☀️ صبح بخیر"; if($h>=12&&$h<17)return"🌞 ظهر بخیر"; if($h>=17&&$h<21)return"🌇 عصر بخیر"; if($h>=21||$h<2)return"🌙 شب بخیر"; return"🌌 بامداد بخیر"; }
function welcomeText(){ return greeting()." دوست خوبم 💛\nبه <b>دستیار هوشمند ویژن مدیا</b> خوش اومدی!\nنقش خودت رو انتخاب کن:"; }

function getUser($tg){ global $pdo;$s=$pdo->prepare("SELECT * FROM users WHERE tg_id=?");$s->execute([$tg]);return $s->fetch(); }
function upUser($tg,$f,$v){ global $pdo;$s=$pdo->prepare("UPDATE users SET {$f}=? WHERE tg_id=?");$s->execute([$v,$tg]); }
function addUser($tg,$role,$st){ global $pdo;$s=$pdo->prepare("INSERT INTO users(tg_id,role,status) VALUES(?,?,?)");$s->execute([$tg,$role,$st]); }

function setState($tg,$st,$data=[]){ global $pdo;$j=json_encode($data,JSON_UNESCAPED_UNICODE);$q=$pdo->prepare("REPLACE INTO bot_states(tg_id,state,data) VALUES(?,?,?)");$q->execute([$tg,$st,$j]); }
function getState($tg){ global $pdo;$q=$pdo->prepare("SELECT state,data FROM bot_states WHERE tg_id=?");$q->execute([$tg]); if(!$r=$q->fetch()) return [null,[]]; return [$r['state'],json_decode($r['data']?:'[]',true)]; }
function clearState($tg){ global $pdo;$pdo->prepare("DELETE FROM bot_states WHERE tg_id=?")->execute([$tg]); }

function isApprover($tg){ global $pdo,$adminId; if($tg==$adminId)return true; $s=$pdo->prepare("SELECT 1 FROM users WHERE tg_id=? AND role='Accountant' AND status='approved' LIMIT 1");$s->execute([$tg]);return (bool)$s->fetchColumn(); }
function notifyApprovers($emp){
  global $pdo,$adminId;
  $cid=$emp['tg_id']; $name=$emp['name']??'—'; $phone=$emp['phone']??'—'; $role=$emp['role']??'—';
  $kb=[ [ ['text'=>'✅ تأیید','callback_data'=>'approve_'.$cid], ['text'=>'❌ رد','callback_data'=>'reject_'.$cid] ] ];
  $msg="👤 <b>پرسنل جدید</b>\nنام: <b>{$name}</b>\nنقش: <b>{$role}</b>\nموبایل: <b>{$phone}</b>\n—\nآیا تأیید می‌کنید؟";
  sendMessage($adminId,$msg,$kb);
  foreach($pdo->query("SELECT tg_id FROM users WHERE role='Accountant' AND status='approved'") as $r){
    if($r['tg_id']!=$adminId) sendMessage($r['tg_id'],$msg,$kb);
  }
}

/* ===== Menus ===== */
function customerMenu($cid){
  $kb=[
    [ ['text'=>'🛒 فروشگاه','callback_data'=>'cust_shop'], ['text'=>'🧺 سبد خرید','callback_data'=>'cust_cart'], ['text'=>'📦 پیگیری سفارش','callback_data'=>'cust_track'] ],
    [ ['text'=>'🎫 پشتیبانی','callback_data'=>'cust_support'] ]
  ];
  sendMessage($cid,"✅ خوش اومدی! از منوی زیر یکی رو انتخاب کن:",$kb);
}
function ceoMenu($cid){
  $kb=[
    [ ['text'=>'📊 داشبورد','callback_data'=>'ceo_dashboard'], ['text'=>'🧾 Pending','callback_data'=>'ceo_pending'], ['text'=>'👥 کاربران','callback_data'=>'ceo_users'] ],
    [ ['text'=>'⬇️ خروجی CSV','callback_data'=>'ceo_export_menu'], ['text'=>'📄 خروجی PDF','callback_data'=>'ceo_export_pdf_menu'] ],
    [ ['text'=>'💰 حسابدار','callback_data'=>'acc_menu'], ['text'=>'🧩 مدیر دپارتمان','callback_data'=>'dm_menu'], ['text'=>'🛠 ادمین','callback_data'=>'ad_menu'] ],
    [ ['text'=>'🏠 شروع','callback_data'=>'back_home'] ]
  ];
  sendMessage($cid,"👑 <b>پنل مدیرعامل</b>",$kb);
}

function ceoExportMenu($cid){
  $kb=[
    [ ['text'=>'👥 کاربران','callback_data'=>'exp_users'], ['text'=>'📦 سفارش‌ها','callback_data'=>'exp_orders'], ['text'=>'🧾 فاکتورها','callback_data'=>'exp_invoices'] ],
    [ ['text'=>'💳 پرداخت‌ها','callback_data'=>'exp_payments'], ['text'=>'📂 پروژه‌ها','callback_data'=>'exp_projects'], ['text'=>'📝 تسک‌ها','callback_data'=>'exp_tasks'] ],
    [ ['text'=>'↩️ بازگشت','callback_data'=>'ceo_menu'] ]
  ];
  sendMessage($cid,"⬇️ انتخاب فایل خروجی CSV:",$kb);
}
function ceoExportPdfMenu($cid){
  $kb=[
    [ ['text'=>'👥 کاربران (PDF)','callback_data'=>'exp_users_pdf'], ['text'=>'📦 سفارش‌ها (PDF)','callback_data'=>'exp_orders_pdf'] ],
    [ ['text'=>'🧾 فاکتورها (PDF)','callback_data'=>'exp_invoices_pdf'], ['text'=>'💳 پرداخت‌ها (PDF)','callback_data'=>'exp_payments_pdf'] ],
    [ ['text'=>'📂 پروژه‌ها (PDF)','callback_data'=>'exp_projects_pdf'], ['text'=>'📝 تسک‌ها (PDF)','callback_data'=>'exp_tasks_pdf'] ],
    [ ['text'=>'↩️ بازگشت','callback_data'=>'ceo_menu'] ]
  ];
  sendMessage($cid,"📄 انتخاب خروجی PDF:",$kb);
}
function exportUsersPdf($cid){
  global $pdo; $r=$pdo->query("SELECT id,tg_id,name,phone,role,status,created_at FROM users ORDER BY id DESC")->fetchAll();
  $rows=[]; foreach($r as $x){ $rows[]=[ $x['id'],$x['tg_id'],$x['name'],$x['phone'],$x['role'],$x['status'], dt($x['created_at']) ]; }
  pdf_send($cid,'users.pdf','👥 کاربران',['ID','TG','نام','موبایل','نقش','وضعیت','تاریخ'],$rows);
}
function exportOrdersPdf($cid){
  global $pdo; $r=$pdo->query("SELECT id,user_tg,total,status,created_at FROM orders ORDER BY id DESC")->fetchAll();
  $rows=[]; foreach($r as $x){ $rows[]=[ $x['id'],$x['user_tg'],number_format($x['total']),$x['status'], dt($x['created_at']) ]; }
  pdf_send($cid,'orders.pdf','📦 سفارش‌ها',['ID','TG','جمع','وضعیت','تاریخ'],$rows);
}
function exportInvoicesPdf($cid){
  global $pdo; $r=$pdo->query("SELECT id,user_tg,created_by,amount,status,created_at FROM invoices ORDER BY id DESC")->fetchAll();
  $rows=[]; foreach($r as $x){ $rows[]=[ $x['id'],$x['user_tg'],$x['created_by'],number_format($x['amount']),$x['status'], dt($x['created_at']) ]; }
  pdf_send($cid,'invoices.pdf','🧾 فاکتورها',['ID','TG مشتری','ایجادکننده','مبلغ','وضعیت','تاریخ'],$rows);
}
function exportPaymentsPdf($cid){
  global $pdo; $r=$pdo->query("SELECT id,invoice_id,amount,paid_by,created_at FROM payments ORDER BY id DESC")->fetchAll();
  $rows=[]; foreach($r as $x){ $rows[]=[ $x['id'],$x['invoice_id'],number_format($x['amount']),$x['paid_by'], dt($x['created_at']) ]; }
  pdf_send($cid,'payments.pdf','💳 پرداخت‌ها',['ID','فاکتور','مبلغ','پرداخت‌کننده','تاریخ'],$rows);
}
function exportProjectsPdf($cid){
  global $pdo; $r=$pdo->query("SELECT id,title,manager_tg,status,created_at FROM projects ORDER BY id DESC")->fetchAll();
  $rows=[]; foreach($r as $x){ $rows[]=[ $x['id'],$x['title'],$x['manager_tg'],$x['status'], dt($x['created_at']) ]; }
  pdf_send($cid,'projects.pdf','📂 پروژه‌ها',['ID','عنوان','مدیر','وضعیت','تاریخ'],$rows);
}
function exportTasksPdf($cid){
  global $pdo; $r=$pdo->query("SELECT id,project_id,title,assignee_tg,status,due_date,created_at FROM tasks ORDER BY id DESC")->fetchAll();
  $rows=[]; foreach($r as $x){ $rows[]=[ $x['id'],$x['project_id'],$x['title'],$x['assignee_tg'],$x['status'], $x['due_date']? jdate($x['due_date']) : '-', dt($x['created_at']) ]; }
  pdf_send($cid,'tasks.pdf','📝 تسک‌ها',['ID','پروژه','عنوان','مسئول','وضعیت','موعد','ثبت'],$rows);
}

function accMenu($cid){
  $kb=[
    [ ['text'=>'➕ صدور فاکتور','callback_data'=>'acc_new_invoice'], ['text'=>'🧾 فاکتورهای پرداخت‌نشده','callback_data'=>'acc_unpaid'], ['text'=>'💵 ثبت پرداخت','callback_data'=>'acc_new_payment'] ],
    [ ['text'=>'👥 کاربران','callback_data'=>'acc_users'], ['text'=>'⬇️ خروجی پرداخت‌ها','callback_data'=>'exp_payments'] ],
    [ ['text'=>'🏠 شروع','callback_data'=>'back_home'] ]
  ];
  sendMessage($cid,"💰 <b>پنل حسابدار</b>",$kb);
}
function adMenu($cid){
  $kb=[
    [ ['text'=>'🛍 لیست محصولات','callback_data'=>'ad_products'], ['text'=>'➕ محصول جدید','callback_data'=>'ad_new_product'], ['text'=>'⛔/✅ وضعیت محصول','callback_data'=>'ad_toggle_product'] ],
    [ ['text'=>'📦 سفارش‌ها','callback_data'=>'ad_orders'], ['text'=>'⬇️ خروجی سفارش‌ها','callback_data'=>'exp_orders'] ],
    [ ['text'=>'🏠 شروع','callback_data'=>'back_home'] ]
  ];
  sendMessage($cid,"🛠 <b>پنل ادمین</b>",$kb);
}
function dmMenu($cid){
  $kb=[
    [ ['text'=>'🆕 ساخت پروژه','callback_data'=>'dm_new_project'], ['text'=>'📂 پروژه‌های من','callback_data'=>'dm_my_projects'], ['text'=>'📝 افزودن تسک','callback_data'=>'dm_new_task'] ],
    [ ['text'=>'📋 تسک‌های تیم من','callback_data'=>'dm_team_tasks'], ['text'=>'⬇️ خروجی پروژه/تسک','callback_data'=>'dm_export'] ],
    [ ['text'=>'🏠 شروع','callback_data'=>'back_home'] ]
  ];
  sendMessage($cid,"🧩 <b>پنل مدیر دپارتمان</b>",$kb);
}

/* ===== Shop ===== */
function shopList($cid,$page=1){
  global $pdo; $limit=6;$off=($page-1)*$limit;
  $s=$pdo->prepare("SELECT id,title,price FROM products WHERE active=1 ORDER BY id ASC LIMIT :o,:l");
  $s->bindValue(':o',$off,PDO::PARAM_INT);$s->bindValue(':l',$limit,PDO::PARAM_INT);$s->execute();$rows=$s->fetchAll();
  if(!$rows){ sendMessage($cid,"📭 محصولی موجود نیست."); return; }
  $txt="🛒 <b>فروشگاه ویژن مدیا</b>\nبرای افزودن به سبد، روی دکمه هر محصول بزن:";
  $kb=[]; foreach($rows as $r){ $kb[]=[ ['text'=>"➕ {$r['title']} — ".number_format($r['price'])." ریال",'callback_data'=>"shop_add_".$r['id']] ]; }
  $nav=[]; if($page>1)$nav[]=['text'=>'⬅️ قبلی','callback_data'=>'shop_page_'.($page-1)]; $nav[]=['text'=>'🧺 سبد','callback_data'=>'cust_cart']; $nav[]=['text'=>'خالی','callback_data'=>'cart_clear']; if(count($rows)==$limit)$nav[]=['text'=>'بعدی ➡️','callback_data'=>'shop_page_'.($page+1)]; $kb[]=$nav;
  sendMessage($cid,$txt,$kb);
}
function cartGet($cid){ list($st,$d)=getState($cid); return $d['cart']??[]; }
function cartSave($cid,$cart){ list($st,$d)=getState($cid); if(!$st)$st='cart'; $d['cart']=$cart; setState($cid,$st,$d); }
function cartAdd($cid,$pid,$q){ $c=cartGet($cid); $c[$pid]=($c[$pid]??0)+$q; if($c[$pid]<=0)unset($c[$pid]); cartSave($cid,$c); }
function cartClear($cid){ list($st,$d)=getState($cid); $d['cart']=[]; if(!$st)$st='cart'; setState($cid,$st,$d); }
function cartRender($cid){
  global $pdo; $c=cartGet($cid); if(!$c){ sendMessage($cid,"🧺 سبد شما خالی است."); return; }
  $ids=implode(',',array_map('intval',array_keys($c))); $q=$pdo->query("SELECT id,title,price FROM products WHERE id IN ($ids)"); $p=[]; foreach($q as $r){$p[$r['id']]=$r;}
  $txt="🧺 <b>سبد خرید</b>\n"; $tot=0; $kb=[];
  foreach($c as $pid=>$qty){ if(!isset($p[$pid]))continue; $line=$p[$pid]['title']." × ".$qty." = ".number_format($p[$pid]['price']*$qty)." ریال"; $txt.="\n• ".$line; $tot+=$p[$pid]['price']*$qty;
    $kb[]=[ ['text'=>"➖",'callback_data'=>"cart_dec_".$pid], ['text'=>"➕",'callback_data'=>"cart_inc_".$pid], ['text'=>"🗑",'callback_data'=>"cart_del_".$pid] ];
  }
  $txt.="\n\n💵 جمع کل: <b>".number_format($tot)." ریال</b>";
  $kb[]=[ ['text'=>'🧾 ثبت سفارش','callback_data'=>'cart_checkout'], ['text'=>'🛒 ادامه خرید','callback_data'=>'cust_shop'], ['text'=>'🧹 خالی','callback_data'=>'cart_clear'] ];
  sendMessage($cid,$txt,$kb);
}
function cartCheckout($cid){
  global $pdo; $u=getUser($cid);
  if(!$u||empty($u['name'])||empty($u['phone'])){ sendMessage($cid,"⚠️ ابتدا ثبت‌نام مشتری را کامل کن (نام و شماره)."); return; }
  $c=cartGet($cid); if(!$c){ sendMessage($cid,"🧺 سبد شما خالی است."); return; }
  $ids=implode(',',array_map('intval',array_keys($c))); $q=$pdo->query("SELECT id,title,price FROM products WHERE id IN ($ids)"); $p=[]; foreach($q as $r){$p[$r['id']]=$r;}
  $tot=0; foreach($c as $pid=>$qty){ if(isset($p[$pid])) $tot+=$p[$pid]['price']*$qty; }
  $pdo->prepare("INSERT INTO orders(user_tg,total,status) VALUES(?,?,'new')")->execute([$cid,$tot]); $oid=$pdo->lastInsertId();
  $ins=$pdo->prepare("INSERT INTO order_items(order_id,product_id,qty,price) VALUES(?,?,?,?)");
  foreach($c as $pid=>$qty){ if(isset($p[$pid])) $ins->execute([$oid,$pid,$qty,$p[$pid]['price']]); }
  cartClear($cid); sendMessage($cid,"🎉 سفارش ثبت شد. شماره: #{$oid} | وضعیت: جدید");
}
function trackOrders($cid){
  global $pdo; $s=$pdo->prepare("SELECT id,total,status,created_at FROM orders WHERE user_tg=? ORDER BY id DESC LIMIT 10"); $s->execute([$cid]); $rows=$s->fetchAll();
  if(!$rows){ sendMessage($cid,"📦 سفارشی ندارید."); return; }
  $t="📦 <b>سفارش‌های شما</b>\n"; foreach($rows as $r){ $t.="\n• #{$r['id']} | ".number_format($r['total'])." ریال | {$r['status']}"; } sendMessage($cid,$t);
}

/* ===== Dashboard & CSV exports ===== */
function ceoDashboard($cid){
  global $pdo;
  $totUsers=(int)$pdo->query("SELECT COUNT(*) c FROM users")->fetch()['c'];
  $approved=(int)$pdo->query("SELECT COUNT(*) c FROM users WHERE status='approved'")->fetch()['c'];
  $pending=(int)$pdo->query("SELECT COUNT(*) c FROM users WHERE status='pending'")->fetch()['c'];
  $customers=(int)$pdo->query("SELECT COUNT(*) c FROM users WHERE role='Customer'")->fetch()['c'];
  $ord=$pdo->query("SELECT SUM(total) tot, COUNT(*) cnt FROM orders")->fetch(); $totSales=(int)($ord['tot']??0); $cntOrders=(int)($ord['cnt']??0);
  $invSum=(int)($pdo->query("SELECT SUM(amount) s FROM invoices")->fetch()['s']??0);
  $paySum=(int)($pdo->query("SELECT SUM(amount) s FROM payments")->fetch()['s']??0);
  $proj=$pdo->query("SELECT SUM(status='open') o, SUM(status='in_progress') p, SUM(status='done') d FROM projects")->fetch();
  $task=$pdo->query("SELECT SUM(status='todo') t, SUM(status='doing') g, SUM(status='done') dd FROM tasks")->fetch();
  $txt="📊 <b>داشبورد</b>\n👥 کاربران: کل <b>{$totUsers}</b> | تأیید <b>{$approved}</b> | انتظار <b>{$pending}</b> | مشتری <b>{$customers}</b>\n🛒 سفارش‌ها: <b>{$cntOrders}</b> | مجموع <b>".number_format($totSales)." ریال</b>\n💰 مالی: فاکتورها <b>".number_format($invSum)."</b> | پرداخت‌ها <b>".number_format($paySum)."</b>\n📂 پروژه‌ها: باز <b>".(int)($proj['o']??0)."</b> | انجام <b>".(int)($proj['p']??0)."</b> | تمام <b>".(int)($proj['d']??0)."</b>\n📝 تسک‌ها: TODO <b>".(int)($task['t']??0)."</b> | Doing <b>".(int)($task['g']??0)."</b> | Done <b>".(int)($task['dd']??0)."</b>";
  $kb=[ [ ['text'=>'⬇️ خروجی CSV','callback_data'=>'ceo_export_menu'], ['text'=>'🧾 Pending','callback_data'=>'ceo_pending'] ], [ ['text'=>'👥 کاربران','callback_data'=>'ceo_users'], ['text'=>'🏠 منو','callback_data'=>'ceo_menu'] ] ];
  sendMessage($cid,$txt,$kb);
}
function ceoSendPending($cid,$page=1){
  global $pdo; $lim=10;$off=($page-1)*$lim;
  $s=$pdo->prepare("SELECT tg_id,name,phone,role FROM users WHERE status='pending' ORDER BY created_at DESC LIMIT :o,:l");
  $s->bindValue(':o',$off,PDO::PARAM_INT);$s->bindValue(':l',$lim,PDO::PARAM_INT);$s->execute();$rows=$s->fetchAll();
  if(!$rows){ sendMessage($cid,"✅ لیست انتظار خالی است."); return; }
  $txt="🧾 <b>در انتظار تأیید</b>\n"; $kb=[];
  foreach($rows as $r){ $nm=$r['name']?:'—'; $txt.="\n• {$nm} | {$r['role']} | {$r['phone']}"; $kb[]=[ ['text'=>"✅ تأیید {$nm}",'callback_data'=>"approve_".$r['tg_id']], ['text'=>"❌ رد",'callback_data'=>"reject_".$r['tg_id']] ]; }
  $kb[]=[ ['text'=>'↩️ بازگشت','callback_data'=>'ceo_menu'] ]; sendMessage($cid,$txt,$kb);
}
function ceoSendUsers($cid,$page=1){
  global $pdo; $lim=15;$off=($page-1)*$lim;
  $s=$pdo->prepare("SELECT tg_id,name,role,status FROM users ORDER BY created_at DESC LIMIT :o,:l");
  $s->bindValue(':o',$off,PDO::PARAM_INT);$s->bindValue(':l',$lim,PDO::PARAM_INT);$s->execute();$rows=$s->fetchAll();
  if(!$rows){ sendMessage($cid,"📭 کاربری نیست."); return; }
  $t="👥 <b>کاربران</b>\n"; foreach($rows as $r){ $nm=$r['name']?:'—'; $t.="\n• {$nm} | {$r['role']} | {$r['status']}"; }
  sendMessage($cid,$t,[ [ ['text'=>'↩️ بازگشت','callback_data'=>'ceo_menu'] ] ]);
}

/* ===== CSV exports ===== */
function csvTemp($filename,$headers,$rows){
  $dir=__DIR__.'/tmp'; if(!is_dir($dir)) @mkdir($dir,0775,true);
  $path=$dir.'/'.$filename;
  $f=fopen($path,'w'); fprintf($f,chr(0xEF).chr(0xBB).chr(0xBF)); // UTF-8 BOM
  fputcsv($f,$headers);
  foreach($rows as $r){ fputcsv($f,$r); }
  fclose($f); return $path;
}
function exportUsers($cid){
  global $pdo; $rows=$pdo->query("SELECT id,tg_id,name,phone,role,status,created_at FROM users ORDER BY id DESC")->fetchAll();
  $data=[]; foreach($rows as $r){ $data[]=[ $r['id'],$r['tg_id'],$r['name'],$r['phone'],$r['role'],$r['status'],$r['created_at'] ]; }
  $p=csvTemp('users.csv',['id','tg_id','name','phone','role','status','created_at'],$data); sendDocument($cid,$p,'👥 users.csv');
}
function exportOrders($cid){
  global $pdo; $rows=$pdo->query("SELECT id,user_tg,total,status,created_at FROM orders ORDER BY id DESC")->fetchAll();
  $d=[]; foreach($rows as $r){ $d[]=[ $r['id'],$r['user_tg'],$r['total'],$r['status'],$r['created_at'] ]; }
  $p=csvTemp('orders.csv',['id','user_tg','total','status','created_at'],$d); sendDocument($cid,$p,'📦 orders.csv');
}
function exportInvoices($cid){
  global $pdo; $rows=$pdo->query("SELECT id,user_tg,created_by,amount,status,created_at FROM invoices ORDER BY id DESC")->fetchAll();
  $d=[]; foreach($rows as $r){ $d[]=[ $r['id'],$r['user_tg'],$r['created_by'],$r['amount'],$r['status'],$r['created_at'] ]; }
  $p=csvTemp('invoices.csv',['id','user_tg','created_by','amount','status','created_at'],$d); sendDocument($cid,$p,'🧾 invoices.csv');
}
function exportPayments($cid){
  global $pdo; $rows=$pdo->query("SELECT id,invoice_id,amount,paid_by,created_at FROM payments ORDER BY id DESC")->fetchAll();
  $d=[]; foreach($rows as $r){ $d[]=[ $r['id'],$r['invoice_id'],$r['amount'],$r['paid_by'],$r['created_at'] ]; }
  $p=csvTemp('payments.csv',['id','invoice_id','amount','paid_by','created_at'],$d); sendDocument($cid,$p,'💳 payments.csv');
}
function exportProjects($cid){
  global $pdo; $rows=$pdo->query("SELECT id,title,manager_tg,status,created_at FROM projects ORDER BY id DESC")->fetchAll();
  $d=[]; foreach($rows as $r){ $d[]=[ $r['id'],$r['title'],$r['manager_tg'],$r['status'],$r['created_at'] ]; }
  $p=csvTemp('projects.csv',['id','title','manager_tg','status','created_at'],$d); sendDocument($cid,$p,'📂 projects.csv');
}
function exportTasks($cid){
  global $pdo; $rows=$pdo->query("SELECT id,project_id,title,assignee_tg,status,due_date,created_at FROM tasks ORDER BY id DESC")->fetchAll();
  $d=[]; foreach($rows as $r){ $d[]=[ $r['id'],$r['project_id'],$r['title'],$r['assignee_tg'],$r['status'],$r['due_date'],$r['created_at'] ]; }
  $p=csvTemp('tasks.csv',['id','project_id','title','assignee_tg','status','due_date','created_at'],$d); sendDocument($cid,$p,'📝 tasks.csv');
}

/* ===== Message ===== */
if(isset($update['message'])){
  $m=$update['message']; $cid=$m['chat']['id']; $text=trim($m['text']??'');
  if($text==='/start'){
    global $adminId; $isAdmin=($cid==$adminId);
    $kb=[
      [ ['text'=>'👑 مدیرعامل','callback_data'=>'role_CEO'], ['text'=>'💰 حسابدار','callback_data'=>'role_Accountant'], ['text'=>'🧩 مدیر دپارتمان','callback_data'=>'role_DepartmentManager'] ],
      [ ['text'=>'🛠 ادمین','callback_data'=>'role_Admin'], ['text'=>'🧍 مشتری','callback_data'=>'role_Customer'] ]
    ];
    $msg=welcomeText(); if($isAdmin) $msg.="\n\n👑 <b>شما مدیرعامل هستید.</b>";
    sendMessage($cid,$msg,$kb);
    $me=getUser($cid);
    if($isAdmin) ceoMenu($cid);
    if($me && $me['role']==='Accountant' && $me['status']==='approved') accMenu($cid);
    if($me && $me['role']==='DepartmentManager' && $me['status']==='approved') dmMenu($cid);
    if($me && $me['role']==='Admin' && $me['status']==='approved') adMenu($cid);
    if($me && $me['role']==='Customer') customerMenu($cid);
    exit;
  }

  $u=getUser($cid);

  // مشتری ثبت‌نام
  if($u && $u['role']==='Customer' && $u['status']==='customer'){
    if(empty($u['name'])){ if(mb_strlen($text)<2){ sendMessage($cid,"⚠️ لطفاً نام کامل را وارد کن."); exit; } upUser($cid,'name',$text); sendMessage($cid,"📱 شماره موبایل را بفرست (09XXXXXXXXX):"); exit; }
    elseif(empty($u['phone'])){ if(!preg_match('/^(09[0-9]{9})$/',$text)){ sendMessage($cid,"⚠️ فرمت شماره صحیح نیست."); exit; } upUser($cid,'phone',$text); sendMessage($cid,"🎉 ثبت‌نام کامل شد!"); customerMenu($cid); exit; }
  }

  // پرسنل pending
  if($u && $u['status']==='pending'){
    if(empty($u['name'])){ if(mb_strlen($text)<2){ sendMessage($cid,"⚠️ نام معتبر نیست."); exit; } upUser($cid,'name',$text); sendMessage($cid,"📱 شماره موبایل را بفرست:"); exit; }
    elseif(empty($u['phone'])){ if(!preg_match('/^(09[0-9]{9})$/',$text)){ sendMessage($cid,"⚠️ فرمت شماره صحیح نیست."); exit; } upUser($cid,'phone',$text); sendMessage($cid,"✅ اطلاعات ثبت شد. ⏳ منتظر تأیید مدیریت باشید."); notifyApprovers(getUser($cid)); exit; }
  }

  // States
  list($state,$data)=getState($cid);

  // Admin toggle id
  if($state==='ad_toggle_id'){
    if(!preg_match('/^[0-9]+$/',$text)){ sendMessage($cid,"⚠️ شناسه محصول؟"); exit; }
    global $pdo; $pid=(int)$text; $pdo->prepare("UPDATE products SET active=1-active WHERE id=?")->execute([$pid]); clearState($cid); sendMessage($cid,"🔁 وضعیت محصول #{$pid} تغییر کرد."); exit;
  }

  // Shop qty
  if($state==='cart_qty'){ if(!preg_match('/^[1-9][0-9]*$/',$text)){ sendMessage($cid,"⚠️ یک عدد صحیح وارد کن."); exit; } $qty=(int)$text; $pid=(int)$data['pid']; cartAdd($cid,$pid,$qty); clearState($cid); sendMessage($cid,"✅ اضافه شد."); cartRender($cid); exit; }

  sendMessage($cid,"ℹ️ /start");
  exit;
}

/* ===== Callback ===== */
if(isset($update['callback_query'])){
  $cb=$update['callback_query']; $cid=$cb['from']['id']; $data=$cb['data']; answerCb($cb['id']);
// منوی PDF
if($data==='ceo_export_pdf_menu'){ ceoExportPdfMenu($cid); exit; }

// خروجی PDF
if($data==='exp_users_pdf'){ exportUsersPdf($cid); exit; }
if($data==='exp_orders_pdf'){ exportOrdersPdf($cid); exit; }
if($data==='exp_invoices_pdf'){ exportInvoicesPdf($cid); exit; }
if($data==='exp_payments_pdf'){ exportPaymentsPdf($cid); exit; }
if($data==='exp_projects_pdf'){ exportProjectsPdf($cid); exit; }
if($data==='exp_tasks_pdf'){ exportTasksPdf($cid); exit; }

  // Role choose
  if(strpos($data,'role_')===0){
    $role=str_replace('role_','',$data); $u=getUser($cid);
    if(!$u){ if($role==='Customer'){ addUser($cid,$role,'customer'); sendMessage($cid,"📝 نام کامل؟"); } else { addUser($cid,$role,'pending'); sendMessage($cid,"📝 نام کامل برای پرونده:"); } }
    else { sendMessage($cid,"✅ نقش شما قبلاً ثبت شده."); }
    global $adminId; if($cid==$adminId) ceoMenu($cid);
    $me=getUser($cid);
    if($me && $me['role']==='Accountant' && $me['status']==='approved') accMenu($cid);
    if($me && $me['role']==='DepartmentManager' && $me['status']==='approved') dmMenu($cid);
    if($me && $me['role']==='Admin' && $me['status']==='approved') adMenu($cid);
    if($me && $me['role']==='Customer') customerMenu($cid);
    exit;
  }

  // Back home
  if($data==='back_home'){ api('sendMessage',['chat_id'=>$cid,'text'=>'/start']); exit; }

  // CEO
  if($data==='ceo_menu'){ ceoMenu($cid); exit; }
  if($data==='ceo_dashboard'){ ceoDashboard($cid); exit; }
  if($data==='ceo_pending'){ ceoSendPending($cid,1); exit; }
  if($data==='ceo_users'){ ceoSendUsers($cid,1); exit; }
  if($data==='ceo_export_menu'){ ceoExportMenu($cid); exit; }

  // Accountant
  if($data==='acc_menu'){ accMenu($cid); exit; }
  if($data==='acc_unpaid'){
    global $pdo; $s=$pdo->query("SELECT id,user_tg,amount FROM invoices WHERE status='unpaid' ORDER BY id DESC LIMIT 10");
    $t="🧾 <b>فاکتورهای پرداخت‌نشده</b>\n"; $kb=[];
    foreach($s as $r){ $t.="\n• #{$r['id']} | ".number_format($r['amount'])." ریال | TG: {$r['user_tg']}"; $kb[]=[ ['text'=>"💵 ثبت پرداخت #{$r['id']}",'callback_data'=>"acc_pay_".$r['id']] ]; }
    $kb[]=[ ['text'=>'↩️ بازگشت','callback_data'=>'acc_menu'] ]; sendMessage($cid,$t,$kb); exit;
  }
  if($data==='acc_new_invoice'){ setState($cid,'acc_inv_target',[]); sendMessage($cid,"👤 tg_id مقصد؟"); exit; }
  if($data==='acc_new_payment'){ setState($cid,'acc_pay_invoice',[]); sendMessage($cid,"🧾 شماره فاکتور؟"); exit; }
  if(strpos($data,'acc_pay_')===0){ $iid=intval(substr($data,8)); setState($cid,'acc_pay_amount',['invoice_id'=>$iid]); sendMessage($cid,"💵 مبلغ پرداخت برای #{$iid}?"); exit; }

  // Admin
  if($data==='ad_menu'){ adMenu($cid); exit; }
  if($data==='ad_products'){
    global $pdo; $s=$pdo->query("SELECT id,title,price,active FROM products ORDER BY id DESC LIMIT 12");
    $t="🛍 <b>محصولات</b>\n"; $kb=[]; foreach($s as $r){ $st=$r['active']?'فعال ✅':'⛔'; $t.="\n• #{$r['id']} | {$r['title']} | ".number_format($r['price'])." | {$st}"; $kb[]=[ ['text'=>"✏️ ویرایش #{$r['id']}",'callback_data'=>"ad_edit_".$r['id']], ['text'=>$r['active']?'⛔ غیرفعال':'✅ فعال','callback_data'=>"ad_toggle_".$r['id']] ]; } $kb[]=[ ['text'=>'↩️ بازگشت','callback_data'=>'ad_menu'] ]; sendMessage($cid,$t,$kb); exit; }
  if($data==='ad_orders'){ global $pdo; $s=$pdo->query("SELECT id,total,status FROM orders ORDER BY id DESC LIMIT 10"); $t="📦 <b>سفارش‌ها</b>\n"; $kb=[]; foreach($s as $r){ $t.="\n• #{$r['id']} | ".number_format($r['total'])." | {$r['status']}"; $kb[]=[ ['text'=>'⏳ پردازش','callback_data'=>"ad_ord_status_{$r['id']}_processing"], ['text'=>'✅ تحویل','callback_data'=>"ad_ord_status_{$r['id']}_done"], ['text'=>'❌ لغو','callback_data'=>"ad_ord_status_{$r['id']}_canceled"] ]; } $kb[]=[ ['text'=>'↩️ بازگشت','callback_data'=>'ad_menu'] ]; sendMessage($cid,$t,$kb); exit; }
  if($data==='ad_new_product'){ setState($cid,'ad_new_title',[]); sendMessage($cid,"📝 عنوان محصول؟"); exit; }
  if($data==='ad_toggle_product'){ setState($cid,'ad_toggle_id',[]); sendMessage($cid,"🔢 شناسه محصول برای فعال/غیرفعال؟"); exit; }
  if(strpos($data,'ad_toggle_')===0){ global $pdo; $pid=intval(substr($data,10)); $pdo->prepare("UPDATE products SET active=1-active WHERE id=?")->execute([$pid]); sendMessage($cid,"🔁 وضعیت محصول #{$pid} تغییر کرد."); exit; }
  if(strpos($data,'ad_edit_')===0){ $pid=intval(substr($data,8)); setState($cid,'ad_edit_title',['pid'=>$pid]); sendMessage($cid,"✏️ عنوان جدید محصول #{$pid}:"); exit; }

  // Department Manager
  if($data==='dm_menu'){ dmMenu($cid); exit; }
  if($data==='dm_new_project'){ setState($cid,'dm_new_project_title',[]); sendMessage($cid,"🆕 عنوان پروژه؟"); exit; }
  if($data==='dm_my_projects'){
    global $pdo; $s=$pdo->prepare("SELECT id,title,status FROM projects WHERE manager_tg=? ORDER BY id DESC LIMIT 10"); $s->execute([$cid]); $t="📂 <b>پروژه‌های من</b>\n"; $kb=[];
    foreach($s as $r){ $t.="\n• #{$r['id']} | {$r['title']} | {$r['status']}"; $kb[]=[ ['text'=>"🔎 جزئیات #{$r['id']}",'callback_data'=>"dm_proj_".$r['id']] ]; }
    $kb[]=[ ['text'=>'↩️ بازگشت','callback_data'=>'dm_menu'] ]; sendMessage($cid,$t,$kb); exit;
  }
  if(strpos($data,'dm_proj_')===0){
    global $pdo; $pid=intval(substr($data,8));
    $p=$pdo->prepare("SELECT * FROM projects WHERE id=? AND manager_tg=?"); $p->execute([$pid,$cid]); if(!$pr=$p->fetch()){ sendMessage($cid,"⚠️ پروژه یافت نشد."); exit; }
    $txt="🔎 <b>پروژه #{$pr['id']}</b>\nعنوان: <b>{$pr['title']}</b>\nوضعیت: <b>{$pr['status']}</b>\n—\n<b>تسک‌ها:</b>";
    $t=$pdo->prepare("SELECT t.id,t.title,t.status,u.name AS ass_name FROM tasks t LEFT JOIN users u ON u.tg_id=t.assignee_tg WHERE t.project_id=? ORDER BY t.id DESC"); $t->execute([$pid]);
    foreach($t as $r){ $who=$r['ass_name']?:'—'; $txt.="\n• #{$r['id']} {$r['title']} | {$r['status']} | {$who}"; }
    $kb=[ [ ['text'=>'📝 افزودن تسک','callback_data'=>"dm_new_task_proj_".$pid], ['text'=>'✅ بستن پروژه','callback_data'=>"dm_proj_close_".$pid] ], [ ['text'=>'↩️ بازگشت','callback_data'=>'dm_menu'] ] ];
    sendMessage($cid,$txt,$kb); exit;
  }
  if($data==='dm_new_task'){ setState($cid,'dm_new_task_project',[]); sendMessage($cid,"🔢 شماره پروژه؟"); exit; }
  if(strpos($data,'dm_new_task_proj_')===0){ $pid=intval(substr($data,17)); setState($cid,'dm_new_task_title',['project_id'=>$pid]); sendMessage($cid,"📝 عنوان تسک:"); exit; }
  if(strpos($data,'dm_proj_close_')===0){ global $pdo; $pid=intval(substr($data,14)); $pdo->prepare("UPDATE projects SET status='done' WHERE id=? AND manager_tg=?")->execute([$pid,$cid]); sendMessage($cid,"✅ پروژه #{$pid} بسته شد."); exit; }

  // Shop callbacks
  if($data==='cust_shop'){ shopList($cid,1); exit; }
  if(strpos($data,'shop_page_')===0){ $p=max(1,intval(substr($data,10))); shopList($cid,$p); exit; }
  if(strpos($data,'shop_add_')===0){ $pid=intval(substr($data,9)); setState($cid,'cart_qty',['pid'=>$pid]); sendMessage($cid,"🔢 تعداد؟ (مثلاً 1)"); exit; }
  if($data==='cust_cart'){ cartRender($cid); exit; }
  if($data==='cart_clear'){ cartClear($cid); sendMessage($cid,"🧹 سبد خالی شد."); exit; }
  if(strpos($data,'cart_inc_')===0){ cartAdd($cid,intval(substr($data,9)),1); cartRender($cid); exit; }
  if(strpos($data,'cart_dec_')===0){ cartAdd($cid,intval(substr($data,9)),-1); cartRender($cid); exit; }
  if(strpos($data,'cart_del_')===0){ cartAdd($cid,intval(substr($data,9)),-9999); cartRender($cid); exit; }
  if($data==='cart_checkout'){ cartCheckout($cid); exit; }
  if($data==='cust_track'){ trackOrders($cid); exit; }
  if($data==='cust_support'){ sendMessage($cid,"🎫 پیام‌تان را همین‌جا بنویسید."); exit; }

  // Approve / Reject staff
  if(strpos($data,'approve_')===0 || strpos($data,'reject_')===0){
    if(!isApprover($cid)){ sendMessage($cid,"⛔ دسترسی ندارید."); exit; }
    $tg=intval(substr($data,strpos($data,'_')+1)); $e=getUser($tg); if(!$e){ sendMessage($cid,"⚠️ کاربر یافت نشد."); exit; }
    if(strpos($data,'approve_')===0){ upUser($tg,'status','approved'); sendMessage($tg,"🎉 پرونده شما تأیید شد!"); sendMessage($cid,"✅ تأیید شد."); }
    else { sendMessage($tg,"❌ پرونده شما رد شد."); sendMessage($cid,"⛔ رد شد."); }
    exit;
  }
}
?>
