<?php
declare(strict_types=1);
require_once __DIR__ . '/storage.php';

function payroll_apply_penalty(int $user_id, int $amount, int $appr_id, string $reason): void {
    $p = payroll_all();
    $rec = $p[(string)$user_id] ?? ['user_id'=>$user_id,'salary'=>0,'deductions'=>0,'items'=>[]];
    $rec['deductions'] = (int)$rec['deductions'] + $amount;
    $rec['items'][] = ['type'=>'penalty','appr_id'=>$appr_id,'amount'=>$amount,'reason'=>$reason,'ts'=>time()];
    $p[(string)$user_id] = $rec;
    payroll_save($p);
}
