<?php
declare(strict_types=1);
require_once __DIR__ . '/../functions/telegram.php';
require_once __DIR__ . '/../functions/users.php';
require_once __DIR__ . '/../functions/role_requests.php';
require_once __DIR__ . '/../functions/utils.php';
function handle_role_callback(int $chat_id, string $data): void {
    if($data==='role:employee'){
        u_set_role($chat_id,'employee'); rr_create($chat_id,'employee');
        $rows=[[ kb_btn(icon('employee')." پنل کارمند",'emp:menu') ], [ kb_btn(icon('back')." بازگشت",'back:home') ]];
        tg_send_html($chat_id, friendly_greeting()."\n\n".icon('ok')." درخواست نقش کارمند ثبت شد و فعلاً با نقش کارمند وارد می‌شوی.", $rows);
    } elseif($data==='role:customer'){
        u_set_role($chat_id,'customer'); rr_create($chat_id,'customer');
        $rows=[[ kb_btn(icon('customer')." پنل مشتری",'cust:menu') ], [ kb_btn(icon('back')." بازگشت",'back:home') ]];
        tg_send_html($chat_id, friendly_greeting()."\n\n".icon('ok')." ثبت شد؛ به‌عنوان مشتری وارد شو.", $rows);
    }
}
