<?php
declare(strict_types=1);

require_once __DIR__ . '/../config/env.php';

final class VMDB {
    private static ?PDO $pdo = null;

    public static function pdo(): PDO {
        if (!DB_ENABLED) throw new RuntimeException('DB is disabled');
        if (self::$pdo) return self::$pdo;
        $opt = [
            PDO::ATTR_ERRMODE            => PDO::ERRMODE_EXCEPTION,
            PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
            PDO::ATTR_EMULATE_PREPARES   => false,
        ];
        self::$pdo = new PDO(DB_DSN, DB_USER, DB_PASS, $opt);
        return self::$pdo;
    }

    public static function tx(callable $cb) {
        $pdo = self::pdo();
        try { $pdo->beginTransaction(); $r = $cb($pdo); $pdo->commit(); return $r; }
        catch (Throwable $e) { if ($pdo->inTransaction()) $pdo->rollBack(); throw $e; }
    }
}
