<?php
declare(strict_types=1);

require_once __DIR__ . '/../core/utils.php';
require_once __DIR__ . '/../core/storage.php';
require_once __DIR__ . '/../core/telegram.php';
require_once __DIR__ . '/../modules/tasks.php';

function emp_menu(int $chat_id, int $user_id): void {
    $kb = kb_inline([[ kb_btn('📝 وظیفه‌های من', "emp:tasks") ]]);
    $msg = "سلام همکار عزیز 🌟\nاز اینجا می‌تونی وظیفه‌های بازت رو ببینی و تموم‌شده‌ها رو تایید کنی.";
    tg_send_kb_html($chat_id, $msg, $kb);
}
function emp_tasks_list(int $chat_id, int $user_id): void {
    $tasks = array_values(array_filter(task_list(), fn($t)=> (int)($t['user_id']??0)===$user_id && ($t['status']??'')==='open'));
    if (!$tasks){ tg_send_html($chat_id,'فعلاً وظیفه بازی نداری ✨'); return; }
    $out="📝 <b>وظیفه‌های من</b>\n";
    $kbRows=[];
    foreach($tasks as $t){
        $id=(int)$t['id']; $ttl=tg_escape($t['title']); $due=jdate('Y/m/d H:i',(int)$t['due_ts']);
        $out.="• #".to_persian_num($id)." — {$ttl} — مهلت: <b>{$due}</b>\n";
        $kbRows[]=[ kb_btn('✅ تمام شد',"emp:task:done:{$id}") ];
    }
    tg_send_kb_html($chat_id,$out,kb_inline($kbRows));
}

function employee_handle_callback(int $chat_id, int $user_id, string $data): bool {
    if ($data==='emp:tasks'){ emp_tasks_list($chat_id,$user_id); return true; }
    if (preg_match('~^emp:task:done:(\d+)$~',$data,$m)){ $ok=task_mark_done((int)$m[1]); tg_send_html($chat_id,$ok?'✅ ثبت شد.':'⛔️ خطا.'); return true; }
    if (preg_match('~^emp:task:noop:(\d+)$~',$data,$m)){ tg_send_html($chat_id,'باشه 👍'); return true; }
    return false;
}
function employee_handle_text(int $chat_id, int $user_id, string $text): bool {
    $t=trim($text);
    if ($t==='/start') { emp_menu($chat_id,$user_id); return true; }
    if ($t==='وظیفه' || $t==='وظیفه‌های من'){ emp_tasks_list($chat_id,$user_id); return true; }
    return false;
}

return true;
