<?php
declare(strict_types=1);
// This file loads BOT_TOKEN and BASE_URL from storage/config.json if present.
// It also exposes helper functions to read/write that file from a setup wizard.

require_once __DIR__ . '/../config.php';
require_once __DIR__ . '/utils.php';

const CONFIG_JSON = STORAGE_DIR . '/config.json';

function vm_config_load(): array {
    ensure_dirs();
    if (file_exists(CONFIG_JSON)) {
        $raw = @file_get_contents(CONFIG_JSON) ?: '{}';
        $j = json_decode($raw, true);
        if (is_array($j)) return $j;
    }
    return [];
}
function vm_config_save(array $cfg): bool {
    ensure_dirs();
    return (bool)@file_put_contents(CONFIG_JSON, json_encode($cfg, JSON_UNESCAPED_UNICODE|JSON_PRETTY_PRINT));
}
function vm_get_token(): string {
    $env = getenv('BOT_TOKEN') ?: '';
    if ($env) return $env;
    $j = vm_config_load();
    if (!empty($j['BOT_TOKEN'])) return (string)$j['BOT_TOKEN'];
    if (defined('BOT_TOKEN') && BOT_TOKEN && BOT_TOKEN !== 'PUT_YOUR_TELEGRAM_BOT_TOKEN_HERE') return BOT_TOKEN;
    return '';
}
function vm_get_base(): string {
    $env = getenv('BASE_URL') ?: '';
    if ($env) return $env;
    $j = vm_config_load();
    if (!empty($j['BASE_URL'])) return (string)$j['BASE_URL'];
    if (defined('BASE_URL') && BASE_URL) return BASE_URL;
    return '';
}


function vm_get_tz(): string {
    $j = vm_config_load();
    if (!empty($j['TIMEZONE'])) return (string)$j['TIMEZONE'];
    if (defined('TIMEZONE') && TIMEZONE) return TIMEZONE;
    return 'Asia/Tehran'; // پیش‌فرض: تهران
}
