<?php
declare(strict_types=1);
require_once __DIR__ . '/utils.php';
require_once __DIR__ . '/telegram.php';
require_once __DIR__ . '/storage.php';
require_once __DIR__ . '/penalties.php';
require_once __DIR__ . '/approvals.php';
require_once __DIR__ . '/../config.php';

/*
 Flow steps (state['penalty']):
   step: 'start' -> 'pick_employee' -> 'pick_type' -> ('pick_amount' if manual) -> 'reason' -> 'photo' -> 'confirm'
   data: user_id, amount, reason, photo_file_id
*/

if (!function_exists('state_get')) {
function state_get(int $uid): array {
    $s = state_all();
    return $s[(string)$uid] ?? [];
}
if (!function_exists('state_put')) {
function state_put(int $uid, array $st): void {
    $s = state_all(); $s[(string)$uid] = $st; state_save($s);
}
if (!function_exists('state_clear')) {
function state_clear(int $uid): void {
    $s = state_all(); unset($s[(string)$uid]); state_save($s);
}

function pf_start(int $chat_id): void {
    state_put($chat_id, ['flow'=>'penalty','step'=>'pick_employee','data'=>[]]);
    tg_send_html($chat_id, "👮‍♂️ <b>اعلام تخلف</b>\nلطفاً آیدی عددی کارمند را ارسال کن، یا یک پیام از او را <b>فوروارد</b> کن.");
}

function pf_handle_message(int $chat_id, array $msg): bool {
    $st = state_get($chat_id);
    if (($st['flow'] ?? '') !== 'penalty') return false;
    $step = $st['step'] ?? '';
    $data = $st['data'] ?? [];

    if ($step === 'pick_employee') {
        $uid = 0;
        if (!empty($msg['forward_from']['id'])) $uid = (int)$msg['forward_from']['id'];
        elseif (!empty($msg['text']) && preg_match('/^\d+$/', $msg['text'])) $uid = (int)$msg['text'];
        if ($uid <= 0) { tg_send_html($chat_id, "آیدی نامعتبره. دوباره بفرست یا یک پیام از کارمند فوروارد کن."); return true; }
        $data['user_id'] = $uid;
        $st['step']='pick_type'; $st['data']=$data; state_put($chat_id,$st);
        $kb = [
            [ kb_btn("جریمه عمومی ۲۵۰,۰۰۰", "pf:type:public") ],
            [ kb_btn("جریمه دستی", "pf:type:manual") ],
            [ kb_btn("لغو ❌", "pf:cancel") ]
        ];
        tg_send_html($chat_id, "نوع جریمه را انتخاب کن:", $kb);
        return true;
    }
    elseif ($step === 'reason') {
        $txt = trim($msg['text'] ?? '');
        if (!$txt) { tg_send_html($chat_id, "متن دلیل را تایپ کن."); return true; }
        $data['reason'] = $txt;
        $st['step']='photo'; $st['data']=$data; state_put($chat_id,$st);
        tg_send_html($chat_id, "📷 حالا یک عکس مستند تخلف بفرست (Photo).");
        return true;
    }
    elseif ($step === 'photo') {
        $phs = $msg['photo'] ?? [];
        if (!$phs) { tg_send_html($chat_id, "عکس دریافت نشد. لطفاً یک Photo بفرست."); return true; }
        $best = end($phs);
        $data['photo'] = $best['file_id'] ?? '';
        $st['step']='confirm'; $st['data']=$data; state_put($chat_id,$st);
        $sum = "کارمند: <code>{$data['user_id']}</code>\nمبلغ: ".number_format((int)($data['amount']??0))."\nدلیل: {$data['reason']}";
        $kb = [
            [ kb_btn("تأیید و ارسال به حسابداری ✅","pf:submit") ],
            [ kb_btn("لغو ❌","pf:cancel") ]
        ];
        tg_send_html($chat_id, "خلاصه:\n".$sum."\nاگر درست است تأیید کن.", $kb);
        return true;
    }
    return false;
}

function pf_handle_callback(int $chat_id, string $data): bool {
    $st = state_get($chat_id);
    if ($data==='pf:cancel') { state_clear($chat_id); tg_send_html($chat_id, "لغو شد."); return true; }

    if (($st['flow'] ?? '') !== 'penalty') return false;
    $step = $st['step'] ?? '';
    $d = $st['data'] ?? [];

    if (strpos($data,'pf:type:')===0 && $step==='pick_type') {
        $type = substr($data, strstrlen('pf:type:'));
        if ($type==='public') {
            $d['amount']=250000; $st['data']=$d; $st['step']='reason'; state_put($chat_id,$st);
            tg_send_html($chat_id, "دلیل جریمه را بنویس (متن).");
        } else {
            $st['step']='pick_amount'; state_put($chat_id,$st);
            $kb = [
                [ kb_btn("۵۰,۰۰۰","pf:amt:50000"), kb_btn("۱۰۰,۰۰۰","pf:amt:100000") ],
                [ kb_btn("۳۰۰,۰۰۰","pf:amt:300000"), kb_btn("۵۰۰,۰۰۰","pf:amt:500000") ],
                [ kb_btn("۱,۰۰۰,۰۰۰","pf:amt:1000000") ],
                [ kb_btn("لغو ❌", "pf:cancel") ]
            ];
            tg_send_html($chat_id, "مبلغ جریمه دستی را انتخاب کن:", $kb);
        }
        return true;
    }
    if (strpos($data,'pf:amt:')===0 && $step==='pick_amount') {
        $amt = (int)substr($data, strstrlen('pf:amt:'));
        $d['amount']=$amt; $st['data']=$d; $st['step']='reason'; state_put($chat_id,$st);
        tg_send_html($chat_id, "دلیل جریمه را بنویس (متن).");
        return true;
    }
    if ($data==='pf:submit' && $step==='confirm') {
        // Create approval item for accounting -> CEO
        $payload = [
            'user_id'=>(int)($d['user_id']??0),
            'amount'=>(int)($d['amount']??0),
            'reason'=>$d['reason']??'',
            'photo'=>$d['photo']??'',
            'dm_id'=>$chat_id,
            'ts'=>time()
        ];
        $appr_id = appr_create('penalty', $payload);
        state_clear($chat_id);
        tg_send_html($chat_id, "✅ تخلف ثبت شد و برای حسابداری ارسال گردید. (#{$appr_id})");
        // notify accounting (for demo, send to CEO too)
        tg_send_html(CEO_ID, "📝 تخلف جدید در انتظار تأیید حسابداری (#{$appr_id}).");
        return true;
    }
    return false;
}
}
}
}
