<?php
declare(strict_types=1);
require_once __DIR__ . '/storage.php';
require_once __DIR__ . '/../config.php';

function store_seed_if_empty(): void {
    $s = store_all();
    if (!$s) {
        $s = [
            'services' => [
                ['id'=>1,'name'=>'ادمین اینستاگرام','price'=>5000000,'desc'=>'مدیریت کامل پیج اینستاگرام','img'=>'','active'=>true],
                ['id'=>2,'name'=>'طراحی سایت','price'=>15000000,'desc'=>'طراحی سایت حرفه‌ای','img'=>'','active'=>true],
                ['id'=>3,'name'=>'سئو سایت','price'=>12000000,'desc'=>'بهبود رتبه گوگل','img'=>'','active'=>true],
                ['id'=>4,'name'=>'طراحی لوگو','price'=>4000000,'desc'=>'لوگوی اختصاصی','img'=>'','active'=>true],
                ['id'=>5,'name'=>'ثبت برند','price'=>8000000,'desc'=>'ثبت رسمی برند','img'=>'','active'=>true],
                ['id'=>6,'name'=>'ثبت شرکت','price'=>9000000,'desc'=>'ثبت شرکت با راهنمایی','img'=>'','active'=>true,'active'=>true],
                ['id'=>7,'name'=>'طراحی کاتالوگ','price'=>3000000,'desc'=>'کاتالوگ حرفه‌ای','img'=>'','active'=>true],
                ['id'=>8,'name'=>'ساخت تیزر تبلیغاتی','price'=>20000000,'desc'=>'تیزر حرفه‌ای','img'=>'','active'=>true],
            ],
            'company' => [
                'name'=>COMPANY_NAME,'legal'=>COMPANY_LEGAL,'reg_no'=>COMPANY_REG_NO,'nid'=>COMPANY_NATIONAL_ID,
                'address'=>COMPANY_ADDRESS,'phones'=>COMPANY_PHONES,'site'=>COMPANY_WEBSITE
            ]
        ];
        store_save($s);
    }
}


function store_list(): array { $s = store_all(); return $s['services'] ?? []; }
function store_get(int $id): array { foreach (store_list() as $it) if ((int)$it['id']===$id) return $it; return []; }
function store_put(array $items): void { $s = store_all(); $s['services'] = $items; store_save($s); }
function store_add_service(string $name, int $price, string $desc, string $img=''): int {
    $items = store_list(); $id = (count($items) ? max(array_map(fn($x)=>(int)$x['id'],$items)) : 0) + 1;
    $items[] = ['id'=>$id,'name'=>$name,'price'=>$price,'desc'=>$desc,'img'=>$img,'active'=>true];
    store_put($items); return $id;
}
function store_update(int $id, array $patch): bool {
    $items = store_list(); $ok=false;
    foreach ($items as &$it) if ((int)$it['id']===$id) { foreach ($patch as $k=>$v) $it[$k]=$v; $ok=true; }
    if ($ok) store_put($items); return $ok;
}
