<?php
declare(strict_types=1);
require_once __DIR__ . '/../config.php';
function ensure_dirs(): void {
    foreach ([LOG_DIR, STORAGE_DIR] as $d) { if (!is_dir($d)) @mkdir($d, 0775, true); }
}
function log_line(string $msg): void {
    ensure_dirs(); $file = LOG_DIR . '/' . date('Y-m-d') . '.log';
    @file_put_contents($file, '[' . date('H:i:s') . '] ' . $msg . PHP_EOL, FILE_APPEND);
}
function json_get(string $file): array { if (!file_exists($file)) return []; $raw=@file_get_contents($file); $d=json_decode($raw?:'[]',true); return is_array($d)?$d:[]; }
function json_put(string $file, array $data): void { ensure_dirs(); @file_put_contents($file, json_encode($data, JSON_UNESCAPED_UNICODE|JSON_PRETTY_PRINT)); }
function get_update(): array { $raw=file_get_contents('php://input')?:''; $j=json_decode($raw,true); return is_array($j)?$j:[]; }
function is_cli(): bool { return PHP_SAPI === 'cli'; }
function icon(string $k): string {
    $m=['home'=>'🏠','ceo'=>'👑','employee'=>'👤','customer'=>'🧑‍💼','accounting'=>'🧾','dept'=>'🗂️','ok'=>'✅','back'=>'↩️','gear'=>'⚙️','contract'=>'📄','invoice'=>'💳','leave'=>'🗓️','camera'=>'📷','edit'=>'✏️','assign'=>'📌','alert'=>'🚨','sign'=>'🖊️','files'=>'🗃️','clock'=>'⏰','money'=>'💰','stats'=>'📊'];
    return $m[$k]??'•';
}
function kb_btn(string $title, string $data): array { return ['text'=>$title,'callback_data'=>$data]; }
function fa_num(string $s): string { $map=['0'=>'۰','1'=>'۱','2'=>'۲','3'=>'۳','4'=>'۴','5'=>'۵','6'=>'۶','7'=>'۷','8'=>'۸','9'=>'۹']; return strtr($s,$map); }
function now_london(): array { if (defined('TIMEZONE') && TIMEZONE) @date_default_timezone_set(TIMEZONE); return ['h'=>(int)date('G'),'min'=>(int)date('i')]; }
if (!function_exists('friendly_greeting_v2')) {
function friendly_greeting_v2(): string {
    $n = now_london(); $h=$n['h'];
    if ($h>=5 && $h<12) return "صبح بخیر ☀️";
    if ($h>=12 && $h<16) return "ظهر بخیر 🌤️";
    if ($h>=16 && $h<20) return "عصر بخیر 🌇";
    if ($h>=20 or $h<5) return "شب بخیر 🌙";
    return "سلام 👋";
}
}


require_once __DIR__ . '/config_boot.php';
if (!function_exists('now_local')) {
function now_local(): array {
    $tz = vm_get_tz();
    if ($tz) @date_default_timezone_set($tz);
    return ['h'=>(int)date('G'),'min'=>(int)date('i')];
}
}




if (!function_exists('vm_log')) {
function vm_log(string $msg): void {
    $dir = __DIR__ . '/../logs';
    if (!is_dir($dir)) @mkdir($dir, 0775, true);
    $line = date('c') . " " . $msg . "\n";
    @file_put_contents($dir.'/bot.log', $line, FILE_APPEND);
}}
