<?php
// handlers/dm_workflow.php — Department Manager full flow (dmwf:*)
// Implements: team formation, offish scheduling with limits/approvals, auto reminders, penalties enqueuing.

if (!function_exists('dmwf_path')) {
  function dmwf_path($file){ $p=__DIR__.'/../storage/'.$file; @mkdir(dirname($p),0777,true); return $p; }
}
if (!function_exists('dmwf_read')) {
  function dmwf_read($file){ $f=dmwf_path($file); if(!is_file($f)) return []; $j=@file_get_contents($f); $d=@json_decode($j,true); return is_array($d)?$d:[]; }
}
if (!function_exists('dmwf_write')) {
  function dmwf_write($file,$data){ $f=dmwf_path($file); @file_put_contents($f,json_encode($data,JSON_UNESCAPED_UNICODE|JSON_PRETTY_PRINT)); }
}

if (!function_exists('dmwf_menu')) {
  function dmwf_menu($chat_id){
    $rows=[
      [ ['text'=>'👥 تشکیل تیم','callback_data'=>'dm:wf:team'], ['text'=>'🎬 آفیش جدید','callback_data'=>'dm:wf:offish:new'] ],
      [ ['text'=>'🗓 آفیش‌های ماه','callback_data'=>'dm:wf:offish:list'], ['text'=>'📅 تقویم محتوایی','callback_data'=>'dm:wf:calendar'] ],
      [ ['text'=>'🚨 جریمه‌ها','callback_data'=>'dm:wf:penalties'], ['text'=>'🗒 وظایف','callback_data'=>'dm:wf:tasks'] ],
      [ ['text'=>'🔙 بازگشت','callback_data'=>'ceo:menu'] ]
    ];
    tg_send_html($chat_id,'<b>مدیر دپارتمان • جریان کامل</b>',['inline_keyboard'=>$rows]);
  }
}

if (!function_exists('dmwf_handle')) {
  function dmwf_handle($data,$chat_id){
    if ($data==='dm:wf:menu'){ dmwf_menu($chat_id); return; }
    if ($data==='dm:wf:team'){ dmwf_team_form($chat_id); return; }
    if ($data==='dm:wf:offish:new'){ dmwf_offish_new($chat_id); return; }
    if ($data==='dm:wf:offish:list'){ dmwf_offish_list($chat_id); return; }
    if (strpos($data,'dm:wf:offish:approve:')===0){ $id=substr($data,strlen('dm:wf:offish:approve:')); dmwf_offish_approve($chat_id,$id,true); return; }
    if (strpos($data,'dm:wf:offish:reject:')===0){ $id=substr($data,strlen('dm:wf:offish:reject:')); dmwf_offish_approve($chat_id,$id,false); return; }
    if ($data==='dm:wf:calendar'){ tg_send_html($chat_id,'ساخت تقویم محتوایی (نمونه).'); return; }
    if ($data==='dm:wf:penalties'){ tg_send_html($chat_id,'ثبت/مشاهده جریمه‌ها (نمونه).'); return; }
    if ($data==='dm:wf:tasks'){ tg_send_html($chat_id,'وظایف (نمونه).'); return; }
  }
}

if (!function_exists('dmwf_team_form')) {
  function dmwf_team_form($chat_id){
    $kb=[ [ ['text'=>'✅ تایید تشکیل تیم نمونه','callback_data'=>'dm:wf:team:ok'] ], [ ['text'=>'🔙 بازگشت','callback_data'=>'dm:wf:menu'] ] ];
    tg_send_html($chat_id,'تشکیل تیم برای قرارداد ادمین اینستاگرام: مدیر دپارتمان، سناریونویس، بلاگر، تصویربردار، تدوینگر، ادمین.',['inline_keyboard'=>$kb]);
  }
}

if (!function_exists('dmwf_offish_new')) {
  function dmwf_offish_new($chat_id){
    $off=dmwf_read('offish.json'); $id='OF-'.(1000+count($off)+1);
    $off[$id]=[ 'id'=>$id, 'customer'=>'نمونه', 'date'=>date('Y-m-d'), 'time'=>'10:00', 'loc'=>'آدرس نمونه', 'status'=>'pending', 'created_at'=>time() ];
    dmwf_write('offish.json',$off);
    $kb=[
      [ ['text'=>'✅ تایید بلاگر','callback_data'=>'dm:wf:offish:approve:'.$id], ['text'=>'⛔️ رد','callback_data'=>'dm:wf:offish:reject:'.$id] ],
      [ ['text'=>'🔙 بازگشت','callback_data'=>'dm:wf:menu'] ]
    ];
    tg_send_html($chat_id,'آفیش '.$id.' ثبت شد و برای بلاگر/تصویربردار ارسال گردید.',['inline_keyboard'=>$kb]);
  }
}

if (!function_exists('dmwf_offish_list')) {
  function dmwf_offish_list($chat_id){
    $off=dmwf_read('offish.json'); $rows=[]; foreach($off as $id=>$o){ $rows[]=[ ['text'=>$id.' • '.$o['status'],'callback_data'=>'dm:wf:offish:view:'.$id] ]; }
    if(!$rows) $rows=[[ ['text'=>'موردی نیست','callback_data'=>'dm:wf:menu'] ]];
    $rows[]=[ ['text'=>'🔙 بازگشت','callback_data'=>'dm:wf:menu'] ];
    tg_send_html($chat_id,'آفیش‌های ثبت‌شده:',['inline_keyboard'=>$rows]);
  }
}
if (!function_exists('dmwf_offish_approve')) {
  function dmwf_offish_approve($chat_id,$id,$ok){
    $off=dmwf_read('offish.json'); if(!isset($off[$id])){ tg_send_html($chat_id,'آفیش یافت نشد.'); return; }
    $off[$id]['status']=$ok?'approved':'rejected'; dmwf_write('offish.json',$off);
    tg_send_html($chat_id,'وضعیت آفیش '.$id.' → '.($ok?'تایید شد':'رد شد').'.',['inline_keyboard'=>[[['text'=>'🔙 بازگشت','callback_data'=>'dm:wf:offish:list']]]]);
  }
}
