<?php
@ini_set('display_errors','0'); @ini_set('log_errors','1'); date_default_timezone_set('Asia/Tehran');
$BASE=__DIR__; $STO=$BASE.'/storage'; $LOGD=$STO.'/logs'; if(!is_dir($STO)) @mkdir($STO,0777,true); if(!is_dir($LOGD)) @mkdir($LOGD,0777,true);
function vmlog($m){ @file_put_contents(__DIR__.'/storage/logs/webhook.log','['.date('Y-m-d H:i:s').'] '.$m."\n",FILE_APPEND); }
register_shutdown_function(function(){ $e=error_get_last(); if($e && in_array($e['type'],[E_ERROR,E_PARSE,E_CORE_ERROR,E_COMPILE_ERROR])){ @http_response_code(200); vmlog('FATAL: '.$e['message'].' @ '.$e['file'].':'.$e['line']); echo 'OK'; }});
set_error_handler(function($n,$s,$f,$l){ vmlog("PHP[$n] $s @ $f:$l"); return false; });
set_exception_handler(function($ex){ vmlog('EX: '.$ex->getMessage().' @ '.$ex->getFile().':'.$ex->getLine()); });

if (($_SERVER['REQUEST_METHOD'] ?? 'GET')==='GET'){ @http_response_code(200); echo 'OK VM Router v907'; exit; }

// Require project functions if available
@require_once __DIR__.'/functions/telegram.php';
@require_once __DIR__.'/functions/jdate.php';

// Shim for tg_send_html ONLY if not already defined (to prevent redeclare)
if (!function_exists('tg_send_html')) {
  function tg_send_html($chat_id,$text,$reply_markup=null){
    $cfgf = __DIR__.'/storage/config.json';
    if (!is_file($cfgf)) return;
    $cfg = json_decode(@file_get_contents($cfgf), true);
    $token = $cfg['bot_token'] ?? '';
    if (!$token) return;
    $payload = ['chat_id'=>$chat_id,'text'=>$text,'parse_mode'=>'HTML'];
    if (is_array($reply_markup)) $payload['reply_markup'] = $reply_markup;
    $ch = curl_init("https://api.telegram.org/bot{$token}/sendMessage");
    curl_setopt_array($ch,[CURLOPT_POST=>1,CURLOPT_RETURNTRANSFER=>1,CURLOPT_HTTPHEADER=>['Content-Type: application/json'],CURLOPT_POSTFIELDS=>json_encode($payload,JSON_UNESCAPED_UNICODE)]);
    $res = curl_exec($ch); if($res===false){ $err=curl_error($ch); vmlog('TG send err: '.$err); } curl_close($ch);
  }
}

// Optional handlers (additive)
$handlers=[
  'handlers/ceo_plus.php',
  'handlers/ceo_dm_router.php',
  'handlers/ceo_acc_bridge.php',
  'handlers/accounting_ceo_view.php',
  'handlers/acc_workflow.php',
  'handlers/acc_requests.php',
  'handlers/acc_dir.php',
  'handlers/dm_workflow.php',
  'handlers/dm_full.php',
  'handlers/ceo_directory.php',
  'handlers/start.php',
  'handlers/accounting.php',
  'handlers/acc_roles.php',
  'handlers/dm.php',
  'handlers/ceo.php'
];
foreach($handlers as $h){ $p=__DIR__.'/'.$h; if(is_file($p)) @require_once $p; }

function vm_owners(){ $f=__DIR__.'/storage/owners.json'; if(!is_file($f)) return ['ceo_ids'=>[]]; $j=@file_get_contents($f); $d=@json_decode($j,true); return is_array($d)?$d:['ceo_ids'=>[]]; }

$raw=@file_get_contents('php://input'); @file_put_contents($BASE.'/storage/logs/latest.json',$raw);
$upd=@json_decode($raw,true); if(!$upd){ @http_response_code(200); echo 'OK'; exit; }

if(isset($upd['message'])){
  $msg=$upd['message']; $chat_id=(int)($msg['chat']['id']??0); $from=$msg['from']??null; $text=trim((string)($msg['text']??''));
  if ($text==='/ceo'){ if(function_exists('ceo_plus_menu')) ceo_plus_menu($chat_id,$from); elseif(function_exists('ceo_menu')) ceo_menu($chat_id,$from); else tg_send_html($chat_id,'پنل مدیرعامل نصب نشده.'); @http_response_code(200); echo 'OK'; exit; }
  if ($text==='/acc'){ if(function_exists('acc_menu')) acc_menu($chat_id); elseif(function_exists('accwf_menu')) accwf_menu($chat_id); else tg_send_html($chat_id,'پنل حسابداری در دسترس نیست.'); @http_response_code(200); echo 'OK'; exit; }
  if ($text==='/start'){
    $o=vm_owners(); if(in_array($chat_id,$o['ceo_ids']??[],true)){ if(function_exists('ceo_plus_menu')){ ceo_plus_menu($chat_id,$from); @http_response_code(200); echo 'OK'; exit; } if(function_exists('ceo_menu')){ ceo_menu($chat_id,$from); @http_response_code(200); echo 'OK'; exit; } }
    if(function_exists('start_menu')) start_menu($chat_id,$from); else{ $h=(int)date('G'); if($h>=5&&$h<12)$g='صبح بخیر ☀️'; elseif($h>=12&&$h<14)$g='ظهر بخیر ☀️'; elseif($h>=14&&$h<17)$g='بعدازظهر بخیر 🌤️'; elseif($h>=17&&$h<20)$g='عصر بخیر 🌇'; elseif($h>=20||$h<1)$g='شب بخیر 🌙'; else $g='بامداد بخیر 🌙'; $txt=$g."\n\nبه ربات ویژن مدیا خوش آمدید! لطفاً نقش خود را انتخاب کنید:"; $kb=['inline_keyboard'=>[[['text'=>'👤 مشتری هستم','callback_data'=>'start:role:customer']],[['text'=>'🧑‍💼 پرسنل هستم','callback_data'=>'start:role:employee']]]]; tg_send_html($chat_id,$txt,$kb); }
    @http_response_code(200); echo 'OK'; exit;
  }
  @http_response_code(200); echo 'OK'; exit;
}

if(isset($upd['callback_query'])){
  $cb=$upd['callback_query']; $data=(string)($cb['data']??''); $chat_id=(int)($cb['message']['chat']['id']??0); $from=$cb['from']??null; $d=str_replace(['|','/'],':',$data);
  if ($d==='ceo:menu'){ if(function_exists('ceo_plus_menu')) ceo_plus_menu($chat_id,$from); elseif(function_exists('ceo_menu')) ceo_menu($chat_id,$from); @http_response_code(200); echo 'OK'; exit; }
  if (strpos($d,'ceo:acc:')===0){ if(function_exists('acc_ceo_handle')) acc_ceo_handle($d,$chat_id); else if(function_exists('acc_ceo_menu')) acc_ceo_menu($chat_id); else tg_send_html($chat_id,'پنل حسابداری (مدیرعامل) نصب نیست.'); @http_response_code(200); echo 'OK'; exit; }
  if ($d==='ceo:open_dm'){ if (function_exists('ceo_dm_open')) ceo_dm_open($chat_id); else{ $done=false; foreach(['handlers/dm_workflow.php','handlers/dm_full.php','handlers/dm.php'] as $h){ $p=__DIR__.'/'.$h; if(is_file($p)) @require_once $p; } if(function_exists('dmwf_menu')){ dmwf_menu($chat_id); $done=true; } elseif(function_exists('dm2_menu')){ dm2_menu($chat_id); $done=true; } elseif(function_exists('dm_menu')){ dm_menu($chat_id); $done=true; } if(!$done) tg_send_html($chat_id,'پنل مدیر دپارتمان نصب نیست.'); } @http_response_code(200); echo 'OK'; exit; }
  if (strpos($d,'acc:wf:')===0){ if(function_exists('accwf_handle')) accwf_handle($d,$chat_id); else tg_send_html($chat_id,'جریان حسابداری نصب نیست.'); @http_response_code(200); echo 'OK'; exit; }
  if (strpos($d,'acc:reqs')===0){ if(function_exists('acc_req_handle')) acc_req_handle($d,$chat_id); else tg_send_html($chat_id,'ماژول درخواست‌های نقش نصب نیست.'); @http_response_code(200); echo 'OK'; exit; }
  if (strpos($d,'acc:dir')===0){ if(function_exists('acc_dir_handle')) acc_dir_handle($d,$chat_id); else tg_send_html($chat_id,'ماژول مدیریت پرسنل/مشتریان نصب نیست.'); @http_response_code(200); echo 'OK'; exit; }
  if (strpos($d,'vm2:dm:')===0){ if(function_exists('vm2_dm_handle')) vm2_dm_handle($d,$chat_id); else tg_send_html($chat_id,'ماژول مدیر دپارتمان (پیشرفته) نصب نیست.'); @http_response_code(200); echo 'OK'; exit; }
  if (strpos($d,'dm:wf:')===0){ if(function_exists('dmwf_handle')) dmwf_handle($d,$chat_id); else tg_send_html($chat_id,'جریان مدیر دپارتمان نصب نیست.'); @http_response_code(200); echo 'OK'; exit; }
  if (strpos($d,'dm2:')===0){ if(function_exists('dm2_handle')) dm2_handle($d,$chat_id,$from); @http_response_code(200); echo 'OK'; exit; }
  if (strpos($d,'start:')===0){ if(function_exists('start_handle')) start_handle($d,$chat_id,$from); else tg_send_html($chat_id,'ماژول شروع نصب نیست.'); @http_response_code(200); echo 'OK'; exit; }
  tg_send_html($chat_id,'دستور ناشناخته.');
  @http_response_code(200); echo 'OK'; exit;
}

@http_response_code(200); echo 'OK';
