<?php
declare(strict_types=1);
require_once __DIR__ . '/../config.php';
require_once __DIR__ . '/utils.php';
function storage_boot(): void { ensure_dirs(); foreach ([USERS_FILE,ROLES_FILE,CONTRACTS_FILE,INVOICES_FILE,LEAVES_FILE,RR_FILE,RAW_FILES_FILE,APPROVALS_FILE,PENALTIES_FILE] as $f){ if(!file_exists($f)) json_put($f,[]);} }
function users_all(): array { return json_get(USERS_FILE);} function users_save(array $d): void { json_put(USERS_FILE,$d);}
function roles_all(): array { return json_get(ROLES_FILE);} function roles_save(array $d): void { json_put(ROLES_FILE,$d);}
function contracts_all(): array { return json_get(CONTRACTS_FILE);} function contracts_save(array $d): void { json_put(CONTRACTS_FILE,$d);}
function invoices_all(): array { return json_get(INVOICES_FILE);} function invoices_save(array $d): void { json_put(INVOICES_FILE,$d);}
function leaves_all(): array { return json_get(LEAVES_FILE);} function leaves_save(array $d): void { json_put(LEAVES_FILE,$d);}
function rr_all(): array { return json_get(RR_FILE);} function rr_save(array $d): void { json_put(RR_FILE,$d);}
function rawfiles_all(): array { return json_get(RAW_FILES_FILE);} function rawfiles_save(array $d): void { json_put(RAW_FILES_FILE,$d);}
function approvals_all(): array { return json_get(APPROVALS_FILE);} function approvals_save(array $d): void { json_put(APPROVALS_FILE,$d);}
function penalties_all(): array { return json_get(PENALTIES_FILE);} function penalties_save(array $d): void { json_put(PENALTIES_FILE,$d);}

function ensure_file(string $f): void { if(!file_exists($f)) json_put($f, []); }
function offish_all(): array { ensure_file(OFFISH_FILE); return json_get(OFFISH_FILE); }
function offish_save(array $d): void { json_put(OFFISH_FILE, $d); }
function teams_all(): array { ensure_file(TEAMS_FILE); return json_get(TEAMS_FILE); }
function teams_save(array $d): void { json_put(TEAMS_FILE, $d); }
function tasks_all(): array { ensure_file(TASKS_FILE); return json_get(TASKS_FILE); }
function tasks_save(array $d): void { json_put(TASKS_FILE, $d); }
function store_all(): array { ensure_file(STORE_FILE); return json_get(STORE_FILE); }
function store_save(array $d): void { json_put(STORE_FILE, $d); }

function state_all(): array { ensure_file(STATE_FILE); return json_get(STATE_FILE); }
function state_save(array $d): void { json_put(STATE_FILE, $d); }
function messages_all(): array { ensure_file(MESSAGES_FILE); return json_get(MESSAGES_FILE); }
function messages_save(array $d): void { json_put(MESSAGES_FILE, $d); }
function plans_all(): array { ensure_file(PLANS_FILE); return json_get(PLANS_FILE); }
function plans_save(array $d): void { json_put(PLANS_FILE, $d); }

function payroll_all(): array { ensure_file(PAYROLL_FILE); return json_get(PAYROLL_FILE); }
function payroll_save(array $d): void { json_put(PAYROLL_FILE, $d); }
