<?php
declare(strict_types=1);
require_once __DIR__ . '/storage.php';
require_once __DIR__ . '/telegram.php';
require_once __DIR__ . '/utils.php';
require_once __DIR__ . '/../config.php';

/*
 * Tasks structure:
 * id, title, user_id, due_ts, status(pending/done/overdue), customer_id, type, payload
 * Reminders: 5h before, 1h before; auto-penalty if overdue (public penalty or custom)
 */

function task_create(string $title, int $user_id, int $due_ts, string $type='generic', array $payload=[]): int {
    $t = tasks_all();
    $id = (int)($t['last_id'] ?? 0) + 1;
    $t['last_id'] = $id;
    $t['items'][] = ['id'=>$id,'title'=>$title,'user_id'=>$user_id,'due_ts'=>$due_ts,'status'=>'pending','type'=>$type,'payload'=>$payload,'created_at'=>time()];
    tasks_save($t);
    return $id;
}
function task_list_for(int $user_id, string $status=''): array {
    $t = tasks_all(); $items = $t['items'] ?? [];
    $items = array_values(array_filter($items, fn($x)=> (int)($x['user_id']??0) === $user_id ));
    if ($status) $items = array_values(array_filter($items, fn($x)=> ($x['status']??'') === $status ));
    return $items;
}
function task_set_status(int $id, string $status): void {
    $t = tasks_all();
    foreach (($t['items']??[]) as &$it) if ((int)$it['id']===$id) $it['status']=$status;
    tasks_save($t);
}

function task_send_reminder(int $user_id, string $text, string $cb_data=''): void {
    $kb = $cb_data ? [[ kb_btn("تمام شد ✅", $cb_data) ]] : null;
    $res = tg_api('sendMessage', ['chat_id'=>$user_id,'text'=>$text,'parse_mode'=>'HTML','disable_web_page_preview'=>true,'reply_markup'=>$kb?json_encode(['inline_keyboard'=>$kb],JSON_UNESCAPED_UNICODE):null]);
    if (($res['ok']??false) && isset($res['result']['message_id'])) {
        $mid = (int)$res['result']['message_id'];
        $m = messages_all();
        $m['items'][] = ['chat_id'=>$user_id,'message_id'=>$mid,'ts'=>time(),'type'=>'reminder'];
        messages_save($m);
    }
}
