<?php
// acc_roles.php (v87) – fixed syntax; array arrow operators; safe tg_send_html
if (!function_exists('tg_send_html')) {
  function tg_send_html($chat_id, $text, $kb = null) {
    $cfg = __DIR__ . '/../storage/config.json';
    $d = @json_decode(@file_get_contents($cfg), true);
    $t = '';
    foreach (['bot_token','token','TOKEN','BOT_TOKEN','telegram_token'] as $k) {
      if (!empty($d[$k])) { $t = $d[$k]; break; }
    }
    if (!$t) return;
    $url = 'https://api.telegram.org/bot'.$t.'/sendMessage';
    $p = ['chat_id'=>(int)$chat_id, 'text'=>$text, 'parse_mode'=>'HTML'];
    if (is_array($kb)) { $p['reply_markup'] = json_encode($kb, JSON_UNESCAPED_UNICODE); }
    $ctx = stream_context_create(['http'=>['method'=>'POST','header'=>'Content-Type: application/json','content'=>json_encode($p, JSON_UNESCAPED_UNICODE)]]);
    @file_get_contents($url, false, $ctx);
  }
}
if (!function_exists('acc_roles_read')) { function acc_roles_read(){ $f=__DIR__.'/../storage/roles.json'; if(!is_file($f)) return []; $j=@file_get_contents($f); $d=@json_decode($j,true); return is_array($d)?$d:[]; } }
if (!function_exists('acc_roles_write')){ function acc_roles_write($d){ $f=__DIR__.'/../storage/roles.json'; @mkdir(dirname($f),0777,true); @file_put_contents($f,json_encode($d,JSON_UNESCAPED_UNICODE|JSON_PRETTY_PRINT)); } }
if (!function_exists('acc_roles_menu')) {
  function acc_roles_menu($chat_id){
    $roles=acc_roles_read(); $pending=[]; foreach($roles as $uid=>$r){ if(($r['status']??'')==='pending') $pending[$uid]=$r; }
    if(!$pending){ tg_send_html($chat_id,'درخواست نقش در انتظار یافت نشد.'); return; }
    $rows=[]; foreach($pending as $uid=>$r){ $role=$r['role']??''; $rows[]=[[ 'text'=>$uid.' • '.$role, 'callback_data'=>'acc:req_roles:open:'.$uid ]]; }
    tg_send_html($chat_id,'<b>درخواست‌های نقش در انتظار حسابداری</b>',['inline_keyboard'=>$rows]);
  }
}
if (!function_exists('acc_roles_handle')) {
  function acc_roles_handle($data,$chat_id){
    if(strpos($data,'acc:req_roles:open:')===0){
      $uid=substr($data,strlen('acc:req_roles:open:')); $roles=acc_roles_read(); $rec=$roles[$uid]??null;
      if(!$rec){ tg_send_html($chat_id,'پرونده نقش یافت نشد.'); return; }
      $role=$rec['role']??'';
      $kb=[[['text'=>'🗂️ تکمیل پرونده','callback_data'=>'acc:req_roles:complete:'.$uid.':'.$role]],[['text'=>'❌ رد درخواست','callback_data'=>'acc:req_roles:reject:'.$uid]]];
      tg_send_html($chat_id,"کاربر: $uid\nنقش: $role\nوضعیت: ".($rec['status']??''),['inline_keyboard'=>$kb]); return;
    }
    if(strpos($data,'acc:req_roles:complete:')===0){
      $p=explode(':',$data); $uid=$p[3]??''; $role=$p[4]??''; $roles=acc_roles_read(); $roles[$uid]=['role'=>$role,'status'=>'profile_completed']; acc_roles_write($roles);
      $kb=[[['text'=>'تایید اطلاعات ✅','callback_data'=>'profile:confirm:yes:'.$uid.':'.$role]],[['text'=>'رد اطلاعات ❌','callback_data'=>'profile:confirm:no:'.$uid.':'.$role]]];
      tg_send_html((int)$uid,'حسابداری پرونده شما را تکمیل کرد؛ لطفاً تایید می‌کنید؟',['inline_keyboard'=>$kb]);
      tg_send_html($chat_id,"پرونده کاربر $uid تکمیل شد و برای تایید هویت ارسال گردید."); return;
    }
    if(strpos($data,'acc:req_roles:reject:')===0){
      $uid=substr($data,strlen('acc:req_roles:reject:')); $roles=acc_roles_read(); $roles[$uid]=['role'=>$roles[$uid]['role']??'','status'=>'rejected']; acc_roles_write($roles);
      tg_send_html((int)$uid,'درخواست نقش شما توسط حسابداری رد شد.'); tg_send_html($chat_id,"درخواست $uid رد شد."); return;
    }
    acc_roles_menu($chat_id);
  }
}
