<?php
// ceo_directory.php — list & view employees/customers from roles.json
if (!function_exists('tg_send_html')) {
  function tg_send_html($chat_id,$text,$kb=null){ 
    $cfg=__DIR__.'/../storage/config.json'; $d=@json_decode(@file_get_contents($cfg),true); $t='';
    foreach(['bot_token','token','TOKEN','BOT_TOKEN','telegram_token'] as $k){ if(!empty($d[$k])){$t=$d[$k]; break;} }
    if(!$t) return; $url='https://api.telegram.org/bot'.$t.'/sendMessage';
    $p=['chat_id'=>(int)$chat_id,'text'=>$text,'parse_mode'=>'HTML'];
    if(is_array($kb)) $p['reply_markup']=json_encode($kb,JSON_UNESCAPED_UNICODE);
    $ctx=stream_context_create(['http'=>['method'=>'POST','header'=>'Content-Type: application/json','content'=>json_encode($p,JSON_UNESCAPED_UNICODE)]]);
    @file_get_contents($url,false,$ctx);
  }
}

function _roles_read(){ $f=__DIR__.'/../storage/roles.json'; if(!is_file($f)) return []; $j=@file_get_contents($f); $d=@json_decode($j,true); return is_array($d)?$d:[]; }

function ceo_dir_list($chat_id,$type='employees',$page=1){
  $roles=_roles_read();
  $want = $type==='customers' ? 'customer' : 'employee';
  $items=[];
  foreach($roles as $uid=>$r){
    $role=$r['role']??''; $status=$r['status']??'';
    if($role===$want && $status!=='rejected' && $status!=='rejected_by_user'){
      $items[]=['uid'=>$uid,'role'=>$role,'status'=>$status];
    }
  }
  $per=12; $page=max(1,(int)$page); $total=count($items); $pages=max(1, (int)ceil($total/$per));
  $slice=array_slice($items, ($page-1)*$per, $per);
  $rows=[];
  foreach($slice as $it){
    $cap = $it['uid'].' • '.($it['status']?:'—');
    $rows[]=[ ['text'=>$cap, 'callback_data'=>'ceo:dir:view:'.$it['uid']] ];
  }
  $nav=[];
  if($page>1) $nav[]=['text'=>'⬅️ قبلی','callback_data'=>'ceo:dir:page:'.$type.':'.($page-1)];
  if($page<$pages) $nav[]=['text'=>'بعدی ➡️','callback_data'=>'ceo:dir:page:'.$type.':'.($page+1)];
  if($nav) $rows[]=$nav;
  $title = $type==='customers' ? 'فهرست مشتریان' : 'فهرست پرسنل';
  tg_send_html($chat_id, '<b>'.$title.'</b>\n'.'تعداد: '.$total, ['inline_keyboard'=>$rows]);
}

function ceo_dir_view($chat_id,$uid){
  $roles=_roles_read(); $rec=$roles[$uid]??null;
  if(!$rec){ tg_send_html($chat_id,'پرونده یافت نشد.'); return; }
  $role=$rec['role']??'-'; $status=$rec['status']??'-';
  $kb=[
    [ ['text'=>'✉️ ارسال پیام','callback_data'=>'ceo:dir:pm:'.$uid] ],
    [ ['text'=>'📄 اطلاعات نقش','callback_data'=>'ceo:dir:info:'.$uid] ]
  ];
  // Optional deep-links
  if ($role==='employee'){
    $kb[] = [ ['text'=>'👷‍♂️ نمایش پنل مدیر دپارتمان','callback_data'=>'ceo:open_dm'] ];
  }
  tg_send_html($chat_id, "<b>کاربر: $uid</b>\nنقش: $role\nوضعیت: $status", ['inline_keyboard'=>$kb]);
}

function ceo_dir_route($d,$chat_id,$from){
  // ceo:dir:employees | ceo:dir:customers | ceo:dir:page:<type>:<p> | ceo:dir:view:<uid> | ceo:dir:pm:<uid> | ceo:dir:info:<uid>
  if ($d==='ceo:dir:employees'){ ceo_dir_list($chat_id,'employees',1); return; }
  if ($d==='ceo:dir:customers'){ ceo_dir_list($chat_id,'customers',1); return; }
  if (strpos($d,'ceo:dir:page:')===0){
    $p=explode(':',$d); $type=$p[3]??'employees'; $pg=(int)($p[4]??1); ceo_dir_list($chat_id,$type,$pg); return;
  }
  if (strpos($d,'ceo:dir:view:')===0){ $uid=substr($d, strlen('ceo:dir:view:')); ceo_dir_view($chat_id,$uid); return; }
  if (strpos($d,'ceo:dir:pm:')===0){ $uid=substr($d, strlen('ceo:dir:pm:')); tg_send_html($chat_id,'(پلیس‌هولدر) پیام مستقیم به: '.$uid); return; }
  if (strpos($d,'ceo:dir:info:')===0){ $uid=substr($d, strlen('ceo:dir:info:')); $roles=_roles_read(); $rec=$roles[$uid]??[]; tg_send_html($chat_id,'<pre>'.htmlspecialchars(json_encode($rec,JSON_UNESCAPED_UNICODE|JSON_PRETTY_PRINT)).'</pre>'); return; }
}
