<?php
declare(strict_types=1);

require_once __DIR__ . '/../functions/telegram.php';
require_once __DIR__ . '/../functions/utils.php';
require_once __DIR__ . '/../functions/users.php';
require_once __DIR__ . '/../functions/storage.php';
require_once __DIR__ . '/../functions/settings.php';

if (!function_exists('dm_read_json')) {
function dm_read_json(string $rel) {
    $file = STORAGE_DIR . '/' . ltrim($rel,'/');
    if (function_exists('storage_read_json')) return storage_read_json($file);
    if (!file_exists($file)) return [];
    $j = @file_get_contents($file);
    $d = @json_decode($j,true);
    return is_array($d) ? $d : [];
}}
if (!function_exists('dm_write_json')) {
function dm_write_json(string $rel, $data): bool {
    $file = STORAGE_DIR . '/' . ltrim($rel,'/');
    if (function_exists('storage_write_json')) return storage_write_json($file, $data);
    return (bool)@file_put_contents($file, json_encode($data, JSON_UNESCAPED_UNICODE|JSON_PRETTY_PRINT));
}}


if (!function_exists('kb_btn')) {
function kb_btn(string $title, string $data): array { return ['text'=>$title, 'callback_data'=>$data]; }
}

if (!function_exists('dm_menu')) {
function dm_menu(int $chat_id): void {
    $g = function_exists('friendly_greeting_v2') ? friendly_greeting_v2() : "سلام";
    $rows = [
        [ kb_btn("📋 مشتریان من","dm:customers"), kb_btn("👥 تشکیل تیم","dm:team") ],
        [ kb_btn("🎬 تنظیم آفیش","dm:offish"), kb_btn("✅ تاییدهای معلق","dm:approvals") ],
        [ kb_btn("🧩 سناریونویس","dm:scenario"), kb_btn("📦 فایل‌ها (فیلم/تحویل)","dm:files") ],
        [ kb_btn("🗒️ وظایف تیم","dm:tasks"), kb_btn("📅 تقویم محتوایی","dm:calendar") ],
        [ kb_btn("🚨 جریمه/تخلف","dm:penalties"), kb_btn("➕ آفیش اضافه از حسابداری","dm:extra_offish") ],
        [ kb_btn("📈 گزارش پروژه","dm:reports"), kb_btn("⚙️ تنظیمات دپارتمان","dm:settings") ],
        [ kb_btn("↩️ خانه","back:home") ]
    ];
    tg_send_html($chat_id, $g." <b>پنل مدیر دپارتمان</b>", $rows);
}}

if (!function_exists('dm_info_page')) {
function dm_info_page(int $chat_id, string $title, string $desc): void {
    tg_send_html($chat_id, "<b>".$title."</b>\n".$desc, [[kb_btn("↩️ بازگشت","dm:menu")]]);
}}

if (!function_exists('dm_handle')) {
function dm_handle(string $data, int $chat_id): void {
    if ($data==='dm:menu') { dm_menu($chat_id); return; }
    if ($data==='back:home') { dm_menu($chat_id); return; }

    // Top-level placeholders (safe, no internal errors)
    if ($data==='dm:customers') { dm_customers_menu($chat_id); return; }
    if ($data==='dm:team') { dm_team_menu($chat_id); return; }
    if ($data==='dm:offish') { dm_offish_menu($chat_id); return; }
    if ($data==='dm:approvals') { dm_approvals_menu($chat_id); return; }
    if ($data==='dm:scenario') { dm_scenario_menu($chat_id); return; }
    if ($data==='dm:files') { dm_files_menu($chat_id); return; }
    if ($data==='dm:tasks') { dm_tasks_menu($chat_id); return; }
    if ($data==='dm:calendar') { dm_calendar_menu($chat_id); return; }
    if ($data==='dm:penalties') { dm_penalties_menu($chat_id); return; }
    if ($data==='dm:extra_offish') { dm_extra_offish_menu($chat_id); return; }
    if ($data==='dm:reports') { dm_reports_menu($chat_id); return; }
    if ($data==='dm:settings') { dm_settings_menu($chat_id); return; }

    tg_send_html($chat_id, "دستور ناشناخته در پنل مدیر دپارتمان.", [[kb_btn("↩️ بازگشت","dm:menu")]]);
}}

if (!function_exists('dm_customers_menu')) {
function dm_customers_menu(int $chat_id): void {
    if (!function_exists('storage_read_json')) { tg_send_html($chat_id,"بانک اطلاعات در دسترس نیست.", [[kb_btn("↩️ بازگشت","dm:menu")]]); return; }
    $cust = storage_read_json(STORAGE_DIR.'/customers.json');
    $items = is_array($cust) ? ($cust['items'] ?? $cust) : [];
    if (!$items) { tg_send_html($chat_id, "مشتری منتصب ندارید.", [[kb_btn("↩️ بازگشت","dm:menu")]]); return; }
    $kb = []; $i=1;
    foreach ($items as $c) {
        $name = ($c['name'] ?? $c['customer_name'] ?? ('مشتری #'.$i));
        $kb[] = [ kb_btn("#".$i." — ".$name, "dm:customer:view:".$i) ];
        $i++;
    }
    $kb[] = [ kb_btn("↩️ بازگشت","dm:menu") ];
    tg_send_html($chat_id, "<b>مشتریان من</b>", $kb);
}}

if (!function_exists('dm_team_menu')) {
function dm_team_menu(int $chat_id): void {
    $kb = [
        [ kb_btn("انتخاب مشتری","dm:team:pick_customer") ],
        [ kb_btn("↩️ بازگشت","dm:menu") ]
    ];
    tg_send_html($chat_id, "<b>تشکیل تیم مشتری</b>\nمشتری را انتخاب کنید تا نقش‌ها تعیین شوند: (مدیردپارتمان، سناریونویس، بلاگر، تصویربردار، تدوینگر، ادمین)", $kb);
}}

if (!function_exists('dm_offish_menu')) {
function dm_offish_menu(int $chat_id): void {
    $kb = [
        [ kb_btn("ایجاد آفیش جدید","dm:offish:new") ],
        [ kb_btn("فهرست آفیش‌های فعال","dm:offish:list") ],
        [ kb_btn("↩️ بازگشت","dm:menu") ]
    ];
    tg_send_html($chat_id, "<b>تنظیم آفیش</b>\nاینجا آفیش‌ها را مدیریت می‌کنید.", $kb);
}}

if (!function_exists('dm_approvals_menu')) {
function dm_approvals_menu(int $chat_id): void {
    tg_send_html($chat_id, "<b>تاییدهای معلق</b>\nدرخواست‌های تایید/رد تاریخ توسط بلاگر/تصویربردار اینجا نمایش داده می‌شود.", [[kb_btn("↩️ بازگشت","dm:menu")]]);
}}

if (!function_exists('dm_scenario_menu')) {
function dm_scenario_menu(int $chat_id): void {
    tg_send_html($chat_id, "<b>سناریونویس</b>\nارسال اطلاعات مشتری به سناریونویس + مهلت ۳۰ ساعته.", [[kb_btn("↩️ بازگشت","dm:menu")]]);
}}

if (!function_exists('dm_files_menu')) {
function dm_files_menu(int $chat_id): void {
    tg_send_html($chat_id, "<b>فایل‌ها (فیلم/تحویل)</b>\nکنترل ارسال فایل‌های تصویربردار → تدوینگر → ادمین.", [[kb_btn("↩️ بازگشت","dm:menu")]]);
}}

if (!function_exists('dm_tasks_menu')) {
function dm_tasks_menu(int $chat_id): void {
    tg_send_html($chat_id, "<b>وظایف تیم</b>\nاینجا وظایف اعضای تیم را تعریف/پیگیری می‌کنید.", [[kb_btn("↩️ بازگشت","dm:menu")]]);
}}

if (!function_exists('dm_calendar_menu')) {
if (!function_exists('dm_penalties_menu')) {
function dm_penalties_menu(int $chat_id): void {
    tg_send_html($chat_id, "<b>جریمه/تخلف</b>\nثبت تخلف پرسنل + ارسال برای حسابداری و مدیرعامل جهت تایید نهایی.", [[kb_btn("↩️ بازگشت","dm:menu")]]);
}}

if (!function_exists('dm_extra_offish_menu')) {
function dm_extra_offish_menu(int $chat_id): void {
    tg_send_html($chat_id, "<b>درخواست آفیش اضافه</b>\nدرخواست سهمیه آفیش اضافه از حسابداری برای مشتری.", [[kb_btn("↩️ بازگشت","dm:menu")]]);
}}

if (!function_exists('dm_reports_menu')) {
function dm_reports_menu(int $chat_id): void {
    tg_send_html($chat_id, "<b>گزارش پروژه</b>\nنمای کلی وضعیت پروژه‌های شما.", [[kb_btn("↩️ بازگشت","dm:menu")]]);
}}

if (!function_exists('dm_settings_menu')) {
function dm_settings_menu(int $chat_id): void {
    tg_send_html($chat_id, "<b>تنظیمات دپارتمان</b>\nگزینه‌های اختصاصی دپارتمان.", [[kb_btn("↩️ بازگشت","dm:menu")]]);
}}

if (!function_exists('dm_offish_pick_customer')) {
function dm_offish_pick_customer(int $chat_id): void {
    $cust = dm_read_json('customers.json');
    $items = is_array($cust) ? ($cust['items'] ?? $cust) : [];
    if (!$items) { tg_send_html($chat_id, "هیچ مشتری‌ای موجود نیست.", [[kb_btn("↩️ بازگشت","dm:offish")]]); return; }
    $kb = []; $i=1;
    foreach ($items as $c) {
        $name = ($c['name'] ?? $c['customer_name'] ?? ('مشتری #'.$i));
        $kb[] = [ kb_btn("#".$i." — ".$name, "dm:offish:date:".$i) ];
        $i++;
    }
    tg_send_html($chat_id, "مشتری را انتخاب کنید:", array_merge($kb, [[kb_btn("↩️ بازگشت","dm:offish")]]));
}}

if (!function_exists('dm_offish_pick_date')) {
function dm_offish_pick_date(int $chat_id, int $cid): void {
    $kb = [];
    for ($d=0; $d<7; $d++) {
        $date = date('Y-m-d', time()+$d*86400);
        $kb[] = [ kb_btn($date, "dm:offish:hour:".$cid.":".$date) ];
    }
    $kb[] = [ kb_btn("↩️ بازگشت","dm:offish") ];
    tg_send_html($chat_id, "تاریخ را انتخاب کنید:", $kb);
}}

if (!function_exists('dm_offish_pick_hour')) {
function dm_offish_pick_hour(int $chat_id, int $cid, string $date): void {
    $hours = ['09:00','10:00','12:00','14:00','16:00'];
    $kb = [];
    foreach ($hours as $h) { $kb[] = [ kb_btn($h, "dm:offish:loc:".$cid.":".$date.":".$h) ]; }
    $kb[] = [ kb_btn("↩️ بازگشت","dm:offish") ];
    tg_send_html($chat_id, "ساعت را انتخاب کنید:", $kb);
}}

if (!function_exists('dm_offish_pick_loc')) {
function dm_offish_pick_loc(int $chat_id, int $cid, string $date, string $hour): void {
    $locs = ['لوکیشن مشتری', 'دفتر ویژن مدیا'];
    $kb = [];
    foreach ($locs as $i=>$L) { $kb[] = [ kb_btn($L, "dm:offish:confirm:".$cid.":".$date.":".$hour.":".$i) ]; }
    $kb[] = [ kb_btn("↩️ بازگشت","dm:offish") ];
    tg_send_html($chat_id, "لوکیشن را انتخاب کنید:", $kb);
}}

if (!function_exists('dm_offish_confirm')) {
function dm_offish_confirm(int $chat_id, int $cid, string $date, string $hour, int $loci): void {
    $locs = ['لوکیشن مشتری', 'دفتر ویژن مدیا'];
    $loc = $locs[$loci] ?? 'لوکیشن مشتری';
    $off = dm_read_json('offish.json');
    if (!is_array($off)) $off = [];
    if (!isset($off['items']) || !is_array($off['items'])) $off['items'] = [];
    $id = time();
    $rec = [
        'id'=>$id,
        'customer_id'=>$cid,
        'date'=>$date,
        'hour'=>$hour,
        'location'=>$loc,
        'status'=>'pending',
        'created_at'=>date('c')
    ];
    $off['items'][] = $rec;
    dm_write_json('offish.json',$off);

    // Auto-create scenario task with 30h deadline
    $tasks = dm_read_json('tasks.json'); if (!is_array($tasks)) $tasks=[]; if (!isset($tasks['items'])) $tasks['items']=[];
    $tasks['items'][] = [
        'id'=>$id,
        'title'=>'ارسال سناریو برای آفیش '.$date.' '.$hour,
        'assignee_role'=>'scenario_writer',
        'deadline_at'=>date('c', time()+30*3600),
        'status'=>'open'
    ];
    dm_write_json('tasks.json',$tasks);

    $txt = "<b>آفیش ثبت شد</b>\nتاریخ: <b>".$date."</b>\nساعت: <b>".$hour."</b>\nلوکیشن: <b>".$loc."</b>\nشناسه: <code>".$id."</code>";
    tg_send_html($chat_id, $txt, [[kb_btn("↩️ بازگشت","dm:offish")]]);
}}

if (!function_exists('dm_calendar_menu')) {
function dm_calendar_menu(int $chat_id): void {
    $kb = [];
    for ($d=0;$d<7;$d++) {
        $date = date('Y-m-d', time()+$d*86400);
        $kb[] = [ kb_btn("افزودن روز پست: ".$date, "dm:calendar:post:".$date) ];
        $kb[] = [ kb_btn("افزودن روز استوری: ".$date, "dm:calendar:story:".$date) ];
    }
    $kb[] = [ kb_btn("ذخیرهٔ تقویم","dm:calendar:save") ];
    $kb[] = [ kb_btn("↩️ بازگشت","dm:menu") ];
    tg_send_html($chat_id, "<b>تقویم محتوایی (۷ روز آینده)</b>", $kb);
}}
if (!function_exists('dm_calendar_select')) {
function dm_calendar_select(int $chat_id, string $type, string $date): void {
    $cal = dm_read_json('calendar.json'); if (!is_array($cal)) $cal=[];
    if (!isset($cal[$type])) $cal[$type]=[];
    if (!in_array($date,$cal[$type],true)) $cal[$type][]=$date;
    dm_write_json('calendar.json',$cal);
    tg_send_html($chat_id, "ثبت شد: ".$type." — ".$date, [[kb_btn("↩️ بازگشت","dm:calendar")]]);
}}
if (!function_exists('dm_calendar_save')) {
function dm_calendar_save(int $chat_id): void {
    $cal = dm_read_json('calendar.json');
    $posts = isset($cal['post']) ? implode(', ',$cal['post']) : '—';
    $stories = isset($cal['story']) ? implode(', ',$cal['story']) : '—';
    $txt = "<b>تقویم ثبت شد</b>\nپست‌ها: ".$posts."\nاستوری‌ها: ".$stories;
    tg_send_html($chat_id, $txt, [[kb_btn("↩️ بازگشت","dm:menu")]]);
}}

}
