<?php
mb_internal_encoding('UTF-8');
ini_set('display_errors','0'); error_reporting(E_ALL);
@mkdir(__DIR__.'/storage/logs',0775,true);
@mkdir(__DIR__.'/storage',0775,true);
function flog($tag,$data){ @file_put_contents(__DIR__.'/storage/logs/trace-'.date('Y-m-d').'.log','['.date('H:i:s')."] $tag: ".(is_string($data)?$data:json_encode($data,JSON_UNESCAPED_UNICODE))."\n",FILE_APPEND); }

require_once __DIR__.'/config.php';
require_once __DIR__.'/lib/Telegram.php';
require_once __DIR__.'/lib/JDate.php';
require_once __DIR__.'/lib/Storage.php';

$config = include __DIR__.'/config.php';
$tg = new Telegram($config['bot_token'], 'https://api.telegram.org/bot');

// === Helpers ===
function ikb($rows){ return ['inline_keyboard'=>$rows]; }
function back_btn($to){ return [['text'=>'⬅️ بازگشت','callback_data'=>$to]]; }
function jlabel($y,$m,$d){ return sprintf('%04d/%02d/%02d',$y,$m,$d); }
function jlabel_ts($ts){ list($jy,$jm,$jd)=JDate::toJalali((int)date('Y',$ts),(int)date('n',$ts),(int)date('j',$ts)); return sprintf('%04d/%02d/%02d - %s',$jy,$jm,$jd,date('H:i',$ts)); }
function fa_amount($n){ $n=intval($n); return number_format($n).' تومان'; }
function send_kb($chat,$text,$rows){ global $tg; $res=$tg->sendMessage($chat,$text,ikb($rows)); flog('SEND',$res); return $res; }
function edit_kb($chat,$mid,$text,$rows){ global $tg; $res=$tg->editMessageText($chat,$mid,$text,ikb($rows)); flog('EDIT',$res); return $res; }
function emp_list(){ return json_decode(@file_get_contents(__DIR__.'/storage/employees.json'), true) ?: []; }
function get_employee_by_id($id){ foreach(emp_list() as $e){ if((string)($e['id']??'') === (string)$id) return $e; } return null; }

$raw = file_get_contents('php://input'); $upd = json_decode($raw?:'[]', true);
flog('UPDATE',$upd);
if(isset($upd['callback_query']['id'])){ try{ $tg->answerCallback($upd['callback_query']['id'], ''); } catch(\Throwable $e){ flog('ANSWER_ERR',$e->getMessage()); } }

$chat = $upd['message']['chat']['id'] ?? ($upd['callback_query']['message']['chat']['id'] ?? 0);
$uid  = $upd['message']['from']['id'] ?? ($upd['callback_query']['from']['id'] ?? 0);
$txt  = trim($upd['message']['text'] ?? '');
$data = $upd['callback_query']['data'] ?? '';
$mid  = $upd['callback_query']['message']['message_id'] ?? 0;
$photo = ($upd['message']['photo'][count($upd['message']['photo'])-1]['file_id'] ?? null);

$h=intval(date('G'));
$greet=($h<12?'صبح بخیر ☀️':($h<18?'عصر بخیر 🌤️':'بامداد بخیر 🌌'));
list($jy,$jm,$jd)=JDate::toJalali((int)date('Y'),(int)date('n'),(int)date('j'));
$today=sprintf('%04d/%02d/%02d - %s',$jy,$jm,$jd,date('H:i'));

$SET = Storage::readJson('settings.json',['sms_enabled'=>false,'penalty_general'=>250000,'late_fee'=>150000,'offish_quota'=>3]);

// ===== ROOT =====
function root_menu($chat){
  global $greet,$today;
  $rows=[];
  $rows[]=[ ['text'=>'👑 پنل مدیرعامل','callback_data'=>'ceo'] ];
  $rows[]=[ ['text'=>'💰 حسابداری','callback_data'=>'acc'], ['text'=>'🧩 مدیر دپارتمان','callback_data'=>'dep'] ];
  $rows[]=[ ['text'=>'🛡 ادمین ارشد','callback_data'=>'root_sadmin'], ['text'=>'🛠 ادمین','callback_data'=>'root_admin'] ];
  $rows[]=[ ['text'=>'✍️ سناریونویس','callback_data'=>'scn'], ['text'=>'🎞 تدوینگر','callback_data'=>'edtr'] ];
  $rows[]=[ ['text'=>'📷 تصویربردار','callback_data'=>'cam'], ['text'=>'📝 بلاگر','callback_data'=>'blog'] ];
  $rows[]=[ ['text'=>'👤 منابع انسانی','callback_data'=>'hr'], ['text'=>'📇 مشتریان','callback_data'=>'clients'] ];
  $rows[]=[ ['text'=>'🗂 وظایف من','callback_data'=>'mytasks'], ['text'=>'💳 فیش حقوق من','callback_data'=>'payroll_me'] ];
  $rows[]=[ ['text'=>'ℹ️ درباره شرکت','callback_data'=>'about'] ];
  return send_kb($chat,"سلام عزیز 🌸\n$greet\n📅 $today\nبه ربات «ویژن مدیا» خوش آمدی.\nاز دکمه‌های زیر استفاده کن:",$rows);
}
if(isset($upd['message']) && ($txt==='/start' || $txt==='start' || $txt==='')){ root_menu($chat); }
if($data==='root'){ root_menu($chat); exit; }

// ===== ABOUT =====
if($data==='about'){
  $info="ویژن مدیا (البرز مدیا دوراندیش)\nثبت: ۴۲۵۶۳ | شناسه: ۱۴۰۱۱۱۲۸۲۲۲\nکرج، جهانشهر، میدان سپاه، مجتمع تجاری گلستان\n☎️ ۰۹۳۳۱۹۰۳۸۷۲ | ۰۹۹۸۱۳۸۱۷۳۷ | ۰۲۶۳۴۴۲۵۸۸۰ | ۰۲۱۹۱۳۰۵۸۸۳\n🌐 www.visionmedia.ir";
  edit_kb($chat,$mid,$info,[ back_btn('root') ]); exit;
}

// ===== CEO =====
if($data==='ceo'){
  $kb=[
    [ ['text'=>'📈 داشبورد','callback_data'=>'ceo_dash'], ['text'=>'⚙️ تنظیمات','callback_data'=>'ceo_settings'] ],
    [ ['text'=>'🖊 منتظر امضا (قرارداد)','callback_data'=>'ceo_sign_contracts'], ['text'=>'📊 گزارش‌ها','callback_data'=>'ceo_reports'] ],
    [ ['text'=>'🗓 مرخصی‌ها','callback_data'=>'ceo_leaves'], ['text'=>'📜 اسناد رسمی','callback_data'=>'ceo_offdoc'] ],
    [ ['text'=>'🛠 نگهداری سیستم','callback_data'=>'sys_maint'] ],
    back_btn('root')
  ];
  edit_kb($chat,$mid,'👑 پنل مدیرعامل',$kb); exit;
}
if($data==='ceo_dash'){
  $contracts=0; $invoices_unpaid=0; $sum_unpaid=0;
  $cdir=__DIR__.'/storage/contracts'; foreach(is_dir($cdir)?scandir($cdir):[] as $f){ if(substr($f,-5)==='.json') $contracts++; }
  $idir=__DIR__.'/storage/invoices'; foreach(is_dir($idir)?scandir($idir):[] as $f){ if(substr($f,-5)==='.json'){ $inv=Storage::readJson('invoices/'.$f,[]); if(($inv['status']??'')!=='paid'){ $invoices_unpaid++; $sum_unpaid+=intval($inv['remaining']??$inv['amount']??0); } } }
  $txt="📈 داشبورد مدیریتی\nقراردادها: $contracts\nفاکتورهای باز: $invoices_unpaid\nمجموع مانده: ".fa_amount($sum_unpaid);
  edit_kb($chat,$mid,$txt,[ back_btn('ceo') ]); exit;
}
if($data==='ceo_settings'){
  global $SET;
  $s=Storage::readJson('settings.json',$SET);
  $txt="⚙️ تنظیمات عمومی\n— پیامک: ".($s['sms_enabled']?'فعال':'غیرفعال')."\n— جریمه عمومی: ".fa_amount($s['penalty_general'])."\n— جریمه تاخیر مانده فاکتور (روزانه): ".fa_amount($s['late_fee'])."\n— سهمیه ماهانه آفیش: ".intval($s['offish_quota'])." روز";
  $kb=[ [ ['text'=>'🔁 پیامک روشن/خاموش','callback_data'=>'ceo_sms_toggle'] ], back_btn('ceo') ];
  edit_kb($chat,$mid,$txt,$kb); exit;
}
if($data==='ceo_sms_toggle'){ $s=Storage::readJson('settings.json',$SET); $s['sms_enabled']=!$s['sms_enabled']; Storage::writeJson('settings.json',$s); edit_kb($chat,$mid,"وضعیت پیامک: ".($s['sms_enabled']?'فعال':'غیرفعال'),[ back_btn('ceo_settings') ]); exit; }

// CEO – contracts awaiting signature
if($data==='ceo_sign_contracts'){
  $dir=__DIR__.'/storage/contracts'; $rows=[]; foreach(is_dir($dir)?scandir($dir):[] as $f){ if(substr($f,-5)==='.json'){ $c=Storage::readJson('contracts/'.$f,[]); if(($c['status']??'')==='await_signature') $rows[]=$c; } }
  if(!$rows){ edit_kb($chat,$mid,'قراردادی در صف امضا نیست.',[ back_btn('ceo') ]); exit; }
  $txt="قراردادهای منتظر امضا:\n"; $kb=[];
  foreach(array_slice($rows,0,10) as $c){
    $txt.="— {$c['id']} | {$c['title']} | مبلغ: ".fa_amount($c['amount'])."\n";
    $kb[]=[ ['text'=>"✔️ امضا {$c['id']}",'callback_data'=>'ctr_sign:'.$c['id']], ['text'=>"❌ رد {$c['id']}",'callback_data'=>'ctr_reject:'.$c['id']] ];
  }
  $kb[] = back_btn('ceo');
  edit_kb($chat,$mid,$txt,$kb); exit;
}
if(strpos($data,'ctr_sign:')===0 || strpos($data,'ctr_reject:')===0){
  $id=explode(':',$data)[1]; $c=Storage::readJson('contracts/'.$id.'.json',null); if(!$c){ exit; }
  if(strpos($data,'ctr_sign:')===0){
    $c['status']='signed'; $c['signed_at']=time(); Storage::writeJson('contracts/'.$id.'.json',$c);
    $inv_id='INV'.time();
    $inv=['id'=>$inv_id,'client'=>$c['client'],'title'=>$c['title'],'amount'=>intval($c['amount']),'remaining'=>intval($c['amount']),'due_at'=>time()+3*86400,'status'=>'unpaid','created_at'=>time(),'prepay'=>0];
    Storage::writeJson('invoices/'.$inv_id.'.json',$inv);
    $tg->sendMessage($chat,"قرارداد امضا و فاکتور $inv_id ایجاد شد ✅");
  }else{
    $c['status']='rejected'; $c['rejected_at']=time(); Storage::writeJson('contracts/'.$id.'.json',$c);
    $tg->sendMessage($chat,"قرارداد رد شد.");
  }
  $dir=__DIR__.'/storage/contracts'; $rows=[]; foreach(is_dir($dir)?scandir($dir):[] as $f){ if(substr($f,-5)==='.json'){ $c2=Storage::readJson('contracts/'.$f,[]); if(($c2['status']??'')==='await_signature') $rows[]=$c2; } }
  if(!$rows){ edit_kb($chat,$mid,'قراردادی در صف امضا نیست.',[ back_btn('ceo') ]); }
  else{ $txt="قراردادهای منتظر امضا:\n"; $kb=[]; foreach(array_slice($rows,0,10) as $c2){ $txt.="— {$c2['id']} | {$c2['title']} | مبلغ: ".fa_amount($c2['amount'])."\n"; $kb[]=[ ['text'=>"✔️ امضا {$c2['id']}",'callback_data'=>'ctr_sign:'.$c2['id']], ['text'=>"❌ رد {$c2['id']}",'callback_data'=>'ctr_reject:'.$c2['id']] ]; } $kb[] = back_btn('ceo'); edit_kb($chat,$mid,$txt,$kb); }
  exit;
}
if($data==='ceo_leaves'){
  $dir=__DIR__.'/storage/hr'; $rows=[]; foreach(is_dir($dir)?scandir($dir):[] as $f){ if(substr($f,-5)==='.json'){ $x=Storage::readJson('hr/'.$f,[]); if(($x['type']??'')==='leave' && ($x['status']??'')==='pending_ceo') $rows[]=$x; } }
  if(!$rows){ edit_kb($chat,$mid,'مرخصی منتظر مدیرعامل نیست.',[ back_btn('ceo') ]); exit; }
  $txt="مرخصی‌های منتظر تایید مدیرعامل:\n"; $kb=[];
  foreach(array_slice($rows,0,10) as $x){ $txt.="— {$x['id']} | {$x['date']} | ".(($x['leave_kind']??'')==='half'?'نیم‌روز':'تمام‌روز')."\n"; $kb[]=[ ['text'=>"✔️ {$x['id']}",'callback_data'=>"lv_appr:pending_ceo:{$x['id']}"], ['text'=>"❌ {$x['id']}",'callback_data'=>"lv_rej:pending_ceo:{$x['id']}"] ]; }
  $kb[] = back_btn('ceo'); edit_kb($chat,$mid,$txt,$kb); exit;
}
if($data==='ceo_offdoc'){ $kb=[ [ ['text'=>'➕ ثبت سند رسمی','callback_data'=>'offdoc_new:ceo'], ['text'=>'📚 لیست اسناد','callback_data'=>'offdoc_list:ceo'] ], back_btn('ceo') ]; edit_kb($chat,$mid,'👑 مدیرعامل – اسناد رسمی',$kb); exit; }

// Maintenance late fee
if($data==='sys_maint'){
  global $SET;
  $idir=__DIR__.'/storage/invoices'; $count=0;
  $now=time(); foreach(is_dir($idir)?scandir($idir):[] as $f){
    if(substr($f,-5)==='.json'){
      $inv=Storage::readJson('invoices/'.$f,[]);
      if(($inv['status']??'')!=='paid' && $now>($inv['due_at']??$now)){
        $days = floor(($now-($inv['due_at']))/86400);
        $late_fee = $days * intval($SET['late_fee']);
        $target = max(0, intval($inv['remaining']) + $late_fee);
        if($target != $inv['remaining']){ $inv['remaining']=$target; Storage::writeJson('invoices/'.$inv['id'].'.json',$inv); $count++; }
      }
    }
  }
  edit_kb($chat,$mid,"نگهداری انجام شد.\nفاکتورهای به‌روزرسانی‌شده: $count",[ back_btn('ceo') ]); exit;
}

// ===== ACCOUNTING =====
if($data==='acc'){
  $kb=[
    [ ['text'=>'🧾 فاکتور/قرارداد','callback_data'=>'acc_ic'], ['text'=>'💳 پرداخت‌ها و پیش‌پرداخت','callback_data'=>'acc_pay'] ],
    [ ['text'=>'🗓 مرخصی‌ها','callback_data'=>'acc_leaves'], ['text'=>'📜 اسناد رسمی','callback_data'=>'acc_offdoc'] ],
    [ ['text'=>'📥 رسیدهای پرداخت','callback_data'=>'acc_receipts'] ],
    back_btn('root')
  ];
  edit_kb($chat,$mid,'💰 حسابداری',$kb); exit;
}
if($data==='acc_offdoc'){ $kb=[ [ ['text'=>'➕ ثبت سند رسمی','callback_data'=>'offdoc_new:acc'], ['text'=>'📚 لیست اسناد','callback_data'=>'offdoc_list:acc'] ], back_btn('acc') ]; edit_kb($chat,$mid,'💰 حسابداری – اسناد رسمی',$kb); exit; }
if($data==='acc_leaves'){
  $dir=__DIR__.'/storage/hr'; $rows=[]; foreach(is_dir($dir)?scandir($dir):[] as $f){ if(substr($f,-5)==='.json'){ $x=Storage::readJson('hr/'.$f,[]); if(($x['type']??'')==='leave' && ($x['status']??'')==='pending_accounting') $rows[]=$x; } }
  if(!$rows){ edit_kb($chat,$mid,'مرخصی منتظر حسابداری نیست.',[ back_btn('acc') ]); exit; }
  $txt="مرخصی‌های منتظر حسابداری:\n"; $kb=[]; foreach(array_slice($rows,0,10) as $x){ $txt.="— {$x['id']} | {$x['date']} | ".(($x['leave_kind']??'')==='half'?'نیم‌روز':'تمام‌روز')."\n"; $kb[]=[ ['text'=>"✔️ {$x['id']}",'callback_data'=>"lv_appr:pending_accounting:{$x['id']}"], ['text'=>"❌ {$x['id']}",'callback_data'=>"lv_rej:pending_accounting:{$x['id']}"] ]; } $kb[] = back_btn('acc'); edit_kb($chat,$mid,$txt,$kb); exit;
}
if($data==='acc_receipts'){
  $items=Storage::readJson('approvals/receipts.json',[]);
  if(!$items){ edit_kb($chat,$mid,'رسیدی در صف نیست.',[ back_btn('acc') ]); exit; }
  $txt="رسیدهای منتظر تایید:\n"; $kb=[]; foreach(array_slice(array_reverse($items),0,10) as $r){ if(($r['status']??'')==='pending'){ $txt.="— {$r['id']} | فاکتور: {$r['invoice_id']}\n"; $kb[]=[ ['text'=>"👁️ مشاهده {$r['id']}",'callback_data'=>'rcpt_view:'.$r['id']], ['text'=>"✔️ تایید",'callback_data'=>'rcpt_ok:'.$r['id']], ['text'=>"❌ رد",'callback_data'=>'rcpt_no:'.$r['id']] ]; } }
  $kb[] = back_btn('acc'); edit_kb($chat,$mid,$txt,$kb); exit;
}
if(strpos($data,'rcpt_view:')===0){
  $id=explode(':',$data)[1]; $items=Storage::readJson('approvals/receipts.json',[]);
  foreach($items as $r){ if($r['id']===$id){ $txt="رسید {$r['id']}\nفاکتور: {$r['invoice_id']}\nوضعیت: {$r['status']}"; edit_kb($chat,$mid,$txt,[ [ ['text'=>'دانلود عکس','callback_data'=>'rcpt_dl:'.$id] ], back_btn('acc_receipts') ]); exit; } }
}
if(strpos($data,'rcpt_dl:')===0){
  // فقط اعلان؛ دانلود واقعی فایل با getFile لازم است که در Telegram.php باید پیاده‌سازی باشد.
  $id=explode(':',$data)[1]; $tg->sendMessage($chat,"برای دریافت فایل، از بخش مدیریت دریافت فایل تلگرام استفاده کنید. شناسه رسید: $id");
  exit;
}
if(strpos($data,'rcpt_ok:')===0 || strpos($data,'rcpt_no:')===0){
  $id=explode(':',$data)[1];
  $items=Storage::readJson('approvals/receipts.json',[]);
  foreach($items as &$r){
    if($r['id']===$id){
      if(strpos($data,'rcpt_ok:')===0){ $r['status']='await_amount'; Storage::writeJson('approvals/receipts.json',$items); edit_kb($chat,$mid,"مبلغ تاییدی این رسید را وارد کنید (فقط عدد):",[ back_btn('acc_receipts') ]); $st=Storage::readJson("users/$uid/state.json",[]); $st['rcpt_amt']=$id; Storage::writeJson("users/$uid/state.json",$st); exit; }
      else { $r['status']='rejected'; Storage::writeJson('approvals/receipts.json',$items); edit_kb($chat,$mid,"رد شد.",[ back_btn('acc_receipts') ]); exit; }
    }
  }
}
if($txt!==''){
  $st=Storage::readJson("users/$uid/state.json",[]);
  if(isset($st['rcpt_amt'])){
    $id=$st['rcpt_amt']; $amt=intval(preg_replace('/\D+/','',$txt));
    $items=Storage::readJson('approvals/receipts.json',[]);
    foreach($items as &$r){
      if($r['id']===$id && $r['status']==='await_amount'){
        $r['status']='approved'; $r['amount']=$amt; Storage::writeJson('approvals/receipts.json',$items);
        $inv=Storage::readJson('invoices/'.$r['invoice_id'].'.json',[]);
        $inv['prepay'] = intval($inv['prepay']) + $amt;
        $inv['remaining'] = max(0, intval($inv['amount'])-intval($inv['prepay']));
        $inv['status'] = ($inv['remaining']>0 ? 'partial' : 'paid');
        Storage::writeJson('invoices/'.$inv['id'].'.json',$inv);
        if($inv['status']==='paid'){ send_kb($chat,"رسید تایید شد ✅\nفاکتور تسویه شد. مدیر دپارتمان را انتخاب کنید:",[[['text'=>'👤 انتخاب مدیر','callback_data'=>'assign_dep:'.$inv['id']]], back_btn('acc')]); }
        else { send_kb($chat,"رسید تایید شد ✅\nمانده: ".fa_amount($inv['remaining']),[ back_btn('acc_receipts') ]); }
        $st['rcpt_amt']=null; Storage::writeJson("users/$uid/state.json",$st); exit;
      }
    }
  }
}

// Invoices & contracts hub
if($data==='acc_ic'){
  $kb=[
    [ ['text'=>'➕ ثبت فاکتور','callback_data'=>'inv_new'], ['text'=>'📋 لیست فاکتورها','callback_data'=>'inv_list'] ],
    [ ['text'=>'📝 ثبت قرارداد (الگو/اختصاصی)','callback_data'=>'ctr_new'], ['text'=>'📄 لیست قراردادها','callback_data'=>'ctr_list'] ],
    [ ['text'=>'📑 قالب‌های قرارداد','callback_data'=>'ctr_tpl'] ],
    back_btn('acc')
  ];
  edit_kb($chat,$mid,'🧾 فاکتور / قرارداد',$kb); exit;
}

// Create invoice flow kept (client→title→amount→due)
if($data==='inv_new'){
  $st=Storage::readJson("users/$uid/state.json",[]); $st['inv']=['step'=>'client']; Storage::writeJson("users/$uid/state.json",$st);
  $dir=__DIR__.'/storage/clients'; $rows=[]; foreach(is_dir($dir)?scandir($dir):[] as $f){ if(substr($f,-5)==='.json'){ $rows[]=Storage::readJson('clients/'.$f,[]); } }
  if(!$rows){ edit_kb($chat,$mid,'هنوز مشتری نداریم. اول از «📇 مشتریان» ثبت کن.',[ back_btn('acc_ic') ]); exit; }
  $kb=[]; foreach(array_slice(array_reverse($rows),0,10) as $c){ $kb[]=[ ['text'=>$c['id'].' | '.$c['name'],'callback_data'=>'inv_pick_client:'.$c['id']] ]; }
  $kb[] = back_btn('acc_ic');
  edit_kb($chat,$mid,'مشتری فاکتور را انتخاب کن:',$kb); exit;
}
if(strpos($data,'inv_pick_client:')===0){
  $cid=explode(':',$data)[1];
  $st=Storage::readJson("users/$uid/state.json",[]); $st['inv']=['step'=>'title','client'=>$cid]; Storage::writeJson("users/$uid/state.json",$st);
  edit_kb($chat,$mid,'عنوان خدمت را ارسال کن:',[ back_btn('acc_ic') ]); exit;
}
if($txt!==''){
  $st=Storage::readJson("users/$uid/state.json",[]);
  if(($st['inv']['step']??'')==='title'){
    $st['inv']['title']=$txt; $st['inv']['step']='amount'; Storage::writeJson("users/$uid/state.json",$st);
    $tg->sendMessage($chat,'مبلغ به تومان را فقط عدد ارسال کن:');
  } elseif(($st['inv']['step']??'')==='amount'){
    $amt = intval(preg_replace('/\D+/','',$txt)); if($amt<=0){ $tg->sendMessage($chat,'عدد معتبر نیست. دوباره مقدار عددی بفرست.'); }
    else { $st['inv']['amount']=$amt; $st['inv']['step']='due'; Storage::writeJson("users/$uid/state.json",$st);
      $kb=[]; for($i=0;$i<14;$i++){ $ts=time()+$i*86400; list($y,$m,$d)=JDate::toJalali((int)date('Y',$ts),(int)date('n',$ts),(int)date('j',$ts)); $kb[]=[ ['text'=>jlabel($y,$m,$d),'callback_data'=>'inv_due:'.$ts] ]; }
      $kb[] = back_btn('acc_ic');
      $tg->sendMessage($chat,'تاریخ سررسید را انتخاب کن:', ikb($kb));
    }
  } elseif(($st['ctr']['step']??'')==='custom_text'){
    $id='CTR'.time();
    $rec=['id'=>$id,'client'=>$st['ctr']['client'],'title'=>$st['ctr']['title'],'text'=>$txt,'amount'=>intval($st['ctr']['amount']??0),'status'=>'await_signature','created_at'=>time()];
    Storage::writeJson('contracts/'.$id.'.json',$rec);
    $st['ctr']=null; Storage::writeJson("users/$uid/state.json",$st);
    send_kb($chat,"قرارداد اختصاصی ثبت شد و منتظر امضاست ✅\n$id",[ back_btn('acc_ic') ]); exit;
  } elseif(($st['tpl_fill']['step']??'')==='title'){
    $st['tpl_fill']['title']=$txt; $st['tpl_fill']['step']='amount'; Storage::writeJson("users/$uid/state.json",$st);
    $tg->sendMessage($chat,'مبلغ قرارداد (فقط عدد)؟');
  } elseif(($st['tpl_fill']['step']??'')==='amount'){
    $amt=intval(preg_replace('/\D+/','',$txt)); $st['tpl_fill']['amount']=$amt; $st['tpl_fill']['step']='sdate'; Storage::writeJson("users/$uid/state.json",$st);
    $kb=[]; for($i=0;$i<14;$i++){ $ts=time()+$i*86400; list($y,$m,$d)=JDate::toJalali((int)date('Y',$ts),(int)date('n',$ts),(int)date('j',$ts)); $kb[]=[ ['text'=>jlabel($y,$m,$d),'callback_data'=>'tpl_sdate:'.$ts] ]; }
    $kb[] = back_btn('acc_ic'); $tg->sendMessage($chat,'تاریخ شروع را انتخاب کن:',ikb($kb));
  }
}
if(strpos($data,'inv_due:')===0){
  $due_ts=intval(explode(':',$data)[1]);
  $st=Storage::readJson("users/$uid/state.json",[]);
  $inv_id='INV'.time();
  $rec=['id'=>$inv_id,'client'=>$st['inv']['client'],'title'=>$st['inv']['title'],'amount'=>$st['inv']['amount'],'remaining'=>$st['inv']['amount'],'due_at'=>$due_ts,'status'=>'unpaid','created_at'=>time(),'prepay'=>0];
  Storage::writeJson('invoices/'.$inv_id.'.json',$rec);
  $st['inv']=null; Storage::writeJson("users/$uid/state.json",$st);
  $kb=[ [ ['text'=>'📨 ارسال به مشتری','callback_data'=>'inv_send:'.$inv_id], ['text'=>'✅ پرداخت کامل','callback_data'=>'inv_paid:'.$inv_id] ],
        [ ['text'=>'💳 ثبت پیش‌پرداخت','callback_data'=>'inv_prepay:'.$inv_id], ['text'=>'👁️ مشاهده','callback_data'=>'inv_view:'.$inv_id] ],
        back_btn('acc_ic') ];
  edit_kb($chat,$mid,"فاکتور ثبت شد ✅\n$inv_id | مبلغ: ".fa_amount($rec['amount'])."\nسررسید: ".jlabel_ts($due_ts),$kb); exit;
}
if($data==='inv_list'){
  $dir=__DIR__.'/storage/invoices'; $rows=[];
  foreach(is_dir($dir)?scandir($dir):[] as $f){ if(substr($f,-5)==='.json'){ $rows[]=Storage::readJson('invoices/'.$f,[]); } }
  if(!$rows){ edit_kb($chat,$mid,'فاکتوری ثبت نشده.',[ back_btn('acc_ic') ]); exit; }
  usort($rows,function($a,$b){ return ($b['created_at']??0)-($a['created_at']??0); });
  $txt="📋 لیست فاکتورها:\n"; $kb=[];
  foreach(array_slice($rows,0,10) as $x){
    $txt.="— {$x['id']} | {$x['title']} | ".fa_amount($x['remaining'])." | ".($x['status']??'')."\n";
    $kb[]=[ ['text'=>'👁️ '.$x['id'],'callback_data'=>'inv_view:'.$x['id']] ];
  }
  $kb[] = back_btn('acc_ic');
  edit_kb($chat,$mid,$txt,$kb); exit;
}
if(strpos($data,'inv_view:')===0){
  $id=explode(':',$data)[1]; $inv=Storage::readJson('invoices/'.$id.'.json',[]); if(!$inv){ edit_kb($chat,$mid,'یافت نشد.',[ back_btn('inv_list') ]); exit; }
  $txt="🧾 فاکتور {$inv['id']}\nعنوان: {$inv['title']}\nمبلغ کل: ".fa_amount($inv['amount'])."\nپرداخت‌شده: ".fa_amount($inv['prepay'])."\nمانده: ".fa_amount($inv['remaining'])."\nوضعیت: {$inv['status']}\nسررسید: ".jlabel_ts($inv['due_at']);
  $kb=[
    [ ['text'=>'📨 ارسال به مشتری','callback_data'=>'inv_send:'.$id], ['text'=>'✅ پرداخت کامل','callback_data'=>'inv_paid:'.$id] ],
    [ ['text'=>'💳 ثبت پیش‌پرداخت','callback_data'=>'inv_prepay:'.$id], ['text'=>'👤 انتخاب مدیر','callback_data'=>'assign_dep:'.$id] ],
    back_btn('inv_list')
  ];
  edit_kb($chat,$mid,$txt,$kb); exit;
}

// Invoice send/paid/prepay already above
if(strpos($data,'inv_send:')===0){
  $id=explode(':',$data)[1]; $inv=Storage::readJson('invoices/'.$id.'.json',[]);
  $bank="شماره کارت: 5859838820334401\nشماره حساب: 03590300021\nشبا: IR410180000000103590300021\n— به نام شرکت البرز مدیا دوراندیش (ویژن مدیا)";
  $msg="فاکتور $id\nعنوان: {$inv['title']}\nمبلغ: ".fa_amount($inv['remaining'])."\nسررسید: ".jlabel_ts($inv['due_at'])."\n\n$bank\nلطفاً پس از پرداخت، رسید را ارسال کنید.";
  edit_kb($chat,$mid,"پیش‌نمایش پیام به مشتری:\n\n".$msg,[ back_btn('inv_view:'.$id) ]); exit;
}
if(strpos($data,'inv_paid:')===0){
  $id=explode(':',$data)[1]; $inv=Storage::readJson('invoices/'.$id.'.json',[]);
  $inv['remaining']=0; $inv['status']='paid'; $inv['paid_at']=time(); Storage::writeJson('invoices/'.$id.'.json',$inv);
  $kb=[ [ ['text'=>'👤 انتخاب مدیر دپارتمان','callback_data'=>'assign_dep:'.$id] ], back_btn('inv_view:'.$id) ];
  edit_kb($chat,$mid,"پرداخت کامل ثبت شد ✅\nاکنون مدیر دپارتمان را انتخاب کنید.",$kb); exit;
}
if(strpos($data,'inv_prepay:')===0){
  $id=explode(':',$data)[1]; $st=Storage::readJson("users/$uid/state.json",[]); $st['prepay']=['id'=>$id,'step'=>'amount']; Storage::writeJson("users/$uid/state.json",$st);
  edit_kb($chat,$mid,'مبلغ پیش‌پرداخت را (فقط عدد) ارسال کن:',[ back_btn('inv_view:'.$id) ]); exit;
}
if($txt!==''){
  $st=Storage::readJson("users/$uid/state.json",[]);
  if(isset($st['prepay']['step']) && $st['prepay']['step']==='amount'){
    $amt=intval(preg_replace('/\D+/','',$txt)); if($amt<=0){ $tg->sendMessage($chat,'عدد معتبر نیست.'); }
    else { $id=$st['prepay']['id']; $inv=Storage::readJson('invoices/'.$id.'.json',[]);
      $inv['prepay'] += $amt; $inv['remaining'] = max(0, intval($inv['amount'])-intval($inv['prepay'])); $inv['status'] = ($inv['remaining']>0?'partial':'paid'); Storage::writeJson('invoices/'.$id.'.json',$inv);
      $st['prepay']=null; Storage::writeJson("users/$uid/state.json",$st);
      $kb=[ [ ['text'=>'👤 انتخاب مدیر دپارتمان','callback_data'=>'assign_dep:'.$id] ], back_btn('inv_view:'.$id) ];
      send_kb($chat,"پیش‌پرداخت ثبت شد ✅\nمانده: ".fa_amount($inv['remaining']), $kb); exit;
    }
  }
}

// Contracts – templates flow exists; add list & view
if($data==='ctr_list'){
  $dir=__DIR__.'/storage/contracts'; $rows=[];
  foreach(is_dir($dir)?scandir($dir):[] as $f){ if(substr($f,-5)==='.json'){ $rows[]=Storage::readJson('contracts/'.$f,[]); } }
  if(!$rows){ edit_kb($chat,$mid,'قراردادی ثبت نشده.',[ back_btn('acc_ic') ]); exit; }
  usort($rows,function($a,$b){ return ($b['created_at']??0)-($a['created_at']??0); });
  $txt="📄 لیست قراردادها:\n"; $kb=[];
  foreach(array_slice($rows,0,10) as $x){
    $txt.="— {$x['id']} | {$x['title']} | ".fa_amount($x['amount'])." | ".($x['status']??'')."\n";
    $kb[]=[ ['text'=>'👁️ '.$x['id'],'callback_data'=>'ctr_view:'.$x['id']] ];
  }
  $kb[] = back_btn('acc_ic'); edit_kb($chat,$mid,$txt,$kb); exit;
}
if(strpos($data,'ctr_view:')===0){
  $id=explode(':',$data)[1]; $c=Storage::readJson('contracts/'.$id.'.json',[]); if(!$c){ edit_kb($chat,$mid,'یافت نشد.',[ back_btn('ctr_list') ]); exit; }
  $txt="📄 قرارداد {$c['id']}\nعنوان: {$c['title']}\nمشتری: {$c['client']}\nمبلغ: ".fa_amount($c['amount'])."\nوضعیت: {$c['status']}\n\n— خلاصه متن:\n".mb_substr($c['text']??'',0,300).(mb_strlen($c['text']??'')>300?'…':'');
  $kb=[
    [ ['text'=>'🖊 ارسال برای امضا (CEO)','callback_data'=>'ctr_send_ceo:'.$id] ],
    back_btn('ctr_list')
  ];
  edit_kb($chat,$mid,$txt,$kb); exit;
}
if(strpos($data,'ctr_send_ceo:')===0){
  $id=explode(':',$data)[1]; $c=Storage::readJson('contracts/'.$id.'.json',[]); if(!$c){ exit; }
  $c['status']='await_signature'; Storage::writeJson('contracts/'.$id.'.json',$c);
  edit_kb($chat,$mid,'به صف امضای مدیرعامل منتقل شد ✅',[ back_btn('ctr_view:'.$id) ]); exit;
}

// Assign to department manager
if(strpos($data,'assign_dep:')===0){
  $id=explode(':',$data)[1];
  $emps=emp_list();
  $mgrs=array_values(array_filter($emps, function($e){ return strpos($e['job']??'', 'مدیردپارتمان')!==false; }));
  if(!$mgrs){ edit_kb($chat,$mid,'هیچ مدیر دپارتمانی ثبت نشده.',[ back_btn('acc_ic') ]); exit; }
  $kb=[]; foreach($mgrs as $m){ $kb[]=[ ['text'=>$m['name'].' ('.$m['id'].')','callback_data'=>'assign_dep_pick:'.$id.':'.$m['id']] ]; }
  $kb[] = back_btn('inv_view:'.$id);
  edit_kb($chat,$mid,'مدیر دپارتمان را انتخاب کن:',$kb); exit;
}
if(strpos($data,'assign_dep_pick:')===0){
  $parts=explode(':',$data); $id=$parts[1]; $mid_emp=$parts[2];
  $inv=Storage::readJson('invoices/'.$id.'.json',[]);
  $inv['assigned_dep']=$mid_emp; $inv['project_id']='PRJ'.time(); Storage::writeJson('invoices/'.$id.'.json',$inv);
  $prj=['id'=>$inv['project_id'],'client'=>$inv['client'],'title'=>$inv['title'],'manager'=>$mid_emp,'status'=>'init','created_at'=>time(),'team'=>[]];
  Storage::writeJson('projects/'.$prj['id'].'.json',$prj);
  edit_kb($chat,$mid,"پروژه ساخته شد ✅\nشناسه: {$prj['id']}\nبه مدیر {$mid_emp} محول شد.",[ back_btn('inv_view:'.$id) ]); exit;
}

// ===== CLIENTS =====
if($data==='clients'){
  $kb=[
    [ ['text'=>'➕ مشتری جدید','callback_data'=>'cli_new'], ['text'=>'📋 لیست مشتریان','callback_data'=>'cli_list'] ],
    [ ['text'=>'👥 شخص مرتبط','callback_data'=>'cli_contact_add'], ['text'=>'🧾 فاکتور/قرارداد مشتری','callback_data'=>'cli_ic'] ],
    [ ['text'=>'📤 ارسال رسید پرداخت','callback_data'=>'cli_send_receipt'] ],
    back_btn('root')
  ];
  edit_kb($chat,$mid,'📇 مرکز مشتریان',$kb); exit;
}
if($data==='cli_new'){ $st=Storage::readJson("users/$uid/state.json", []); $st['cli']=['step'=>'name']; Storage::writeJson("users/$uid/state.json",$st); edit_kb($chat,$mid,'نام و نام خانوادگی مشتری را ارسال کنید:',[ back_btn('clients') ]); exit; }
if($txt!==''){
  $stc=Storage::readJson("users/$uid/state.json", []);
  if(($stc['cli']['step']??'')==='name'){ $stc['cli']['name']=$txt; $stc['cli']['step']='insta'; Storage::writeJson("users/$uid/state.json",$stc); $tg->sendMessage($chat,'آیدی پیج اینستاگرام (بدون @) را ارسال کنید:'); }
  elseif(($stc['cli']['step']??'')==='insta'){ $stc['cli']['insta']=$txt; $stc['cli']['step']='addr'; Storage::writeJson("users/$uid/state.json",$stc); $tg->sendMessage($chat,'آدرس مشتری را ارسال کنید:'); }
  elseif(($stc['cli']['step']??'')==='addr'){ $id='CLI'.time(); $rec=['id'=>$id,'name'=>$stc['cli']['name'],'insta'=>$stc['cli']['insta'],'address'=>$txt,'created_at':time()]; Storage::writeJson('clients/'.$id.'.json',$rec); $stc['cli']=null; Storage::writeJson("users/$uid/state.json",$stc); send_kb($chat,"مشتری ثبت شد ✅\n{$rec['id']} | {$rec['name']}",[ back_btn('clients') ]); }
}
if($data==='cli_list'){ $dir=__DIR__.'/storage/clients'; $rows=[]; foreach(is_dir($dir)?scandir($dir):[] as $f){ if(substr($f,-5)==='.json'){ $c=Storage::readJson('clients/'.$f,[]); $rows[]=$c; } } if(!$rows){ edit_kb($chat,$mid,'مشتری ثبت نشده.',[ back_btn('clients') ]); exit; } $txt="لیست مشتریان:\n"; $kb=[]; foreach($rows as $c){ $txt.="— {$c['id']} | {$c['name']} | ".($c['insta']??'')."\n"; $kb[]=[ ['text'=>'👁️ '.$c['id'],'callback_data'=>'cli_view:'.$c['id']] ]; } $kb[] = back_btn('clients'); edit_kb($chat,$mid,$txt,$kb); exit; }
if(strpos($data,'cli_view:')===0){
  $cid=explode(':',$data)[1]; $c=Storage::readJson('clients/'.$cid.'.json',[]);
  $txt="👤 {$c['name']} ({$c['id']})\nآیدی اینستاگرام: ".($c['insta']??'-')."\nآدرس: ".($c['address']??'-');
  $kb=[ [ ['text'=>'🧾 فاکتورها','callback_data'=>'cli_view_inv:'.$cid], ['text'=>'📄 قراردادها','callback_data'=>'cli_view_ctr:'.$cid] ], back_btn('cli_list') ];
  edit_kb($chat,$mid,$txt,$kb); exit;
}
if(strpos($data,'cli_view_inv:')===0){
  $cid=explode(':',$data)[1]; $dir=__DIR__.'/storage/invoices'; $rows=[];
  foreach(is_dir($dir)?scandir($dir):[] as $f){ if(substr($f,-5)==='.json'){ $x=Storage::readJson('invoices/'.$f,[]); if(($x['client']??'')==$cid) $rows[]=$x; } }
  if(!$rows){ edit_kb($chat,$mid,'فاکتوری برای این مشتری نیست.',[ back_btn('cli_view:'.$cid) ]); exit; }
  $txt="🧾 فاکتورهای مشتری:\n"; $kb=[]; foreach($rows as $x){ $txt.="— {$x['id']} | ".fa_amount($x['remaining'])." | ".($x['status']??'')."\n"; $kb[]=[ ['text'=>$x['id'],'callback_data'=>'inv_view:'.$x['id']] ]; } $kb[] = back_btn('cli_view:'.$cid); edit_kb($chat,$mid,$txt,$kb); exit;
}
if(strpos($data,'cli_view_ctr:')===0){
  $cid=explode(':',$data)[1]; $dir=__DIR__.'/storage/contracts'; $rows=[];
  foreach(is_dir($dir)?scandir($dir):[] as $f){ if(substr($f,-5)==='.json'){ $x=Storage::readJson('contracts/'.$f,[]); if(($x['client']??'')==$cid) $rows[]=$x; } }
  if(!$rows){ edit_kb($chat,$mid,'قراردادی برای این مشتری نیست.',[ back_btn('cli_view:'.$cid) ]); exit; }
  $txt="📄 قراردادهای مشتری:\n"; $kb=[]; foreach($rows as $x){ $txt.="— {$x['id']} | ".fa_amount($x['amount'])." | ".($x['status']??'')."\n"; $kb[]=[ ['text'=>$x['id'],'callback_data'=>'ctr_view:'.$x['id']] ]; } $kb[] = back_btn('cli_view:'.$cid); edit_kb($chat,$mid,$txt,$kb); exit;
}
// client send receipt
if($data==='cli_send_receipt'){
  $dir=__DIR__.'/storage/invoices'; $rows=[]; foreach(is_dir($dir)?scandir($dir):[] as $f){ if(substr($f,-5)==='.json'){ $x=Storage::readJson('invoices/'.$f,[]); if(($x['status']??'')!=='paid') $rows[]=$x; } }
  if(!$rows){ edit_kb($chat,$mid,'فاکتور باز وجود ندارد.',[ back_btn('clients') ]); exit; }
  $kb=[]; foreach(array_slice(array_reverse($rows),0,10) as $x){ $kb[]=[ ['text'=>$x['id'].' | '.$x['title'].' | مانده: '.fa_amount($x['remaining']),'callback_data'=>'cli_rcpt_pick:'.$x['id']] ]; }
  $kb[] = back_btn('clients'); edit_kb($chat,$mid,'برای کدام فاکتور رسید دارید؟',$kb); exit;
}
if(strpos($data,'cli_rcpt_pick:')===0){
  $inv=explode(':',$data)[1];
  $st=Storage::readJson("users/$uid/state.json",[]); $st['rcpt_send']=['invoice'=>$inv]; Storage::writeJson("users/$uid/state.json",$st);
  edit_kb($chat,$mid,'لطفاً عکس رسید پرداخت را ارسال کنید:',[ back_btn('clients') ]); exit;
}
if($photo){
  $st=Storage::readJson("users/$uid/state.json",[]);
  if(isset($st['rcpt_send']['invoice'])){
    $id='R'.time();
    $items=Storage::readJson('approvals/receipts.json',[]);
    $items[]=['id'=>$id,'invoice_id'=>$st['rcpt_send']['invoice'],'file_id'=>$photo,'from'=>$uid,'status'=>'pending','created_at'=>time()];
    Storage::writeJson('approvals/receipts.json',$items);
    $st['rcpt_send']=null; Storage::writeJson("users/$uid/state.json",$st);
    send_kb($chat,"رسید دریافت شد و برای حسابداری ارسال شد ✅\nشناسه: $id",[ back_btn('clients') ]); exit;
  }
}

// ===== Department Manager =====
if($data==='dep'){
  $kb=[
    [ ['text'=>'👥 تیم پروژه','callback_data'=>'dep_team'], ['text'=>'🎬 آفیش','callback_data'=>'dep_offish'] ],
    [ ['text'=>'🗓 مرخصی‌ها','callback_data'=>'dep_leaves'], ['text'=>'📜 اسناد رسمی','callback_data'=>'dep_offdoc'] ],
    [ ['text'=>'📦 پروژه‌های فعال','callback_data'=>'dep_projects'] ],
    back_btn('root')
  ];
  edit_kb($chat,$mid,'🧩 پنل مدیر دپارتمان',$kb); exit;
}
if($data==='dep_leaves'){
  $dir=__DIR__.'/storage/hr'; $rows=[]; foreach(is_dir($dir)?scandir($dir):[] as $f){ if(substr($f,-5)==='.json'){ $x=Storage::readJson('hr/'.$f,[]); if(($x['type']??'')==='leave' && ($x['status']??'')==='pending_manager') $rows[]=$x; } }
  if(!$rows){ edit_kb($chat,$mid,'مرخصی در صف مدیر نیست.',[ back_btn('dep') ]); exit; }
  $txt="مرخصی‌های منتظر مدیر:\n"; $kb=[]; foreach(array_slice($rows,0,10) as $x){ $txt.="— {$x['id']} | {$x['date']} | ".(($x['leave_kind']??'')==='half'?'نیم‌روز':'تمام‌روز')."\n"; $kb[]=[ ['text'=>"✔️ {$x['id']}",'callback_data'=>"lv_appr:pending_manager:{$x['id']}"], ['text'=>"❌ {$x['id']}",'callback_data'=>"lv_rej:pending_manager:{$x['id']}"] ]; } $kb[] = back_btn('dep'); edit_kb($chat,$mid,$txt,$kb); exit;
}
if($data==='dep_offdoc'){ $kb=[ [ ['text'=>'➕ ثبت سند رسمی','callback_data'=>'offdoc_new:dep'], ['text'=>'📚 لیست اسناد','callback_data'=>'offdoc_list:dep'] ], back_btn('dep') ]; edit_kb($chat,$mid,'🧩 مدیر دپارتمان – اسناد رسمی',$kb); exit; }

// Team formation
if($data==='dep_team'){
  $mgr=$uid; $idir=__DIR__.'/storage/invoices'; $projs=[];
  foreach(is_dir($idir)?scandir($idir):[] as $f){ if(substr($f,-5)==='.json'){ $x=Storage::readJson('invoices/'.$f,[]); if(($x['assigned_dep']??'')==$mgr && isset($x['project_id'])) $projs[]=$x['project_id']; } }
  if(!$projs){ edit_kb($chat,$mid,'پروژه‌ای به شما محول نشده.',[ back_btn('dep') ]); exit; }
  $kb=[]; foreach(array_slice($projs,0,10) as $pid){ $kb[]=[ ['text'=>$pid,'callback_data'=>'dep_team_pick:'.$pid] ]; } $kb[] = back_btn('dep');
  edit_kb($chat,$mid,'پروژه را انتخاب کنید:', $kb); exit;
}
if(strpos($data,'dep_team_pick:')===0){
  $pid=explode(':',$data)[1];
  $roles=[ 'scenarist'=>'✍️ سناریونویس', 'blogger'=>'📝 بلاگر', 'cameraman'=>'📷 تصویربردار', 'editor'=>'🎞 تدوینگر', 'admin'=>'🛠 ادمین' ];
  $kb=[]; foreach($roles as $k=>$v){ $kb[]=[ ['text'=>$v,'callback_data'=>'dep_team_role:'.$pid.':'.$k] ]; }
  $kb[] = back_btn('dep_team');
  edit_kb($chat,$mid,'نقشی را برای انتصاب انتخاب کنید:', $kb); exit;
}
if(strpos($data,'dep_team_role:')===0){
  $parts=explode(':',$data); $pid=$parts[1]; $role=$parts[2];
  $emps=emp_list();
  $map=[ 'scenarist'=>'سناریو نویس','blogger'=>'بلاگر','cameraman'=>'تصویربردار','editor'=>'تدوینگر','admin'=>'ادمین' ];
  $list=array_values(array_filter($emps,function($e)use($map,$role){ return strpos($e['job']??'', $map[$role])!==false; }));
  if(!$list){ edit_kb($chat,$mid,'پرسنل مرتبط یافت نشد.',[ back_btn('dep_team') ]); exit; }
  $kb=[]; foreach($list as $p){ $kb=[ ['text'=>$p['name'].' ('.$p['id'].')','callback_data'=>'dep_team_assign:'.$pid.':'.$role.':'.$p['id']] ]; echo ''; }
  $kb=[]; foreach($list as $p){ $kb[]=[ ['text'=>$p['name'].' ('.$p['id'].')','callback_data'=>'dep_team_assign:'.$pid.':'.$role.':'.$p['id']] ]; }
  $kb[] = back_btn('dep_team'); edit_kb($chat,$mid,'شخص را انتخاب کنید:', $kb); exit;
}
if(strpos($data,'dep_team_assign:')===0){
  $parts=explode(':',$data); $pid=$parts[1]; $role=$parts[2]; $eid=$parts[3];
  $prj=Storage::readJson('projects/'.$pid.'.json',['id'=>$pid,'team'=>[]]); if(!isset($prj['team'])) $prj['team']=[]; $prj['team'][$role]=$eid; Storage::writeJson('projects/'.$pid.'.json',$prj);
  edit_kb($chat,$mid,"انتصاب انجام شد ✅\n$role → $eid",[ back_btn('dep_team') ]); exit;
}

// Offish scheduling & notifications
if($data==='dep_offish'){
  $mgr=$uid; $idir=__DIR__.'/storage/invoices'; $rows=[];
  foreach(is_dir($idir)?scandir($idir):[] as $f){ if(substr($f,-5)==='.json'){ $x=Storage::readJson('invoices/'.$f,[]); if(($x['assigned_dep']??'')==$mgr && isset($x['project_id'])) $rows[]=$x; } }
  if(!$rows){ edit_kb($chat,$mid,'پروژه‌ای به شما محول نشده.',[ back_btn('dep') ]); exit; }
  $kb=[]; foreach(array_slice($rows,0,10) as $x){ $kb[]=[ ['text'=>$x['project_id'].' | '.$x['title'],'callback_data'=>'offish_pick:'.$x['project_id']] ]; }
  $kb[] = back_btn('dep'); edit_kb($chat,$mid,'پروژه را برای تنظیم آفیش انتخاب کنید:',$kb); exit;
}
if(strpos($data,'offish_pick:')===0){
  $pid=explode(':',$data)[1];
  $st=Storage::readJson("users/$uid/state.json",[]); $st['offish']=['pid'=>$pid,'step'=>'date']; Storage::writeJson("users/$uid/state.json",$st);
  $kb=[]; for($i=0;$i<14;$i++){ $ts=time()+$i*86400; list($y,$m,$d)=JDate::toJalali((int)date('Y',$ts),(int)date('n',$ts),(int)date('j',$ts)); $kb[]=[ ['text'=>jlabel($y,$m,$d),'callback_data'=>'offish_date:'.$ts] ]; }
  $kb[] = back_btn('dep_offish'); edit_kb($chat,$mid,'تاریخ آفیش را انتخاب کنید:',$kb); exit;
}
if(strpos($data,'offish_date:')===0){
  $ts=intval(explode(':',$data)[1]); $st=Storage::readJson("users/$uid/state.json",[]); $st['offish']['date']=$ts; $st['offish']['step']='time'; Storage::writeJson("users/$uid/state.json",$st);
  $kb=[]; foreach([9,10,11,12,13,14,15,16,17] as $h){ $kb[]=[ ['text'=>sprintf('%02d:00',$h),'callback_data'=>'offish_time:'.$h] ]; }
  $kb[] = back_btn('dep_offish'); edit_kb($chat,$mid,'ساعت حضور را انتخاب کنید:',$kb); exit;
}
if(strpos($data,'offish_time:')===0){
  $h=intval(explode(':',$data)[1]); $st=Storage::readJson("users/$uid/state.json",[]); $st['offish']['hour']=$h; $st['offish']['step']='confirm'; Storage::writeJson("users/$uid/state.json",$st);
  $dts = $st['offish']['date'] + ($h*3600);
  $txt="آفیش جدید:\nپروژه: {$st['offish']['pid']}\nزمان: ".jlabel_ts($dts)."\nتایید می‌کنید؟";
  $kb=[ [ ['text'=>'✔️ تایید','callback_data'=>'offish_ok'], ['text'=>'❌ انصراف','callback_data'=>'dep_offish'] ] ]; edit_kb($chat,$mid,$txt,$kb); exit;
}
if($data==='offish_ok'){
  $st=Storage::readJson("users/$uid/state.json",[]);
  $pid=$st['offish']['pid']; $dts=$st['offish']['date'] + ($st['offish']['hour']*3600);
  $id='OF'.time(); $rec=['id'=>$id,'project'=>$pid,'datetime'=>$dts,'created_by'=>$uid,'status'=>'scheduled','acks'=>[]];
  Storage::writeJson('offish/'.$id.'.json',$rec);
  $st['offish']=null; Storage::writeJson("users/$uid/state.json",$st);
  $prj=Storage::readJson('projects/'.$pid.'.json',[]); $team=$prj['team']??[];
  foreach(['blogger','cameraman'] as $r){
    if(isset($team[$r])){
      $tg->sendMessage($team[$r],
        "📣 برنامه آفیش جدید برای پروژه {$pid}\n⏰ ".jlabel_ts($dts)."\nلطفاً وضعیت را مشخص کنید.",
        ikb([
          [ ['text'=>'✔️ تایید حضور','callback_data'=>'offish_ack:yes:'.$id.':'.$r], ['text'=>'❌ عدم حضور','callback_data'=>'offish_ack:no:'.$id.':'.$r] ],
          [ ['text'=>'📍 رسیدم','callback_data'=>'offish_arrive:'.$id.':'.$r], ['text'=>'⏳ تاخیر دارم','callback_data'=>'offish_delay:'.$id.':'.$r] ]
        ])
      );
    }
  }
  edit_kb($chat,$mid,"آفیش ثبت و اطلاع‌رسانی شد ✅\n{$id} | ".jlabel_ts($dts),[ back_btn('dep_offish') ]); exit;
}
if(strpos($data,'offish_ack:')===0){
  $parts=explode(':',$data); $ans=$parts[1]; $id=$parts[2]; $role=$parts[3];
  $off=Storage::readJson('offish/'.$id.'.json',null); if(!$off){ exit; }
  if(!isset($off['acks'])) $off['acks']=[]; $off['acks'][$role]=$ans; Storage::writeJson('offish/'.$id.'.json',$off);
  if($ans==='no'){
    $prj=Storage::readJson('projects/'.$off['project'].'.json',[]);
    if(isset($prj['manager'])){ $tg->sendMessage($prj['manager'],"⚠️ {$role} برای آفیش {$off['id']} عدم حضور زد."); }
  }
  $tg->sendMessage($chat, $ans==='yes' ? "حضور شما ثبت شد ✅" : "عدم حضور ثبت شد ❌");
  exit;
}
if(strpos($data,'offish_arrive:')===0){
  $parts=explode(':',$data); $id=$parts[1]; $role=$parts[2];
  $off=Storage::readJson('offish/'.$id.'.json',null); if(!$off){ exit; }
  if(!isset($off['start_ts'])){ $off['start_ts']=time(); $off['status']='in_progress'; Storage::writeJson('offish/'.$id.'.json',$off); $tg->sendMessage($chat,"⏱️ تایمر حضور شروع شد. تا ۳۰ دقیقه دیگر دکمه «اتمام آفیش» فعال می‌شود."); }
  else { $tg->sendMessage($chat,"قبلاً شروع شده: ".jlabel_ts($off['start_ts'])); }
  exit;
}
if(strpos($data,'offish_delay:')===0){
  $parts=explode(':',$data); $id=$parts[1]; $role=$parts[2];
  $off=Storage::readJson('offish/'.$id.'.json',null); if(!$off){ exit; }
  $off['delayed_by'][$role]=time(); Storage::writeJson('offish/'.$id.'.json',$off);
  $prj=Storage::readJson('projects/'.$off['project'].'.json',[]);
  if(isset($prj['manager'])){ $tg->sendMessage($prj['manager'],"⏳ {$role} اعلام «تاخیر دارم» برای آفیش {$off['id']}"); }
  $tg->sendMessage($chat,"تاخیر ثبت شد. لطفاً سریعاً هماهنگ کنید.");
  exit;
}
if(strpos($data,'offish_finish:')===0){
  $id=explode(':',$data)[1]; $off=Storage::readJson('offish/'.$id.'.json',null); if(!$off){ exit; }
  if(!isset($off['start_ts'])){ $tg->sendMessage($chat,"هنوز «رسیدم» نزده‌اید."); exit; }
  $passed = time()-$off['start_ts'];
  if($passed < 1800){ $tg->sendMessage($chat,"⏱️ هنوز ".(1800-$passed)." ثانیه تا فعال شدن «اتمام آفیش» مانده."); exit; }
  $off['finished_at']=time(); $off['status']='finished'; Storage::writeJson('offish/'.$id.'.json',$off);
  $tg->sendMessage($chat,"✅ آفیش پایان یافت. مدت حضور: ".round(($off['finished_at']-$off['start_ts'])/60)." دقیقه.");
  exit;
}

// Cameraman panel – My Offish
if($data==='cam'){
  $kb=[
    [ ['text'=>'🎬 آفیش‌های من','callback_data'=>'cam_offish'] ],
    [ ['text'=>'📅 برنامه‌ریزی لوکیشن‌ها','callback_data'=>'cam_plan'], ['text'=>'📤 ارسال فایل‌ها','callback_data'=>'cam_send'] ],
    [ ['text'=>'📝 گزارش هزینه/زمان','callback_data'=>'cam_report'], ['text'=>'📦 آرشیو فایل خام','callback_data'=>'cam_archive'] ],
    [ ['text'=>'📋 تجهیزات مورد استفاده','callback_data'=>'cam_gear'] ],
    back_btn('root')
  ];
  edit_kb($chat,$mid,'📷 پنل تصویربردار',$kb); exit;
}
if($data==='cam_offish'){
  // find projects where user is cameraman
  $pdir=__DIR__.'/storage/projects'; $list=[];
  foreach(is_dir($pdir)?scandir($pdir):[] as $f){ if(substr($f,-5)==='.json'){ $p=Storage::readJson('projects/'.$f,[]); if(($p['team']['cameraman']??'')==$uid) $list[]=$p['id']; } }
  $odir=__DIR__.'/storage/offish'; $offs=[];
  foreach(is_dir($odir)?scandir($odir):[] as $f){ if(substr($f,-5)==='.json'){ $o=Storage::readJson('offish/'.$f,[]); if(in_array($o['project']??'', $list)) $offs[]=$o; } }
  if(!$offs){ edit_kb($chat,$mid,'برای شما آفیشی ثبت نشده.',[ back_btn('cam') ]); exit; }
  usort($offs,function($a,$b){ return ($a['datetime']??0)-($b['datetime']??0); });
  $txt="🎬 آفیش‌های شما:\n"; $kb=[];
  foreach(array_slice($offs,0,10) as $o){
    $txt.="— {$o['id']} | ".jlabel_ts($o['datetime'])." | ".($o['status']??'scheduled')."\n";
    $row=[ ['text'=>'📍 رسیدم','callback_data'=>'offish_arrive:'.$o['id'].':cameraman'], ['text'=>'⏳ تاخیر','callback_data'=>'offish_delay:'.$o['id'].':cameraman'] ];
    if(isset($o['start_ts'])){ $row[]=['text'=>'✅ اتمام','callback_data'=>'offish_finish:'.$o['id']]; }
    $kb[]=$row;
  }
  $kb[] = back_btn('cam'); edit_kb($chat,$mid,$txt,$kb); exit;
}

// ===== HR (leave only) =====
if($data==='hr'){
  $kb=[ [ ['text'=>'🗓 مرخصی جدید','callback_data'=>'hr_leave_new'] ], [ ['text'=>'📜 درخواست‌های من','callback_data'=>'hr_mine'] ], back_btn('root') ];
  edit_kb($chat,$mid,'👤 منابع انسانی',$kb); exit;
}
if($data==='hr_leave_new'){
  Storage::writeJson("users/$uid/state.json", ['hr'=>['type'=>'leave','step'=>'date']]);
  $kb=[]; for($i=0;$i<7;$i++){ $d=time()+$i*86400; list($y,$m,$dd)=JDate::toJalali((int)date('Y',$d),(int)date('n',$d),(int)date('j',$d)); $kb[]=[ ['text'=>jlabel($y,$m,$dd), 'callback_data'=>'hr_date:'.$d] ]; }
  $kb[] = back_btn('hr'); edit_kb($chat,$mid,'تاریخ مرخصی را انتخاب کنید:',$kb); exit;
}
if(strpos($data,'hr_date:')===0){
  $d=intval(explode(':',$data)[1]); $st=Storage::readJson("users/$uid/state.json", []); $st['hr']['date']=jlabel_ts($d); Storage::writeJson("users/$uid/state.json",$st);
  $kb=[ [ ['text'=>'🔸 نیم‌روز','callback_data'=>'hr_leave_half'], ['text'=>'🔷 تمام‌روز','callback_data'=>'hr_leave_full'] ], back_btn('hr') ];
  edit_kb($chat,$mid,'مرخصی نیم‌روز یا تمام‌روز؟ سپس دلیل را ارسال کنید.',$kb); exit;
}
if($data==='hr_leave_half' || $data==='hr_leave_full'){
  $st=Storage::readJson("users/$uid/state.json", []); $st['hr']['leave_kind']= ($data==='hr_leave_half')?'half':'full'; $st['hr']['step']='reason'; Storage::writeJson("users/$uid/state.json",$st);
  edit_kb($chat,$mid,'دلیل مرخصی را به‌صورت متن ارسال کنید:',[ back_btn('hr') ]); exit;
}
if($txt!==''){
  $shr=Storage::readJson("users/$uid/state.json", []);
  if(($shr['hr']['step']??'')==='reason'){
    $shr['hr']['reason']=$txt; Storage::writeJson("users/$uid/state.json",$shr);
    $h=$shr['hr']; $id='HR'.time();
    $rec=['id'=>$id,'uid'=>$uid,'type'=>'leave','date'=>$h['date'],'leave_kind'=>$h['leave_kind'],'reason'=>$h['reason'],'created_at'=>time(),'status'=>'pending_manager'];
    Storage::writeJson('hr/'.$id.'.json',$rec);
    $shr['hr']=null; Storage::writeJson("users/$uid/state.json",$shr);
    send_kb($chat,"درخواست مرخصی ثبت شد ✅\nشناسه: $id\nوضعیت: در انتظار تایید مدیر دپارتمان",[ back_btn('hr') ]); exit;
  }
}
if($data==='hr_mine'){
  $dir=__DIR__.'/storage/hr'; $rows=[]; foreach(is_dir($dir)?scandir($dir):[] as $f){ if(substr($f,-5)==='.json'){ $x=Storage::readJson('hr/'.$f,[]); if(($x['uid']??0)==$uid) $rows[]=$x; } }
  if(!$rows){ edit_kb($chat,$mid,'درخواستی ندارید.',[ back_btn('hr') ]); exit; }
  $txt="درخواست‌های شما:\n"; foreach($rows as $x){ $txt.="— {$x['id']} | مرخصی | {$x['date']} | ".($x['status'])."\n"; }
  edit_kb($chat,$mid,$txt,[ back_btn('hr') ]); exit;
}

// ===== Leave approvals (shared) =====
if(strpos($data,'lv_appr:')===0 || strpos($data,'lv_rej:')===0){
  $parts=explode(':',$data); $action = $parts[0]=='lv_appr'?'approve':'reject'; $stage=$parts[1]; $id=$parts[2]??'';
  $rec=Storage::readJson('hr/'.$id.'.json', null); if(!$rec){ exit; }
  if($rec['type']!=='leave'){ exit; }
  if($action==='approve'){ if($stage==='pending_manager'){ $rec['status']='pending_accounting'; } elseif($stage==='pending_accounting'){ $rec['status']='pending_ceo'; } elseif($stage==='pending_ceo'){ $rec['status']='approved'; $rec['approved_at']=time(); } } else { $rec['status']='rejected_at_'.$stage; $rec['rejected_at']=time(); }
  Storage::writeJson('hr/'.$id.'.json',$rec);
  $tg->sendMessage($chat,'به‌روزرسانی انجام شد.');
  exit;
}

// ===== Admin (root_admin) =====
if($data==='root_admin'){
  $kb=[
    [ ['text'=>'🎫 تیکت‌ها','callback_data'=>'adm_tickets'], ['text'=>'🛒 سفارش‌ها','callback_data'=>'adm_orders'] ],
    [ ['text'=>'💬 گفت‌وگوی مشتری','callback_data'=>'adm_chat'], ['text'=>'📋 گزارش روزانه','callback_data'=>'adm_daily'] ],
    back_btn('root')
  ];
  edit_kb($chat,$mid,'🛠 پنل ادمین',$kb); exit;
}
if($data==='adm_tickets'){ edit_kb($chat,$mid,'🎫 تیکت‌ها – (اسکلت آماده است، در گام بعدی جزئیات اضافه می‌شود)',[ back_btn('root_admin') ]); exit; }
if($data==='adm_orders'){ edit_kb($chat,$mid,'🛒 سفارش‌ها – (اسکلت)',[ back_btn('root_admin') ]); exit; }
if($data==='adm_chat'){ edit_kb($chat,$mid,'💬 گفت‌وگو – (اسکلت)',[ back_btn('root_admin') ]); exit; }
if($data==='adm_daily'){ edit_kb($chat,$mid,'📋 گزارش روزانه – (اسکلت)',[ back_btn('root_admin') ]); exit; }

// ===== Senior Admin (root_sadmin) =====
if($data==='root_sadmin'){
  $kb=[
    [ ['text'=>'👥 مدیریت کاربران','callback_data'=>'sa_users'], ['text'=>'🛡 نقش‌ها و دسترسی‌ها','callback_data'=>'sa_roles'] ],
    [ ['text'=>'🔍 لاگ‌ها','callback_data'=>'sa_logs'], ['text'=>'🗃 پشتیبان‌گیری','callback_data'=>'sa_backup'] ],
    [ ['text'=>'📜 اسناد رسمی','callback_data'=>'sa_offdoc'] ],
    back_btn('root')
  ];
  edit_kb($chat,$mid,'🛡 پنل ادمین ارشد',$kb); exit;
}
if($data==='sa_users'){
  $emps=emp_list(); if(!$emps){ edit_kb($chat,$mid,'فهرست پرسنل خالی است.',[ back_btn('root_sadmin') ]); exit; }
  $txt="👥 پرسنل:\n"; $kb=[]; foreach($emps as $e){ $txt.="— {$e['id']} | {$e['name']} | ".($e['job']??'-')."\n"; $kb[]=[ ['text'=>$e['name'],'callback_data'=>'sa_user:'.$e['id']] ]; }
  $kb[] = back_btn('root_sadmin'); edit_kb($chat,$mid,$txt,$kb); exit;
}
if(strpos($data,'sa_user:')===0){
  $id=explode(':',$data)[1]; $e=get_employee_by_id($id); if(!$e){ edit_kb($chat,$mid,'یافت نشد.',[ back_btn('sa_users') ]); exit; }
  $txt="👤 {$e['name']} ({$e['id']})\nسمت: ".($e['job']??'-')."\nآدرس: ".($e['address']??'-');
  $kb=[ [ ['text'=>'📄 پرونده','callback_data'=>'sa_profile:'.$e['id']], ['text'=>'🗓 مرخصی‌ها','callback_data'=>'sa_user_leaves:'.$e['id']] ], back_btn('sa_users') ];
  edit_kb($chat,$mid,$txt,$kb); exit;
}
if(strpos($data,'sa_profile:')===0){ $id=explode(':',$data)[1]; edit_kb($chat,$mid,"پروندهٔ کارمند $id – (اسکلت)",[ back_btn('sa_user:'.$id) ]); exit; }
if(strpos($data,'sa_user_leaves:')===0){ $id=explode(':',$data)[1]; edit_kb($chat,$mid,"مرخصی‌های کارمند $id – (اسکلت)",[ back_btn('sa_user:'.$id) ]); exit; }
if($data==='sa_roles'){ edit_kb($chat,$mid,'نقش‌ها و دسترسی‌ها – (اسکلت)',[ back_btn('root_sadmin') ]); exit; }
if($data==='sa_logs'){
  $dir=__DIR__.'/storage/logs'; $txt="🔍 آخرین لاگ‌ها:\n"; $kb=[];
  foreach(array_slice(is_dir($dir)?array_reverse(scandir($dir)):[],0,3) as $f){ if(substr($f,0,6)=='trace-'){ $txt.="— $f\n"; $kb[]=[ ['text'=>"👁️ $f",'callback_data'=>'sa_log_show:'.$f] ]; } }
  if(!$kb){ $kb[]=[ ['text'=>'لاگی نیست','callback_data'=>'root_sadmin'] ]; }
  $kb[] = back_btn('root_sadmin'); edit_kb($chat,$mid,$txt,$kb); exit;
}
if(strpos($data,'sa_log_show:')===0){
  $f=explode(':',$data)[1]; $p=__DIR__.'/storage/logs/'.$f; if(!is_file($p)){ edit_kb($chat,$mid,'فایل لاگ یافت نشد.',[ back_btn('sa_logs') ]); exit; }
  $content=@file_get_contents($p); $content = mb_substr($content, -3500);
  edit_kb($chat,$mid,"```log\n".$content."\n```",[ back_btn('sa_logs') ]); exit;
}
if($data==='sa_backup'){ edit_kb($chat,$mid,'پشتیبان‌گیری – (اسکلت)',[ back_btn('root_sadmin') ]); exit; }
if($data==='sa_offdoc'){ $kb=[ [ ['text'=>'➕ ثبت سند رسمی','callback_data'=>'offdoc_new:ceo'], ['text'=>'📚 لیست اسناد','callback_data'=>'offdoc_list:ceo'] ], back_btn('root_sadmin') ]; edit_kb($chat,$mid,'اسناد رسمی (دسترسی مدیرعامل)', $kb); exit; }

// ===== Scenarist (scn) =====
if($data==='scn'){
  $kb=[
    [ ['text'=>'🧠 ۵۰ قلاب ترند','callback_data'=>'scn_hooks'], ['text'=>'📁 سناریوهای من','callback_data'=>'scn_my'] ],
    [ ['text'=>'💬 چت تیم','callback_data'=>'scn_chat'] ],
    back_btn('root')
  ];
  edit_kb($chat,$mid,'✍️ پنل سناریونویس',$kb); exit;
}
if($data==='scn_hooks'){
  // Load 50 hooks from file or default list
  $file=__DIR__.'/storage/hooks.txt';
  if(!is_file($file)){
    $sample=[];
    for($i=1;$i<=50;$i++){ $sample[] = "قلاب شماره $i – یک شروع تیز، طرح سوال، بعد یک وعدهٔ نتیجه در ۵ ثانیه!"; }
    @file_put_contents($file, implode("\n",$sample));
  }
  $hooks = explode("\n", @file_get_contents($file));
  $txt="🧠 ۵۰ قلاب ترندی آماده استفاده:\n\n• ".implode("\n• ", array_slice($hooks,0,50));
  edit_kb($chat,$mid,$txt,[ back_btn('scn') ]); exit;
}
if($data==='scn_my'){ edit_kb($chat,$mid,'📁 سناریوهای شما – (اسکلت)',[ back_btn('scn') ]); exit; }
if($data==='scn_chat'){ edit_kb($chat,$mid,'💬 چت تیم – (اسکلت)',[ back_btn('scn') ]); exit; }

// ===== Blogger / Editor basic menus remain
if($data==='blog'){ $kb=[ [ ['text'=>'✍️ تولید محتوا','callback_data'=>'blog_write'], ['text'=>'📢 انتشار/زمان‌بندی','callback_data'=>'blog_publish'] ], [ ['text'=>'🗓 تقویم محتوا','callback_data'=>'blog_calendar'], ['text'=>'📊 آمار بازدید','callback_data'=>'blog_stats'] ], [ ['text'=>'📋 وظایف من','callback_data'=>'blog_tasks'] ], back_btn('root') ]; edit_kb($chat,$mid,'📝 پنل بلاگر',$kb); exit; }
if($data==='edtr'){ $kb=[ [ ['text'=>'📁 دریافت فایل خام','callback_data'=>'ed_get'], ['text'=>'✂️ تدوین/ویرایش','callback_data'=>'ed_edit'] ], [ ['text'=>'📤 ارسال نسخه نهایی','callback_data'=>'ed_send'], ['text'=>'📊 گزارش زمان صرف‌شده','callback_data'=>'ed_time'] ], back_btn('root') ]; edit_kb($chat,$mid,'🎞 پنل تدوینگر',$kb); exit; }

// ===== Tasks & Payroll placeholders =====
if($data==='mytasks'){ edit_kb($chat,$mid,'🗂 وظیفه‌ای ندارید.',[ back_btn('root') ]); exit; }
if($data==='payroll_me'){ edit_kb($chat,$mid,'💳 فیش – (اسکلت)',[ back_btn('root') ]); exit; }

// ===== OFFICIAL DOCS SHARED =====
function official_owner_back($owner){ return $owner==='ceo'?'ceo':($owner==='acc'?'acc':'dep'); }
if(strpos($data,'offdoc_new:')===0){
  $owner=explode(':',$data)[1]; $back=official_owner_back($owner);
  $st=Storage::readJson("users/$uid/state.json",[]); $st['offdoc']=['owner'=>$owner,'step'=>'type']; Storage::writeJson("users/$uid/state.json",$st);
  $kb=[ [ ['text'=>'📜 ابلاغیه','callback_data'=>"offdoc_type:notice"], ['text'=>'⚠️ اخطاریه','callback_data'=>"offdoc_type:warning"] ], [ ['text'=>'📝 صورتجلسه','callback_data'=>"offdoc_type:minutes"] ], back_btn($back.'_offdoc') ];
  edit_kb($chat,$mid,'نوع سند رسمی را انتخاب کنید:',$kb); exit;
}
if(strpos($data,'offdoc_list:')===0){
  $owner=explode(':',$data)[1]; $back=official_owner_back($owner);
  $dir=__DIR__.'/storage/official'; $rows=[]; foreach(is_dir($dir)?scandir($dir):[] as $f){ if(substr($f,-5)==='.json'){ $x=Storage::readJson('official/'.$f,[]); if(($x['owner']??'')==$owner) $rows[]=$x; } }
  if(!$rows){ edit_kb($chat,$mid,'سندی یافت نشد.',[ back_btn($back.'_offdoc') ]); exit; }
  $txt="اسناد $owner:\n"; foreach(array_slice(array_reverse($rows),0,10) as $x){ $txt.="— {$x['id']} | {$x['type']} | ".jlabel_ts($x['created_at'])."\n"; }
  edit_kb($chat,$mid,$txt,[ back_btn($back.'_offdoc') ]); exit;
}
if(strpos($data,'offdoc_type:')===0){
  $type = explode(':',$data)[1];
  $st=Storage::readJson("users/$uid/state.json",[]); $st['offdoc']['type']=$type; $st['offdoc']['step']='text'; Storage::writeJson("users/$uid/state.json",$st);
  $owner=$st['offdoc']['owner']; $back=official_owner_back($owner);
  edit_kb($chat,$mid,'متن سند را ارسال کنید:',[ back_btn($back.'_offdoc') ]); exit;
}
if($txt!==''){
  $st=Storage::readJson("users/$uid/state.json",[]);
  if(isset($st['offdoc']['step']) && $st['offdoc']['step']==='text'){
    $owner=$st['offdoc']['owner']; $type=$st['offdoc']['type']; $id='DOC'.time();
    $rec=['id'=>$id,'owner'=>$owner,'type'=>$type,'text'=>$txt,'created_by'=>$uid,'created_at'=>time()];
    Storage::writeJson('official/'.$id.'.json',$rec);
    $st['offdoc']=null; Storage::writeJson("users/$uid/state.json",$st);
    send_kb($chat,"سند ثبت شد ✅\n$id | $type",[ back_btn($owner.'_offdoc') ]); exit;
  }
}

// ===== Fallback =====
if(isset($upd['callback_query'])){
  send_kb($chat,"برای ادامه از دکمه‌های شیشه‌ای استفاده کن. اگر منو نیست، /start بزن.",[[['text'=>'بازگشت به منو','callback_data'=>'root']]]);
}
exit;
