<?php
// VisionMedia Bot - Stable Step1
ini_set('display_errors','0'); error_reporting(E_ALL);
date_default_timezone_set('Asia/Tehran');
header('Content-Type: application/json; charset=utf-8');

$config = require __DIR__.'/config.php';
require __DIR__.'/lib/Logger.php';
require __DIR__.'/lib/Storage.php';
require __DIR__.'/lib/JDate.php';
require __DIR__.'/lib/Telegram.php';

$tg = new Telegram($config['bot_token'], 'https://api.telegram.org/bot');

function jlabel_ts($ts){
  list($jy,$jm,$jd) = JDate::toJalali((int)date('Y',$ts),(int)date('n',$ts),(int)date('j',$ts));
  return sprintf('%04d/%02d/%02d - %s:%s', $jy,$jm,$jd, date('H',$ts), date('i',$ts));
}
function jlabel_date($ymd){
  $ts = strtotime($ymd.' 00:00:00');
  list($jy,$jm,$jd) = JDate::toJalali((int)date('Y',$ts),(int)date('n',$ts),(int)date('j',$ts));
  return sprintf('%04d/%02d/%02d', $jy,$jm,$jd);
}
function same_jmonth($ts1,$ts2){
  list($y1,$m1,$d1)=JDate::toJalali((int)date('Y',$ts1),(int)date('n',$ts1),(int)date('j',$ts1));
  list($y2,$m2,$d2)=JDate::toJalali((int)date('Y',$ts2),(int)date('n',$ts2),(int)date('j',$ts2));
  return ($y1==$y2) && ($m1==$m2);
}


function kb($rows){ return array('inline_keyboard'=>$rows); }
function back($data){ return array(array(array('text'=>'⬅️ بازگشت','callback_data'=>$data))); }
function uget($uid){ $p=Storage::readJson("users/$uid/profile.json",null); if(!$p){$p=array('id'=>$uid,'name'=>'','role'=>'','created_at'=>time()); Storage::writeJson("users/$uid/profile.json",$p);} return $p; }
function uset($uid,$p){ Storage::writeJson("users/$uid/profile.json",$p); }
function is_ceo($uid){ global $config; return $uid==$config['ceo_id']; }
function fa_amount($n){ return number_format((int)$n).' تومان'; }

$raw = file_get_contents('php://input'); if($raw===false)$raw='';
Logger::write('updates.log',$raw);
$up = json_decode($raw,true);
if(!$up){ echo json_encode(array('ok'=>true)); exit; }

if(isset($up['message'])){
  $m = $up['message'];
  $chat = isset($m['chat']['id'])?$m['chat']['id']:0;
  $uid = isset($m['from']['id'])?$m['from']['id']:0;
  $name = trim((isset($m['from']['first_name'])?$m['from']['first_name']:'').' '.(isset($m['from']['last_name'])?$m['from']['last_name']:''));
  $p = uget($uid); if(!$p['name']){ $p['name']=$name?:'کاربر'; uset($uid,$p); }

  // Receipt photo
  if(isset($m['photo'])){
    $largest = end($m['photo']); $file_id=$largest['file_id'];
    Storage::appendJsonArray('approvals/receipts.json', array(
      'by'=>$uid,'name'=>$p['name'],'file_id'=>$file_id,'caption'=>isset($m['caption'])?$m['caption']:'','time'=>time(),'status'=>'pending'
    ));
    $tg->sendMessage($chat,"رسید شما دریافت شد ✅\nوضعیت: در انتظار بررسی حسابداری.", kb(array(array(array('text'=>'📥 پیگیری وضعیت','callback_data'=>'cust_list')))));
    echo json_encode(array('ok'=>true)); exit;
  }

  $txt = isset($m['text'])?trim($m['text']):'';
  // Manual client name typing for contract
  $st = Storage::readJson("users/$uid/state.json", array());
  if(isset($st['ctr']['step']) && $st['ctr']['step']==='client_typing' && $txt!==''){
    $st['ctr']['client'] = $txt; $st['ctr']['step']='amount'; Storage::writeJson("users/$uid/state.json",$st);
    $tg->sendMessage($chat, "نام مشتری ثبت شد: «$txt»\nحالا مبلغ را وارد کنیم.", kb(array(array(array('text'=>'💵 وارد کردن مبلغ','callback_data'=>'ctr_amount')))));
    echo json_encode(array('ok'=>true)); exit;
  }

  if($txt==='/start'){
    $rows = array();
    if(is_ceo($uid)) $rows[] = array(array('text'=>'👑 پنل مدیرعامل','callback_data'=>'ceo'));
    $rows[] = array(array('text'=>'💰 حسابداری','callback_data'=>'acc'), array('text'=>'✍️ سناریونویس','callback_data'=>'scn'));
    $rows[] = array(array('text'=>'🗂 وظایف من','callback_data'=>'mytasks'));
    $rows[] = array(array('text'=>'🧍 مشتری','callback_data'=>'cust'), array('text'=>'🧩 مدیر دپارتمان','callback_data'=>'dep'));
    $rows[] = array(array('text'=>'💳 فیش حقوق من','callback_data'=>'payroll_me'), array('text'=>'🗂 وظایف من','callback_data'=>'mytasks'));
    $rows[] = array(array('text'=>'📌 نقش من','callback_data'=>'role'), array('text'=>'ℹ️ درباره','callback_data'=>'about'));
    $text = "سلام {$p['name']} عزیز 🌸\n".JDate::greet()."\n📅 ".JDate::nowFa()."\nبه ربات «ویژن مدیا» خوش آمدی.\nاز گزینه‌های زیر استفاده کن:";
    $tg->sendMessage($chat, $text, kb($rows));
    echo json_encode(array('ok'=>true)); exit;
  }

  $tg->sendMessage($chat,"برای ادامه از دکمه‌های شیشه‌ای استفاده کن. اگر منو نیست، /start بزن.");
  // Dept penalty reason capture
  $stp = Storage::readJson("users/$uid/state.json", array());
  if(isset($stp['pen']['step']) && $stp['pen']['step']==='reason' && $txt!==''){
    $stp['pen']['reason'] = $txt; $stp['pen']['step']='amount';
    Storage::writeJson("users/$uid/state.json", $stp);
    // show manual amounts and general
    $pm = $config['penalties']['manual'];
    $kb = array(array(array('text'=>'جریمه عمومی (۲۵۰,۰۰۰)','callback_data'=>'pen_amt:general')));
    foreach($pm as $a){ $kb[] = array(array('text'=>number_format($a).' تومان','callback_data'=>'pen_amt:'.$a)); }
    $kb[] = array(array('text'=>'⬅️ انصراف','callback_data'=>'dep'));
    $tg->sendMessage($chat, 'مبلغ جریمه را انتخاب کن:', kb($kb));
    echo json_encode(array('ok'=>true)); exit;
  }

  // Department - offish location typing
  $stx = Storage::readJson("users/$uid/state.json", array());
  if(isset($stx['offish']['step']) && $stx['offish']['step']==='loc' && $txt!==''){
    $stx['offish']['loc'] = $txt; unset($stx['offish']['step']); Storage::writeJson("users/$uid/state.json",$stx);
    $tg->sendMessage($chat,"لوکیشن ثبت شد.\nبرای نهایی‌سازی روی «ثبت آفیش» بزن.", kb(array(array(array('text'=>'✅ ثبت آفیش','callback_data'=>'offish_save')))));
    echo json_encode(array('ok'=>true)); exit;
  }

  echo json_encode(array('ok'=>true)); exit;
}

if(isset($up['callback_query'])){
  $cb = $up['callback_query'];
  $uid = $cb['from']['id'];
  $chat = $cb['message']['chat']['id'];
  $mid = $cb['message']['message_id'];
  $data = $cb['data'];
  $p = uget($uid);
  $tg->answerCallback($cb['id']);

  if($data==='about'){
    $c = Storage::readJson('company.json', array());
    $txt = "🏢 {$c['company_name']} ({$c['legal_name']})\nنشانی: {$c['address']}\nسایت: {$c['website']}\n☎️ ".implode(' - ',$c['phones'])."\nخدمات: ".implode('، ',$c['services']);
    $tg->editMessageText($chat,$mid,$txt,kb(back('root'))); exit;
  }
  if($data==='root'){ $tg->editMessageText($chat,$mid,"بازگشت انجام شد. /start را بزنید."); exit; }
  if($data==='role'){
    $roles = array('مدیرعامل','حسابدار','مدیردپارتمان','ادمین ارشد','تصویربردار','بلاگر','تدوینگر','سناریو نویس','ادمین','مشتری');
    $rows = array(); for($i=0;$i<count($roles);$i++){ $rows[] = array(array('text'=>$roles[$i],'callback_data'=>'setrole::'.$roles[$i])); }
    $rows = array_merge($rows, back('root'));
    $tg->editMessageText($chat,$mid,"نقش خود را انتخاب کن:",kb($rows)); exit;
  }
  if(strpos($data,'setrole::')===0){
    $role = substr($data,9); $p['role']=$role; uset($uid,$p);
    $tg->editMessageText($chat,$mid,"نقش شما به «$role» تغییر کرد. /start را بزن.", kb(back('root'))); exit;
  }

  // CEO
  if($data==='ceo'){
    if(!is_ceo($uid)){ $tg->editMessageText($chat,$mid,"⛔ دسترسی محدود است.",kb(back('root'))); exit; }
    $kb=array(
      array(array('text'=>'⚙️ تنظیمات','callback_data'=>'ceo_settings'), array('text'=>'📊 گزارشات','callback_data'=>'ceo_reports')),
      array(array('text'=>'🖋 منتظر امضا','callback_data'=>'ceo_sign'), array('text'=>'💬 اطلاعیه سراسری','callback_data'=>'ceo_bcast')),
      array(array('text'=>'⬅️ بازگشت','callback_data'=>'root'))
    );
    $tg->editMessageText($chat,$mid,"👑 پنل مدیرعامل",kb($kb)); exit;
  }
  if($data==='ceo_reports'){ $tg->editMessageText($chat,$mid,"📊 گزارشات (در حال توسعه)",kb(back('ceo'))); exit; }
  if($data==='ceo_settings'){
    $s = Storage::readJson('settings.json', array('sms_enabled'=>false,'penalty_general'=>250000,'late_fee'=>150000));
    $txt = "⚙️ تنظیمات عمومی\nپیامک: ".($s['sms_enabled']?'فعال':'غیرفعال')."\nجریمه عمومی: ".fa_amount($s['penalty_general'])."\nجریمه تاخیر پرداخت (روزانه): ".fa_amount($s['late_fee']);
    $kb=array(
      array(array('text'=>'🔁 پیامک روشن/خاموش','callback_data'=>'ceo_sms_toggle')),
      array(array('text'=>'✏️ تغییر جریمه عمومی','callback_data'=>'ceo_edit_pen')),
      array(array('text'=>'✏️ تغییر جریمه تاخیر','callback_data'=>'ceo_edit_late')),
      array(array('text'=>'⬅️ بازگشت','callback_data'=>'ceo'))
    );
    $tg->editMessageText($chat,$mid,$txt,kb($kb)); exit;
  }
  if($data==='ceo_sms_toggle'){
    $s = Storage::readJson('settings.json', array('sms_enabled'=>false,'penalty_general'=>250000,'late_fee'=>150000));
    $s['sms_enabled'] = !$s['sms_enabled']; Storage::writeJson('settings.json',$s);
    $tg->editMessageText($chat,$mid,"وضعیت پیامک تغییر کرد: ".($s['sms_enabled']?'فعال':'غیرفعال'), kb(back('ceo_settings'))); exit;
  }
  if($data==='ceo_edit_pen' || $data==='ceo_edit_late'){
    $st = Storage::readJson("users/$uid/state.json", array());
    $st['edit_money'] = ($data==='ceo_edit_pen') ? 'penalty_general' : 'late_fee';
    $st['num'] = '0'; Storage::writeJson("users/$uid/state.json", $st);
    $label = ($st['edit_money']=='penalty_general') ? 'جریمه عمومی' : 'جریمه تاخیر پرداخت روزانه';
    $kb=array(
      array(array('text'=>'1','callback_data'=>'mnum:1'),array('text'=>'2','callback_data'=>'mnum:2'),array('text'=>'3','callback_data'=>'mnum:3')),
      array(array('text'=>'4','callback_data'=>'mnum:4'),array('text'=>'5','callback_data'=>'mnum:5'),array('text'=>'6','callback_data'=>'mnum:6')),
      array(array('text'=>'7','callback_data'=>'mnum:7'),array('text'=>'8','callback_data'=>'mnum:8'),array('text'=>'9','callback_data'=>'mnum:9')),
      array(array('text'=>'⌫','callback_data'=>'mnum:del'),array('text'=>'0','callback_data'=>'mnum:0'),array('text'=>'✔️ ثبت','callback_data'=>'mnum:ok')),
      array(array('text'=>'⬅️ انصراف','callback_data'=>'ceo_settings'))
    );
    $tg->editMessageText($chat,$mid,"مقدار «$label» را به تومان وارد کن:\nفعلاً: 0", kb($kb)); exit;
  }
  if(strpos($data,'mnum:')===0){
    $cmd = explode(':',$data)[1];
    $st = Storage::readJson("users/$uid/state.json", array('edit_money'=>null,'num'=>'0'));
    $n = $st['num'] ?? '0';
    if($cmd==='del'){ $n = substr($n,0,-1); if($n==='') $n='0'; }
    elseif($cmd==='ok'){
      $val = intval($n);
      $s = Storage::readJson('settings.json', array('sms_enabled'=>false,'penalty_general'=>250000,'late_fee'=>150000));
      if($st['edit_money']=='penalty_general') $s['penalty_general']=$val; else $s['late_fee']=$val;
      Storage::writeJson('settings.json',$s);
      $tg->editMessageText($chat,$mid,"ثبت شد ✅", kb(back('ceo_settings'))); exit;
    } else { if($n=='0') $n=''; $n.=$cmd; }
    $st['num']=$n; Storage::writeJson("users/$uid/state.json",$st);
    $tg->editMessageText($chat,$mid,"مبلغ فعلی: ".fa_amount($n), kb(array(
      array(array('text'=>'1','callback_data'=>'mnum:1'),array('text'=>'2','callback_data'=>'mnum:2'),array('text'=>'3','callback_data'=>'mnum:3')),
      array(array('text'=>'4','callback_data'=>'mnum:4'),array('text'=>'5','callback_data'=>'mnum:5'),array('text'=>'6','callback_data'=>'mnum:6')),
      array(array('text'=>'7','callback_data'=>'mnum:7'),array('text'=>'8','callback_data'=>'mnum:8'),array('text'=>'9','callback_data'=>'mnum:9')),
      array(array('text'=>'⌫','callback_data'=>'mnum:del'),array('text'=>'0','callback_data'=>'mnum:0'),array('text'=>'✔️ ثبت','callback_data'=>'mnum:ok')),
      array(array('text'=>'⬅️ انصراف','callback_data'=>'ceo_settings'))
    ))); exit;
  }
  if($data==='ceo_bcast'){
    $st = Storage::readJson("users/$uid/state.json", array()); $st['bcast']='await'; Storage::writeJson("users/$uid/state.json",$st);
    $tg->editMessageText($chat,$mid,"متن اطلاعیهٔ سراسری را ارسال کن.", kb(back('ceo'))); exit;
  }

  if($data==='ceo_sign'){
    $items = Storage::readJson('approvals/receipts.json', array());
    if(!$items){ $tg->editMessageText($chat,$mid,"پرونده‌ای نیست.",kb(back('ceo'))); exit; }
    $rev = array_reverse($items); $txt="پرونده‌های منتظر:\n";
    for($i=0;$i<min(10,count($rev));$i++){ $r=$rev[$i]; $txt.="— {$r['name']} | {$r['status']} | ".date('Y-m-d H:i',$r['time'])."\n"; }
    $tg->editMessageText($chat,$mid,$txt,kb(back('ceo'))); exit;
  }
  if($data==='ceo_bcast'){ $tg->editMessageText($chat,$mid,"به‌زودی: ارسال اطلاعیه.",kb(back('ceo'))); exit; }

  // Accountant
  if($data==='acc'){
    $kb=array(
      array(array('text'=>'🧾 فاکتور/قرارداد','callback_data'=>'acc_inv'), array('text'=>'📥 رسیدهای پرداخت','callback_data'=>'acc_receipts')),
      array(array('text'=>'📄 قراردادها','callback_data'=>'ctr'), array('text'=>'🧾 فاکتورها','callback_data'=>'acc_invoices')),
      array(array('text'=>'⚠️ جریمه‌ها','callback_data'=>'acc_pens')),
      array(array('text'=>'⬅️ بازگشت','callback_data'=>'root'))
    );
    $tg->editMessageText($chat,$mid,"💰 پنل حسابداری",kb($kb)); exit;
  }
  
  if($data==='acc_receipts'){
    $items = Storage::readJson('approvals/receipts.json', array());
    if(!$items){ $tg->editMessageText($chat,$mid,"رسیدی در صف نیست.",kb(back('acc'))); exit; }
    $rev = array_reverse($items); $txt="رسیدها:
"; for($i=0;$i<min(5,count($rev));$i++){ $r=$rev[$i]; $txt.="— {$r['name']} | {$r['status']} | ".date('Y-m-d H:i',$r['time'])."
"; }
    $kb=array(
      array(array('text'=>'👁️ پیش‌نمایش اولی','callback_data'=>'acc_rcpt_show')),
      array(array('text'=>'✅ تایید همه','callback_data'=>'acc_ok'), array('text'=>'❌ رد همه','callback_data'=>'acc_rej')),
      array(array('text'=>'⬅️ بازگشت','callback_data'=>'acc'))
    );
    $tg->editMessageText($chat,$mid,$txt,kb($kb)); exit;
  }
  if($data==='acc_rcpt_show'){
    $items = Storage::readJson('approvals/receipts.json', array());
    if(!$items){ $tg->answerCallback($cb['id'],'چیزی نیست'); exit; }
    $rev = array_reverse($items); $r = $rev[0];
    if(isset($r['file_id'])){ $tg->sendPhoto($chat, $r['file_id'], "پیش‌نمایش رسید ".$r['name']); }
    else { $tg->sendMessage($chat,"تصویری برای رسید ذخیره نشده."); }
    $tg->answerCallback($cb['id'],'ارسال شد'); exit;
  }

    $rev = array_reverse($items); $txt="رسیدها:\n"; for($i=0;$i<min(5,count($rev));$i++){ $r=$rev[$i]; $txt.="— {$r['name']} | {$r['status']} | ".date('Y-m-d H:i',$r['time'])."\n"; }
    $kb=array(array(array('text'=>'✅ تایید همه','callback_data'=>'acc_ok'), array('text'=>'❌ رد همه','callback_data'=>'acc_rej')), array(array('text'=>'⬅️ بازگشت','callback_data'=>'acc')));
    $tg->editMessageText($chat,$mid,$txt,kb($kb)); exit;
  }
  if($data==='acc_ok' || $data==='acc_rej'){
    $items = Storage::readJson('approvals/receipts.json', array());
    for($i=0;$i<count($items);$i++){ if($items[$i]['status']==='pending') $items[$i]['status']= ($data==='acc_ok'?'approved':'rejected'); }
    Storage::writeJson('approvals/receipts.json',$items);
    $tg->editMessageText($chat,$mid,"به‌روزرسانی شد.",kb(back('acc'))); exit;
  }
  if($data==='acc_inv'){
    $kb=array(
      array(array('text'=>'➕ ثبت فاکتور','callback_data'=>'inv_new'), array('text'=>'📃 لیست فاکتورها','callback_data'=>'inv_list')),
      array(array('text'=>'⬅️ بازگشت','callback_data'=>'acc'))
    );
    $tg->editMessageText($chat,$mid,"🧾 مدیریت فاکتور",kb($kb)); exit;
  }
  if($data==='inv_new'){
    Storage::writeJson("users/$uid/state.json", array('inv'=>array('amt'=>'0')));
    $txt="💵 مبلغ فاکتور را وارد کن:\nمبلغ: 0";
    $kb=array(
      array(array('text'=>'1','callback_data'=>'num:1'),array('text'=>'2','callback_data'=>'num:2'),array('text'=>'3','callback_data'=>'num:3')),
      array(array('text'=>'4','callback_data'=>'num:4'),array('text'=>'5','callback_data'=>'num:5'),array('text'=>'6','callback_data'=>'num:6')),
      array(array('text'=>'7','callback_data'=>'num:7'),array('text'=>'8','callback_data'=>'num:8'),array('text'=>'9','callback_data'=>'num:9')),
      array(array('text'=>'⌫','callback_data'=>'num:del'),array('text'=>'0','callback_data'=>'num:0'),array('text'=>'✔️ تایید','callback_data'=>'num:ok')),
      array(array('text'=>'⬅️ انصراف','callback_data'=>'acc_inv'))
    );
    $tg->editMessageText($chat,$mid,$txt,kb($kb)); exit;
  }
  if(strpos($data,'num:')===0){
    $cmd = substr($data,4);
    $st = Storage::readJson("users/$uid/state.json", array());
    $amt = isset($st['inv']['amt'])?$st['inv']['amt']:'0';
    if($cmd==='del'){ $amt = substr($amt,0,-1); if($amt==='') $amt='0'; }
    elseif($cmd==='ok'){
      $id='INV'.time(); Storage::writeJson("invoices/$id.json", array('id'=>$id,'amount'=>(int)$amt,'status'=>'pending','created_at'=>time()));
      $tg->editMessageText($chat,$mid,"ثبت شد ✅\nشناسه $id | مبلغ: ".fa_amount($amt), kb(back('acc_inv'))); exit;
    } else { if($amt==='0') $amt=''; $amt.=$cmd; }
    $st['inv']['amt']=$amt; Storage::writeJson("users/$uid/state.json",$st);
    $tg->editMessageText($chat,$mid,"💵 مبلغ: ".fa_amount($amt), kb(array(
      array(array('text'=>'1','callback_data'=>'num:1'),array('text'=>'2','callback_data'=>'num:2'),array('text'=>'3','callback_data'=>'num:3')),
      array(array('text'=>'4','callback_data'=>'num:4'),array('text'=>'5','callback_data'=>'num:5'),array('text'=>'6','callback_data'=>'num:6')),
      array(array('text'=>'7','callback_data'=>'num:7'),array('text'=>'8','callback_data'=>'num:8'),array('text'=>'9','callback_data'=>'num:9')),
      array(array('text'=>'⌫','callback_data'=>'num:del'),array('text'=>'0','callback_data'=>'num:0'),array('text'=>'✔️ تایید','callback_data'=>'num:ok')),
      array(array('text'=>'⬅️ انصراف','callback_data'=>'acc_inv'))
    ))); exit;
  }

  // ===== Contracts & Payments (No PDF) =====
  if($data==='ctr'){ // accountant hub
    $kb=array(
      array(array('text'=>'📝 قرارداد جدید (الگو)','callback_data'=>'ctr_newtpl'), array('text'=>'📃 لیست قراردادها','callback_data'=>'ctr_list')),
      array(array('text'=>'⬅️ بازگشت','callback_data'=>'acc'))
    );
    $tg->editMessageText($chat,$mid,"📄 مدیریت قرارداد",kb($kb)); exit;
  }
  if($data==='ctr_newtpl'){
    // For simplicity ask client name and amount via keypad; dates default: امروز تا 30 روز بعد
    Storage::writeJson("users/$uid/state.json", array('ctr'=>array('client'=>'','amount'=>'0','step'=>'client')));
    $kb=array(
      array(array('text'=>'👤 انتخاب از مشتریان ذخیره‌شده (به‌زودی)','callback_data'=>'ctr_pick_client')),
      array(array('text'=>'✍️ ثبت نام مشتری به صورت دستی','callback_data'=>'ctr_client_manual'))
    );
    $tg->editMessageText($chat,$mid,"نام و نام‌خانوادگی مشتری را می‌خواهی چطور وارد کنیم؟",kb($kb)); exit;
  }
  if($data==='ctr_client_manual'){
    $st = Storage::readJson("users/$uid/state.json", array()); $st['ctr']['step']='client_typing'; Storage::writeJson("users/$uid/state.json",$st);
    $tg->editMessageText($chat,$mid,"نام و نام‌خانوادگی مشتری را همینجا به‌صورت متن ارسال کن.",kb(back('acc_inv'))); exit;
  }

  if($data==='ctr_amount'){
    $st = Storage::readJson("users/$uid/state.json", array()); $st['ctr']['step']='amount';
    Storage::writeJson("users/$uid/state.json",$st);
    $txt="💵 مبلغ قرارداد را وارد کن:\nمبلغ فعلی: ".fa_amount(isset($st['ctr']['amount'])?$st['ctr']['amount']:'0');
    $kb=array(
      array(array('text'=>'1','callback_data'=>'cnum:1'),array('text'=>'2','callback_data'=>'cnum:2'),array('text'=>'3','callback_data'=>'cnum:3')),
      array(array('text'=>'4','callback_data'=>'cnum:4'),array('text'=>'5','callback_data'=>'cnum:5'),array('text'=>'6','callback_data'=>'cnum:6')),
      array(array('text'=>'7','callback_data'=>'cnum:7'),array('text'=>'8','callback_data'=>'cnum:8'),array('text'=>'9','callback_data'=>'cnum:9')),
      array(array('text'=>'⌫','callback_data'=>'cnum:del'),array('text'=>'0','callback_data'=>'cnum:0'),array('text'=>'✔️ تایید','callback_data'=>'cnum:ok'))
    );
    $tg->editMessageText($chat,$mid,$txt,kb($kb)); exit;
  }
  if(strpos($data,'cnum:')===0){
    $cmd = substr($data,5);
    $st = Storage::readJson("users/$uid/state.json", array()); $amt = isset($st['ctr']['amount'])?$st['ctr']['amount']:'0';
    if($cmd==='del'){ $amt = substr($amt,0,-1); if($amt==='') $amt='0'; }
    elseif($cmd==='ok'){
      $st['ctr']['amount']=$amt; $st['ctr']['step']='confirm'; Storage::writeJson("users/$uid/state.json",$st);
      $start = date('Y-m-d'); $end = date('Y-m-d', time()+30*24*3600);
      $txt="پیش‌نویس قرارداد آماده است:\n👤 مشتری: {$st['ctr']['client']}\n📅 از $start تا $end\n💵 مبلغ: ".fa_amount($amt)."\nثبت شود؟";
      $kb=array(array(array('text'=>'✅ ثبت قرارداد','callback_data'=>'ctr_save')), array(array('text'=>'✏️ تغییر مبلغ','callback_data'=>'ctr_amount')), array(array('text'=>'⬅️ انصراف','callback_data'=>'ctr')));
      $tg->editMessageText($chat,$mid,$txt,kb($kb)); exit;
    } else { if($amt==='0') $amt=''; $amt.=$cmd; }
    $st['ctr']['amount']=$amt; Storage::writeJson("users/$uid/state.json",$st);
    $tg->editMessageText($chat,$mid,"💵 مبلغ فعلی: ".fa_amount($amt),kb(array(
      array(array('text'=>'1','callback_data'=>'cnum:1'),array('text'=>'2','callback_data'=>'cnum:2'),array('text'=>'3','callback_data'=>'cnum:3')),
      array(array('text'=>'4','callback_data'=>'cnum:4'),array('text'=>'5','callback_data'=>'cnum:5'),array('text'=>'6','callback_data'=>'cnum:6')),
      array(array('text'=>'7','callback_data'=>'cnum:7'),array('text'=>'8','callback_data'=>'cnum:8'),array('text'=>'9','callback_data'=>'cnum:9')),
      array(array('text'=>'⌫','callback_data'=>'cnum:del'),array('text'=>'0','callback_data'=>'cnum:0'),array('text'=>'✔️ تایید','callback_data'=>'cnum:ok'))
    ))); exit;
  }
  if($data==='ctr_save'){
    $st = Storage::readJson("users/$uid/state.json", array()); $ctr = $st['ctr'];
    $id = 'CTR'.time();
    $start = date('Y-m-d'); $end = date('Y-m-d', time()+30*24*3600);
    $row = array('id'=>$id,'client'=>$ctr['client'],'start'=>$start,'end'=>$end,'amount'=>(int)$ctr['amount'],'status'=>'awaiting_client');
    Storage::writeJson("contracts/$id.json", $row);
    // Notify CEO for info
    $tg->sendMessage($config['ceo_id'], "📄 قرارداد جدید $id برای «{$ctr['client']}» ایجاد شد. وضعیت: در انتظار تایید مشتری.");
    $tg->editMessageText($chat,$mid,"قرارداد ثبت شد ✅\nشناسه: $id\nوضعیت: در انتظار تایید مشتری.",kb(back('ctr'))); exit;
  }
  if($data==='ctr_list'){
    $dir=__DIR__.'/storage/contracts'; $files=array(); foreach(scandir($dir) as $f){ if(substr($f,-5)==='.json') $files[]=$f; }
    if(!count($files)){ $tg->editMessageText($chat,$mid,'قراردادی ثبت نشده.',kb(back('ctr'))); exit; }
    $txt="قراردادها:\n"; foreach($files as $f){ $c=Storage::readJson('contracts/'.$f, array()); $txt.="— {$c['id']} | {$c['client']} | ".fa_amount($c['amount'])." | {$c['status']}\n"; }
    $tg->editMessageText($chat,$mid,$txt,kb(back('ctr'))); exit;
  }

  // Customer side approval (for demo, customer sees pending contracts and can Accept/Reject)
  if($data==='cust_contracts'){
    $dir=__DIR__.'/storage/contracts'; $files=array(); foreach(scandir($dir) as $f){ if(substr($f,-5)==='.json') $files[]=$f; }
    $mine=array();
    foreach($files as $f){ $c=Storage::readJson('contracts/'.$f, array()); if($c['status']==='awaiting_client') $mine[]=$c; }
    if(!count($mine)){ $tg->editMessageText($chat,$mid,'قراردادی برای تایید شما نیست.',kb(back('cust'))); exit; }
    $c=$mine[0];
    $txt="📝 قرارداد {$c['id']}\n👤 مشتری: {$c['client']}\n📅 {$c['start']} تا {$c['end']}\n💵 مبلغ: ".fa_amount($c['amount'])."\nآیا تایید می‌کنید؟";
    $kb=array(array(array('text'=>'✅ تایید','callback_data'=>'cust_ctr_ok:'.$c['id']), array('text'=>'❌ رد','callback_data'=>'cust_ctr_rej:'.$c['id'])), array(array('text'=>'⬅️ بازگشت','callback_data'=>'cust')));
    $tg->editMessageText($chat,$mid,$txt,kb($kb)); exit;
  }
  if(strpos($data,'cust_ctr_ok:')===0 || strpos($data,'cust_ctr_rej:')===0){
    $parts = explode(':',$data); $cid=$parts[1];
    $c = Storage::readJson("contracts/$cid.json", array()); if(!$c){ $tg->editMessageText($chat,$mid,'یافت نشد.',kb(back('cust'))); exit; }
    if(strpos($data,'cust_ctr_ok:')===0){
      $c['status']='approved'; Storage::writeJson("contracts/$cid.json",$c);
      // Auto-create invoice
      $inv_id='INV'.time();
      $inv = array('id'=>$inv_id,'contract'=>$cid,'amount'=>$c['amount'],'status'=>'unpaid','created_at'=>time(),'due_at'=>time()+3*24*3600,'remaining'=>$c['amount']);
      Storage::writeJson("invoices/$inv_id.json",$inv);
      // Send bank info
      $bank = $config['company_bank'];
      $txt="✅ قرارداد تایید شد و فاکتور صادر گردید.\nشماره فاکتور: $inv_id\n💵 مبلغ قابل پرداخت: ".fa_amount($inv['remaining'])."\n\nاطلاعات پرداخت:\n💳 کارت: {$bank['card']}\n🏦 حساب: {$bank['account']}\n🟣 شبا: {$bank['iban']}\nبه نام: {$bank['name']}\n\nلطفاً پس از پرداخت، «📤 ارسال رسید» را بزنید.";
      $tg->editMessageText($chat,$mid,$txt,kb(array(array(array('text'=>'📤 ارسال رسید','callback_data'=>'cust_send')))));
      // Notify accounting
      $tg->sendMessage($config['ceo_id'], "فاکتور $inv_id بابت قرارداد $cid صادر شد.");
      exit;
    } else {
      $c['status']='rejected'; Storage::writeJson("contracts/$cid.json",$c);
      $tg->editMessageText($chat,$mid,'قرارداد رد شد.',kb(back('cust'))); exit;
    }
  }

  // Accounting: mark prepayment / set remaining / set due date / assign department
  if($data==='acc_invoices'){
    $dir=__DIR__.'/storage/invoices'; $files=array(); foreach(scandir($dir) as $f){ if(substr($f,-5)==='.json') $files[]=$f; }
    if(!count($files)){ $tg->editMessageText($chat,$mid,'فاکتوری نیست.',kb(back('acc'))); exit; }
    $rows=array();
    foreach($files as $f){ $x=Storage::readJson('invoices/'.$f, array()); $rows[]=$x['id'].' | '.fa_amount($x['remaining']).' | '.$x['status']; }
    $tg->editMessageText($chat,$mid,"فاکتورها:\n".implode("\n",$rows),kb(array(array(array('text'=>'ویرایش/تسویه (اولین فاکتور)','callback_data'=>'acc_inv_first')), array(array('text'=>'⬅️ بازگشت','callback_data'=>'acc'))))); exit;
  }
  if($data==='acc_inv_first'){
    $dir=__DIR__.'/storage/invoices'; $files=array(); foreach(scandir($dir) as $f){ if(substr($f,-5)==='.json') $files[]=$f; }
    if(!count($files)){ $tg->editMessageText($chat,$mid,'چیزی نیست.',kb(back('acc_invoices'))); exit; }
    $id = str_replace('.json','',$files[0]); $inv=Storage::readJson('invoices/'.$id.'.json', array());
    $txt="🧾 $id\n✔️ وضعیت: {$inv['status']}\n💵 مانده: ".fa_amount($inv['remaining'])."\nسررسید: ".date('Y-m-d',$inv['due_at']);
    $kb=array(
      array(array('text'=>'📥 ثبت پیش‌پرداخت','callback_data'=>'acc_pre:'.$id), array('text'=>'✅ تسویه کامل','callback_data'=>'acc_paid:'.$id)),
      array(array('text'=>'📅 تغییر سررسید (+3 روز)','callback_data'=>'acc_due3:'.$id)),
      array(array('text'=>'👤 تخصیص به مدیر دپارتمان','callback_data'=>'acc_assign:'.$id)),
      array(array('text'=>'⬅️ بازگشت','callback_data'=>'acc'))
    );
    $tg->editMessageText($chat,$mid,$txt,kb($kb)); exit;
  }
  if(strpos($data,'acc_pre:')===0 || strpos($data,'acc_paid:')===0 || strpos($data,'acc_due3:')===0){
    list($cmd,$id)=explode(':',$data); $inv=Storage::readJson("invoices/$id.json", array()); if(!$inv){ $tg->editMessageText($chat,$mid,'یافت نشد.',kb(back('acc'))); exit; }
    if($cmd==='acc_pre'){ $inv['remaining'] = max(0, $inv['remaining'] - intval($inv['amount']*0.3)); $inv['status']='partial'; }
    if($cmd==='acc_paid'){ $inv['remaining']=0; $inv['status']='paid'; }
    if($cmd==='acc_due3'){ $inv['due_at'] += 3*24*3600; }
    Storage::writeJson("invoices/$id.json",$inv);
    $tg->editMessageText($chat,$mid,"به‌روزرسانی شد.\nوضعیت: {$inv['status']} | مانده: ".fa_amount($inv['remaining']),kb(back('acc_inv_first'))); exit;
  }
  if(strpos($data,'acc_assign:')===0){
    $id = explode(':',$data)[1];
    $emps = json_decode(file_get_contents(__DIR__.'/storage/employees.json'), true);
    $mgrs = array(); foreach($emps as $e){ if($e['role']=='مدیردپارتمان') $mgrs[]=$e; }
    if(!count($mgrs)){ $tg->editMessageText($chat,$mid,'مدیر دپارتمان ثبت نشده.',kb(back('acc_inv_first'))); exit; }
    $kb=array();
    foreach($mgrs as $m){ $kb[] = array(array('text'=>$m['name'],'callback_data'=>'acc_assign_to:'.$id.':'.$m['id'])); }
    $kb = array_merge($kb, back('acc_inv_first'));
    $tg->editMessageText($chat,$mid,'یک مدیر دپارتمان انتخاب کن:',kb($kb)); exit;
  }
  if(strpos($data,'acc_assign_to:')===0){
    $parts = explode(':',$data); $id=$parts[1]; $mgr_id=intval($parts[2]);
    $inv = Storage::readJson("invoices/$id.json", array()); $inv['assigned_dep']=$mgr_id; Storage::writeJson("invoices/$id.json",$inv);
    $tg->editMessageText($chat,$mid,"فاکتور $id به مدیر دپارتمان تخصیص یافت.",kb(back('acc_inv_first')));
    // notify manager
    $tg->sendMessage($mgr_id, "🧩 پروژهٔ جدید به شما تخصیص یافته است.\nفاکتور: $id");
    exit;
  }

  if($data==='inv_list'){
    $dir = __DIR__.'/storage/invoices'; $files = array();
    foreach(scandir($dir) as $f){ if(substr($f,-5)==='.json') $files[]=$f; }
    if(!count($files)){ $tg->editMessageText($chat,$mid,"فاکتوری نداریم.",kb(back('acc_inv'))); exit; }
    $txt="لیست فاکتورها:\n"; for($i=0;$i<count($files);$i++){ $row=Storage::readJson('invoices/'.$files[$i], array()); $txt.="— {$row['id']} | ".fa_amount($row['amount'])." | {$row['status']}\n"; }
    $tg->editMessageText($chat,$mid,$txt,kb(back('acc_inv'))); exit;
  }

  // Scenario writer - hooks (fallback static)
  if($data==='scn'){
    $kb=array(array(array('text'=>'🎣 ۵۰ قلاب ترندی','callback_data'=>'scn_hooks')), array(array('text'=>'⬅️ بازگشت','callback_data'=>'root')));
    $tg->editMessageText($chat,$mid,"✍️ پنل سناریونویس",kb($kb)); exit;
  }
  if($data==='scn_hooks'){
    $hooks=array(); for($i=1;$i<=50;$i++) $hooks[]="قلاب شماره $i - شروع قدرتمند و سریع!";
    $chunks=array_chunk($hooks,10); $page=0;
    Storage::writeJson("users/$uid/state.json", array('hooks'=>$hooks,'page'=>0));
    $txt="🎣 قلاب‌ها (1 از ".count($chunks)."):\n- ".implode("\n- ",$chunks[0]);
    $kb=array(array(array('text'=>'➡️ بعدی','callback_data'=>'scn_next')), array(array('text'=>'⬅️ بازگشت','callback_data'=>'scn')));
    $tg->editMessageText($chat,$mid,$txt,kb($kb)); exit;
  }
  if($data==='scn_next'){
    $st=Storage::readJson("users/$uid/state.json", array()); $hooks=$st['hooks']; $page=isset($st['page'])?($st['page']+1):1;
    $chunks=array_chunk($hooks,10); if($page>=count($chunks)) $page=0; $st['page']=$page; Storage::writeJson("users/$uid/state.json",$st);
    $txt="🎣 قلاب‌ها (".($page+1)." از ".count($chunks)."):\n- ".implode("\n- ",$chunks[$page]);
    $kb=array(array(array('text'=>'➡️ بعدی','callback_data'=>'scn_next')), array(array('text'=>'⬅️ بازگشت','callback_data'=>'scn')));
    $tg->editMessageText($chat,$mid,$txt,kb($kb)); exit;
  }

  // Customer
  if($data==='cust'){
    $kb=array(array(array('text'=>'📤 ارسال رسید','callback_data'=>'cust_send'), array('text'=>'📥 پیگیری رسید','callback_data'=>'cust_list')), array(array('text'=>'⬅️ بازگشت','callback_data'=>'root')));
    $tg->editMessageText($chat,$mid,"🧍 پنل مشتری",kb($kb)); exit;
  }
  if($data==='cust_send'){ $tg->editMessageText($chat,$mid,"لطفاً عکس رسید را ارسال کنید.",kb(back('cust'))); exit; }
  if($data==='cust_list'){
    $items = Storage::readJson('approvals/receipts.json', array());
    $my=array(); for($i=0;$i<count($items);$i++) if($items[$i]['by']==$uid) $my[]=$items[$i];
    if(!count($my)){ $tg->editMessageText($chat,$mid,"رسیدی ثبت نشده.",kb(back('cust'))); exit; }
    $my=array_reverse($my); $txt="آخرین رسیدهای شما:\n"; for($i=0;$i<min(5,count($my));$i++){ $r=$my[$i]; $txt.="— ".date('Y-m-d H:i',$r['time'])." | {$r['status']}\n"; }
    $tg->editMessageText($chat,$mid,$txt,kb(back('cust'))); exit;
  }

  // Department placeholder (Step2 we add teams/offish/calendar fully)
  if($data==='dep'){
    $kb=array(
      array(array('text'=>'👥 ساخت تیم مشتری','callback_data'=>'dep_team_new'), array('text'=>'📃 تیم‌های من','callback_data'=>'dep_team_list')),
      array(array('text'=>'🎬 ثبت آفیش','callback_data'=>'dep_offish_new'), array('text'=>'🎞 آفیش‌های آینده','callback_data'=>'dep_offish_list')),
      array(array('text'=>'🗓 تقویم محتوا (به‌زودی)','callback_data'=>'dep_calendar')),
      array(array('text'=>'⚠️ گزارش تخلف/جریمه','callback_data'=>'dep_pen')),
      array(array('text'=>'⬅️ بازگشت','callback_data'=>'root'))
    );
    $tg->editMessageText($chat,$mid,"🧩 پنل مدیر دپارتمان",kb($kb)); exit;
  }

  
  // ===== Department: Teams =====
  if($data==='dep_team_new'){
    // pick from approved contracts
    $dir=__DIR__.'/storage/contracts'; $files=array(); foreach(scandir($dir) as $f){ if(substr($f,-5)==='.json') $files[]=$f; }
    $options=array(); foreach($files as $f){ $c=Storage::readJson('contracts/'.$f, array()); if(isset($c['status']) && ($c['status']=='approved' || $c['status']=='paid')) $options[]=$c; }
    if(!count($options)){
      $tg->editMessageText($chat,$mid,"قرارداد تاییدشده‌ای وجود ندارد. ابتدا قرارداد مشتری تایید شود.",kb(back('dep'))); exit;
    }
    $kb=array();
    foreach($options as $c){ $kb[] = array(array('text'=>$c['id'].' - '.$c['client'].' - '.fa_amount($c['amount']), 'callback_data'=>'dep_team_for:'.$c['id'])); }
    $kb = array_merge($kb, back('dep'));
    $tg->editMessageText($chat,$mid,"برای کدام قرارداد تیم بسازیم؟",kb($kb)); exit;
  }
  if(strpos($data,'dep_team_for:')===0){
    $cid = explode(':',$data)[1];
    // select members
    Storage::writeJson("users/$uid/state.json", array('team'=>array('cid'=>$cid,'sel'=>array())));
    $roles = array('scn'=>'سناریو نویس','blog'=>'بلاگر','cam'=>'تصویربردار','edit'=>'تدوینگر','adm'=>'ادمین');
    $kb=array();
    foreach($roles as $key=>$label){
      $kb[] = array(array('text'=>"➕ $label",'callback_data'=>'team_pick:'.$key));
    }
    $kb[] = array(array('text'=>'✅ ثبت تیم','callback_data'=>'team_save'));
    $kb[] = array(array('text'=>'⬅️ بازگشت','callback_data'=>'dep'));
    $tg->editMessageText($chat,$mid,"قرارداد: $cid\nاعضا را انتخاب کن:",kb($kb)); exit;
  }
  if(strpos($data,'team_pick:')===0){
    $key = explode(':',$data)[1];
    $emps = json_decode(file_get_contents(__DIR__.'/storage/employees.json'), true);
    $list = array();
    foreach($emps as $e){
      if(($key=='scn' && $e['role']=='سناریو نویس') ||
         ($key=='blog' && $e['role']=='بلاگر') ||
         ($key=='cam' && $e['role']=='تصویربردار') ||
         ($key=='edit' && $e['role']=='تدوینگر') ||
         ($key=='adm' && $e['role']=='ادمین'))
        $list[]=$e;
    }
    if(!count($list)){
      $tg->editMessageText($chat,$mid,"کارمندی با این نقش ثبت نشده.",kb(back('dep'))); exit;
    }
    $kb=array();
    foreach($list as $e){ $kb[] = array(array('text'=>$e['name'], 'callback_data'=>'team_set:'.$key.':'.$e['id'])); }
    $kb = array_merge($kb, back('dep'));
    $tg->editMessageText($chat,$mid,"انتخاب «$key»:",kb($kb)); exit;
  }
  if(strpos($data,'team_set:')===0){
    $parts = explode(':',$data); $key=$parts[1]; $eid=intval($parts[2]);
    $st = Storage::readJson("users/$uid/state.json", array()); if(!isset($st['team'])){ $tg->editMessageText($chat,$mid,'گام قبلی نامعتبر.',kb(back('dep'))); exit; }
    if(!isset($st['team']['sel'])) $st['team']['sel']=array();
    $st['team']['sel'][$key] = $eid;
    Storage::writeJson("users/$uid/state.json",$st);
    $tg->editMessageText($chat,$mid,"ثبت شد. می‌تونی نقش‌های دیگر را هم اضافه کنی یا «✅ ثبت تیم» را بزن.",kb(array(array(array('text'=>'✅ ثبت تیم','callback_data'=>'team_save')), array(array('text'=>'⬅️ بازگشت','callback_data'=>'dep'))))); exit;
  }
  if($data==='team_save'){
    $st = Storage::readJson("users/$uid/state.json", array()); $cid=$st['team']['cid']; $sel=$st['team']['sel'];
    $team_id = 'TEAM'.time();
    $team = array('id'=>$team_id,'contract'=>$cid,'manager'=>$uid,'members'=>$sel,'created_at'=>time());
    Storage::writeJson("teams/$team_id.json",$team);
    $tg->editMessageText($chat,$mid,"تیم ساخته شد ✅\nشناسه: $team_id",kb(back('dep'))); exit;
  }
  if($data==='dep_team_list'){
    $dir=__DIR__.'/storage/teams'; if(!is_dir($dir)){ $tg->editMessageText($chat,$mid,'تیمی ساخته نشده.',kb(back('dep'))); exit; }
    $files=array(); foreach(scandir($dir) as $f){ if(substr($f,-5)==='.json') $files[]=$f; }
    if(!count($files)){ $tg->editMessageText($chat,$mid,'تیمی ساخته نشده.',kb(back('dep'))); exit; }
    $txt="تیم‌های شما:\n"; foreach($files as $f){ $t=Storage::readJson('teams/'.$f, array()); if($t['manager']==$uid) $txt.="— {$t['id']} | قرارداد {$t['contract']}\n"; }
    $tg->editMessageText($chat,$mid,$txt,kb(back('dep'))); exit;
  }

  // ===== Department: Offish =====
  if($data==='dep_offish_new'){
    // pick team
    $dir=__DIR__.'/storage/teams'; $files=array(); foreach(is_dir($dir)?scandir($dir):array() as $f){ if(substr($f,-5)==='.json') $files[]=$f; }
    if(!count($files)){ $tg->editMessageText($chat,$mid,'ابتدا تیم بساز.',kb(back('dep'))); exit; }
    $kb=array();
    foreach($files as $f){ $t=Storage::readJson('teams/'.$f, array()); if($t['manager']==$uid) $kb[] = array(array('text'=>$t['id'].' / '.$t['contract'],'callback_data'=>'offish_for:'.$t['id'])); }
    if(!count($kb)){ $tg->editMessageText($chat,$mid,'تیمی برای شما یافت نشد.',kb(back('dep'))); exit; }
    $kb = array_merge($kb, back('dep'));
    $tg->editMessageText($chat,$mid,'برای کدام تیم آفیش ثبت کنیم؟',kb($kb)); exit;
  }
  if(strpos($data,'offish_for:')===0){
    $team_id = explode(':',$data)[1];
    // Limit: max 3 per jalali month (simplified: per Gregorian month for now)
    $cnt=0; $dir=__DIR__.'/storage/tasks'; foreach(is_dir($dir)?scandir($dir):array() as $f){ if(substr($f,0,3)=='OFF' && substr($f,-5)==='.json'){ $o=Storage::readJson('tasks/'.$f, array()); if(isset($o['team']) && $o['team']==$team_id && isset($o['start']) && same_jmonth($o['start'], time())) $cnt++; } }
    if($cnt>=3){ $tg->editMessageText($chat,$mid,'این تیم در این ماه به سقف ۳ آفیش رسیده است.',kb(back('dep'))); exit; }
    Storage::writeJson("users/$uid/state.json", array('offish'=>array('team'=>$team_id)));
    // choose date from next 14 days
    $kb=array(); for($i=0;$i<14;$i++){ $d = date('Y-m-d', time()+$i*86400); $label = jlabel_date($d); $kb[] = array(array('text'=>$label,'callback_data'=>'offish_date:'.$d)); }
    $kb[] = array(array('text'=>'⬅️ بازگشت','callback_data'=>'dep'));
    $tg->editMessageText($chat,$mid,'تاریخ آفیش را انتخاب کن:',kb($kb)); exit;
  }
  if(strpos($data,'offish_date:')===0){
    $d = explode(':',$data)[1]; $st = Storage::readJson("users/$uid/state.json", array()); $st['offish']['date']=$d; Storage::writeJson("users/$uid/state.json",$st);
    $times = array('09:00','11:00','13:00','15:00','17:00');
    $kb=array(); foreach($times as $t){ $kb[] = array(array('text'=>$t,'callback_data'=>'offish_time:'.$t)); }
    $kb = array_merge($kb, back('dep'));
    $tg->editMessageText($chat,$mid,"ساعت حضور را انتخاب کن:",kb($kb)); exit;
  }
  if(strpos($data,'offish_time:')===0){
    $t = explode(':',$data,2)[1]; $st = Storage::readJson("users/$uid/state.json", array()); $st['offish']['time']=$t; Storage::writeJson("users/$uid/state.json",$st);
    $st['offish']['step']='loc'; Storage::writeJson("users/$uid/state.json",$st);
    $tg->editMessageText($chat,$mid,"آدرس/لوکیشن مشتری را به‌صورت متن ارسال کن.",kb(back('dep'))); exit;
  }

  if($data==='offish_save'){
    $st = Storage::readJson("users/$uid/state.json", array()); $o=$st['offish']; $team_id=$o['team'];
    $oid = 'OFF'.time();
    $start = strtotime($o['date'].' '.$o['time'].':00');
    $task = array('id'=>$oid,'type'=>'offish','team'=>$team_id,'status'=>'scheduled','title'=>'آفیش','start'=>$start,'loc'=>$o['loc'],'created_at'=>time(),'confirm'=>array('cam'=>null,'blog'=>null));
    Storage::writeJson("tasks/$oid.json",$task);
    // notify camera & blogger
    $t = Storage::readJson("teams/$team_id.json", array()); $cam = isset($t['members']['cam'])?$t['members']['cam']:null; $blog = isset($t['members']['blog'])?$t['members']['blog']:null;
    if($cam){ $tg->sendMessage($cam, "🎬 آفیش جدید\nتاریخ: ".$o['date']."\nساعت: ".$o['time']."\nلوکیشن: ".$o['loc']."\nآیا تایید می‌کنی؟", kb(array(array(array('text'=>'✅ تایید','callback_data'=>'offish_cam_ok:'.$oid), array('text'=>'❌ رد','callback_data'=>'offish_cam_no:'.$oid))))); }
    if($blog){ $tg->sendMessage($blog, "🗓 برنامه بلاگر - آفیش جدید\nتاریخ: ".$o['date']."\nساعت: ".$o['time']."\nلوکیشن: ".$o['loc']."\nآیا تایید می‌کنی؟", kb(array(array(array('text'=>'✅ تایید','callback_data'=>'offish_blog_ok:'.$oid), array('text'=>'❌ رد','callback_data'=>'offish_blog_no:'.$oid))))); }
    $tg->editMessageText($chat,$mid,"آفیش ثبت شد ✅\nشناسه: $oid",kb(back('dep')));
    // Scenario 30h task
    $scn = isset($t['members']['scn'])?$t['members']['scn']:null;
    if($scn){ $dl = time()+30*3600; $tid='TSKSCN'.time(); Storage::writeJson('tasks/'.$tid.'.json', array('id'=>$tid,'type'=>'scenario','team'=>$team_id,'assignee'=>$scn,'deadline'=>$dl,'status'=>'pending','title'=>'ارسال سناریو برای آفیش '.$oid)); $tg->sendMessage($scn, "✍️ وظیفهٔ جدید: ارسال سناریو تا ".jlabel_ts($dl), ['inline_keyboard'=>[[['text'=>'تمام شد','callback_data'=>'task_done:'.$tid]]]] ); }
    exit;
  }
  if($data==='dep_offish_list'){
    $dir=__DIR__.'/storage/tasks'; $files=array(); foreach(is_dir($dir)?scandir($dir):array() as $f){ if(substr($f,0,3)=='OFF' && substr($f,-5)==='.json') $files[]=$f; }
    if(!count($files)){ $tg->editMessageText($chat,$mid,'آفیـشی ثبت نشده.',kb(back('dep'))); exit; }
    $txt="آفیش‌ها:\n"; foreach($files as $f){ $o=Storage::readJson('tasks/'.$f, array()); $txt.="— {$o['id']} | ".jlabel_ts($o['start'])." | {$o['status']}\n"; }
    $tg->editMessageText($chat,$mid,$txt,kb(back('dep'))); exit;
  }

  // Confirmations by camera/blogger
  if(strpos($data,'offish_cam_ok:')===0 || strpos($data,'offish_cam_no:')===0 || strpos($data,'offish_blog_ok:')===0 || strpos($data,'offish_blog_no:')===0){
    $parts = explode(':',$data); $type=$parts[0]; $oid=$parts[1];
    $o = Storage::readJson("tasks/$oid.json", array()); if(!$o){ $tg->answerCallback($cb['id'],'یافت نشد'); exit; }
    if($type=='offish_cam_ok') $o['confirm']['cam']='ok';
    if($type=='offish_cam_no') { $o['confirm']['cam']='no'; $tg->sendMessage($o['team'] ?? $uid, ''); } // noop
    if($type=='offish_blog_ok') $o['confirm']['blog']='ok';
    if($type=='offish_blog_no') $o['confirm']['blog']='no';
    Storage::writeJson("tasks/$oid.json",$o);
    $tg->answerCallback($cb['id'],'ثبت شد'); exit;
  }

  // Cameraman presence check buttons (sent by cron at start time)
  if(strpos($data,'cam_present_yes:')===0 || strpos($data,'cam_present_no:')===0){
    $oid = explode(':',$data)[1]; $o=Storage::readJson("tasks/$oid.json", array()); if(!$o){ $tg->answerCallback($cb['id'],'یافت نشد'); exit; }
    if(strpos($data,'cam_present_yes:')===0){ $o['status']='in_progress'; $o['start_real']=time(); Storage::writeJson("tasks/$oid.json",$o); $tg->editMessageText($chat,$mid,"حضور ثبت شد ✅\nدر پایان روی «اتمام آفیش» بزن.", kb(array(array(array('text'=>'🎬 اتمام آفیش','callback_data'=>'offish_finish:'.$oid))))); }
    else { $tg->answerCallback($cb['id'],'عدم حضور ثبت شد'); /* notify manager later in cron */ }
    exit;
  }
  if(strpos($data,'offish_finish:')===0){
    $oid = explode(':',$data)[1]; $o=Storage::readJson("tasks/$oid.json", array()); if(!$o){ $tg->answerCallback($cb['id'],'یافت نشد'); exit; }
    $o['status']='done'; $o['end_real']=time(); Storage::writeJson("tasks/$oid.json",$o);
    $tg->editMessageText($chat,$mid,"آفیش به پایان رسید ✅\nساعت آغاز: ".date('H:i',$o['start_real'])."\nساعت پایان: ".date('H:i',$o['end_real']), kb(back('dep')));
    // Cameraman must send files within 24h; editor must verify within next 24h
    $t = Storage::readJson('teams/'.$o['team'].'.json', array()); $cam = isset($t['members']['cam'])?$t['members']['cam']:null; $edit = isset($t['members']['edit'])?$t['members']['edit']:null; if($cam){ $dl = time()+24*3600; $tid='TSKCAM'.time(); Storage::writeJson('tasks/'.$tid.'.json', array('id'=>$tid,'type'=>'camera_upload','team'=>$o['team'],'assignee'=>$cam,'deadline'=>$dl,'status'=>'pending','title'=>'ارسال فایل‌های خام آفیش '.$o['id'])); $tg->sendMessage($cam, "📤 لطفاً فایل‌های خام را تا ".jlabel_ts($dl)." ارسال و تایید کن.", ['inline_keyboard'=>[[['text'=>'تمام شد','callback_data'=>'task_done:'.$tid]]]] ); }
    if($edit){ $dl2 = time()+48*3600; $tid2='TSKED'.time(); Storage::writeJson('tasks/'.$tid2.'.json', array('id'=>$tid2,'type'=>'editor_check','team'=>$o['team'],'assignee'=>$edit,'deadline'=>$dl2,'status'=>'pending','title'=>'بررسی کامل بودن فایل‌ها برای آفیش '.$o['id'])); $tg->sendMessage($edit, "🧪 بررسی فایل‌ها تا ".jlabel_ts($dl2)." و تایید تعداد مطابق سناریو.", ['inline_keyboard'=>[[['text'=>'تمام شد','callback_data'=>'task_done:'.$tid2]]]] ); }
    exit;
  }


  // ===== Department: Content Calendar (Jalali labels) =====
  if($data==='dep_calendar'){
    $dir=__DIR__.'/storage/teams'; $files=array(); foreach(is_dir($dir)?scandir($dir):array() as $f){ if(substr($f,-5)==='.json') $files[]=$f; }
    if(!count($files)){ $tg->editMessageText($chat,$mid,'ابتدا تیم بساز.',kb(back('dep'))); exit; }
    $kb=array();
    foreach($files as $f){ $t=Storage::readJson('teams/'.$f, array()); if($t['manager']==$uid) $kb[] = array(array('text'=>$t['id'].' / '.$t['contract'],'callback_data'=>'cal_for:'.$t['id'])); }
    if(!count($kb)){ $tg->editMessageText($chat,$mid,'تیمی برای شما یافت نشد.',kb(back('dep'))); exit; }
    $kb = array_merge($kb, back('dep'));
    $tg->editMessageText($chat,$mid,'برای کدام تیم تقویم بسازیم؟',kb($kb)); exit;
  }
  if(strpos($data,'cal_for:')===0){
    $team = explode(':',$data)[1];
    $state = array('cal'=>array('team'=>$team,'posts'=>array(),'stories'=>array(),'step'=>'posts'));
    Storage::writeJson("users/$uid/state.json", $state);
    $kb=array();
    for($i=0;$i<7;$i++){
      $d = date('Y-m-d', time()+$i*86400);
      $label = jlabel_date($d);
      $isFriday = (date('w', strtotime($d))=='5');
      $kb[] = array(array('text'=>$label.' '.($isFriday?'⛔':'☐'),'callback_data'=>'cal_toggle_post:'.$d));
    }
    $kb[] = array(array('text'=>'✅ تایید روزهای پست','callback_data'=>'cal_posts_done'));
    $kb[] = array(array('text'=>'⬅️ بازگشت','callback_data'=>'dep'));
    $tg->editMessageText($chat,$mid,'روزهای پست را انتخاب کن (چندتایی):',kb($kb)); exit;
  }
  if(strpos($data,'cal_toggle_post:')===0){
    $d = explode(':',$data)[1];
    $st = Storage::readJson("users/$uid/state.json", array()); $arr = isset($st['cal']['posts'])?$st['cal']['posts']:array();
    if(in_array($d,$arr)){ $arr = array_values(array_diff($arr, array($d))); } else { $arr[]=$d; }
    $st['cal']['posts'] = $arr; Storage::writeJson("users/$uid/state.json",$st);
    $kb=array();
    for($i=0;$i<7;$i++){
      $d2 = date('Y-m-d', time()+$i*86400); $label = jlabel_date($d2);
      $mark = in_array($d2,$arr)?'☑':'☐';
      $kb[] = array(array('text'=>$label.' '+$mark, 'callback_data'=>'cal_toggle_post:'.$d2));
    }
    $kb[] = array(array('text'=>'✅ تایید روزهای پست','callback_data'=>'cal_posts_done'));
    $kb[] = array(array('text'=>'⬅️ بازگشت','callback_data'=>'dep'));
    $tg->editMessageText($chat,$mid,'روزهای پست را انتخاب کن (چندتایی):',kb($kb)); exit;
  }
  if($data==='cal_posts_done'){
    $st = Storage::readJson("users/$uid/state.json", array()); $st['cal']['step']='stories'; Storage::writeJson("users/$uid/state.json",$st);
    $kb=array();
    for($i=0;$i<7;$i++){
      $d = date('Y-m-d', time()+$i*86400);
      $label = jlabel_date($d);
      $kb[] = array(array('text'=>$label+' ☑','callback_data'=>'cal_toggle_story:'.$d));
    }
    $kb[] = array(array('text'=>'✅ ثبت تقویم','callback_data'=>'cal_save'));
    $kb[] = array(array('text'=>'⬅️ بازگشت','callback_data'=>'dep'));
    $tg->editMessageText($chat,$mid,'روزهای استوری را انتخاب کن:',kb($kb)); exit;
  }
  if(strpos($data,'cal_toggle_story:')===0){
    $d = explode(':',$data)[1];
    $st = Storage::readJson("users/$uid/state.json", array());
    $arr = isset($st['cal']['stories'])?$st['cal']['stories']:array();
    if(in_array($d,$arr)){ $arr = array_values(array_diff($arr, array($d))); } else { $arr[]=$d; }
    $st['cal']['stories'] = $arr; Storage::writeJson("users/$uid/state.json",$st);
    $kb=array();
    for($i=0;$i<7;$i++){
      $d2 = date('Y-m-d', time()+$i*86400); $label = jlabel_date($d2);
      $mark = in_array($d2,$arr)?'☑':'☐';
      $kb[] = array(array('text'=>$label.' '+$mark, 'callback_data'=>'cal_toggle_story:'.$d2));
    }
    $kb[] = array(array('text'=>'✅ ثبت تقویم','callback_data'=>'cal_save'));
    $kb[] = array(array('text'=>'⬅️ بازگشت','callback_data'=>'dep'));
    $tg->editMessageText($chat,$mid,'روزهای استوری را انتخاب کن:',kb($kb)); exit;
  }
  if($data==='cal_save'){
    $st = Storage::readJson("users/$uid/state.json", array()); $cal=$st['cal']; $team=$cal['team'];
    $t = Storage::readJson("teams/$team.json", array()); $adm = isset($t['members']['adm'])?$t['members']['adm']:null;
    if($adm){
      foreach($cal['posts'] as $d){
        $deadline = strtotime($d.' 23:00:00');
        $id = 'TASKP'.time().rand(100,999);
        Storage::writeJson("tasks/$id.json", array('id'=>$id,'type'=>'content_post','team'=>$team,'assignee'=>$adm,'deadline'=>$deadline,'status'=>'pending','title'=>'آپلود پست '.jlabel_date($d)));
      }
      foreach($cal['stories'] as $d){
        $deadline = strtotime($d.' 23:00:00');
        $id = 'TASKS'.time().rand(100,999);
        Storage::writeJson("tasks/$id.json", array('id'=>$id,'type'=>'content_story','team'=>$team,'assignee'=>$adm,'deadline'=>$deadline,'status'=>'pending','title'=>'آپلود استوری '.jlabel_date($d)));
      }
      $tg->editMessageText($chat,$mid,'تقویم محتوایی ثبت شد و وظایف ساخته شدند ✅',kb(back('dep')));
      $tg->sendMessage($adm, "📌 تقویم محتوایی جدید برای تیم $team ثبت شد. وظایف روزانه تا ساعت ۲۳ هر روز تعیین شده‌اند.");
    } else {
      $tg->editMessageText($chat,$mid,'ادمین برای این تیم مشخص نشده.',kb(back('dep')));
    }
    exit;
  }

  // «تمام شد» برای وظایف روزانه
  if(strpos($data,'task_done:')===0){
    $tid = explode(':',$data)[1];
    $t = Storage::readJson("tasks/$tid.json", array()); if(!$t){ $tg->answerCallback($cb['id'],'یافت نشد'); exit; }
    $t['status']='done'; $t['done_at']=time(); Storage::writeJson("tasks/$tid.json",$t);
    $tg->editMessageText($chat,$mid,"✅ وظیفه انجام شد.\nزمان: ".jlabel_ts($t['done_at']), kb(back('root'))); exit;
  }


  if($data==='mytasks'){
    $uid_tasks = array();
    $dir = __DIR__.'/storage/tasks';
    foreach(is_dir($dir)?scandir($dir):array() as $f){
      if(substr($f,-5) !== '.json') continue;
      $t = Storage::readJson('tasks/'.$f, array());
      if(isset($t['assignee']) && $t['assignee']==$uid && ($t['status']??'pending')!='done'){
        $uid_tasks[] = $t;
      }
    }
    if(!count($uid_tasks)){
      $tg->editMessageText($chat,$mid,'هیچ وظیفهٔ بازی ندارید ✅', kb(back('root'))); exit;
    }
    usort($uid_tasks, function($a,$b){ return ($a['deadline']??9999999999) <=> ($b['deadline']??9999999999); });
    $lines = array("🗂 وظایف باز شما:");
    $kb_rows = array();
    foreach(array_slice($uid_tasks,0,10) as $t){
      $lbl = ($t['title'] ?? $t['id']).' | موعد: '.jlabel_ts($t['deadline'] ?? time());
      $lines[] = '— '.$lbl;
      $kb_rows[] = array(array('text'=>'تمام شد: '.$t['id'], 'callback_data'=>'task_done:'.$t['id']));
    }
    $kb_rows[] = array(array('text'=>'⬅️ بازگشت','callback_data'=>'root'));
    $tg->editMessageText($chat,$mid,implode("\n",$lines), kb($kb_rows)); exit;
  }


  // ===== Department: Penalties =====
  if($data==='dep_pen'){
    // choose employee from employees.json
    $emps = json_decode(file_get_contents(__DIR__.'/storage/employees.json'), true);
    $kb = array();
    foreach($emps as $e){
      $kb[] = array(array('text'=>$e['name'].' ('.$e['role'].')','callback_data'=>'pen_emp:'.$e['id']));
    }
    $kb = array_merge($kb, back('dep'));
    $tg->editMessageText($chat,$mid,'پرونده تخلف برای کدام پرسنل؟', kb($kb)); exit;
  }
  if(strpos($data,'pen_emp:')===0){
    $eid = intval(explode(':',$data)[1]);
    Storage::writeJson("users/$uid/state.json", array('pen'=>array('emp'=>$eid,'step'=>'reason')));
    $tg->editMessageText($chat,$mid,'دلیل تخلف را به صورت متن ارسال کن و در صورت نیاز عکس مستند هم بعداً بفرست.', kb(back('dep'))); exit;
  }


  if(strpos($data,'pen_amt:')===0){
    $val = explode(':',$data)[1];
    $st = Storage::readJson("users/$uid/state.json", array()); $pen = $st['pen']; $eid=$pen['emp'];
    $amount = ($val=='general') ? ($config['penalties']['general'] ?? 250000) : intval($val);
    $pid = 'PEN'.time();
    $rec = array('id'=>$pid,'emp'=>$eid,'by'=>$uid,'reason'=>$pen['reason'] ?? '—','amount'=>$amount,'time'=>time(),'status'=>'pending_accounting');
    Storage::writeJson("penalties/$pid.json",$rec);
    $tg->editMessageText($chat,$mid,"پروندهٔ جریمه ثبت شد و برای حسابداری ارسال گردید ✅\nشناسه: $pid", kb(back('dep'))); exit;
  }


  if($data==='acc_pens'){
    $dir=__DIR__.'/storage/penalties'; $files=array(); foreach(is_dir($dir)?scandir($dir):array() as $f){ if(substr($f,-5)==='.json') $files[]=$f; }
    $pending = array(); foreach($files as $f){ $x=Storage::readJson('penalties/'.$f, array()); if(($x['status']??'')==='pending_accounting') $pending[]=$x; }
    if(!count($pending)){ $tg->editMessageText($chat,$mid,'پروندهٔ در انتظار تایید حسابداری نداریم.', kb(back('acc'))); exit; }
    $p = $pending[0];
    $kb = array(
      array(array('text'=>'✅ تایید حسابداری','callback_data'=>'acc_pen_ok:'.$p['id']), array('text'=>'❌ رد','callback_data'=>'acc_pen_rej:'.$p['id'])),
      array(array('text'=>'⬅️ بازگشت','callback_data'=>'acc'))
    );
    $txt = "پرونده جریمه {$p['id']}\nپرسنل: {$p['emp']}\nمبلغ: ".number_format($p['amount'])." تومان\nدلیل: {$p['reason']}\nارسال‌کننده: {$p['by']}";
    $tg->editMessageText($chat,$mid,$txt, kb($kb)); exit;
  }
  if(strpos($data,'acc_pen_ok:')===0 || strpos($data,'acc_pen_rej:')===0){
    $pid = explode(':',$data)[1];
    $p = Storage::readJson("penalties/$pid.json", array());
    if(!$p){ $tg->editMessageText($chat,$mid,'یافت نشد.', kb(back('acc_pens'))); exit; }
    if(strpos($data,'acc_pen_ok:')===0){ $p['status']='pending_ceo'; }
    else { $p['status']='rejected'; }
    Storage::writeJson("penalties/$pid.json",$p);
    $tg->editMessageText($chat,$mid,'بروزرسانی شد.', kb(back('acc_pens'))); exit;
  }

  // CEO review (منتظر امضا)
  if($data==='ceo_sign'){
    $dir=__DIR__.'/storage/penalties'; $files=array(); foreach(is_dir($dir)?scandir($dir):array() as $f){ if(substr($f,-5)==='.json') $files[]=$f; }
    $pend = array(); foreach($files as $f){ $x=Storage::readJson('penalties/'.$f, array()); if(($x['status']??'')==='pending_ceo') $pend[]=$x; }
    if(!count($pend)){ $tg->editMessageText($chat,$mid,'پرونده‌ای برای امضا وجود ندارد.',kb(back('ceo'))); exit; }
    $x=$pend[0];
    $kb=array(
      array(array('text'=>'✅ تایید نهایی','callback_data'=>'ceo_pen_ok:'.$x['id']), array('text'=>'❌ رد','callback_data'=>'ceo_pen_rej:'.$x['id'])),
      array(array('text'=>'⬅️ بازگشت','callback_data'=>'ceo'))
    );
    $tg->editMessageText($chat,$mid,"پرونده {$x['id']} | مبلغ: ".number_format($x['amount'])." | دلیل: {$x['reason']}", kb($kb)); exit;
  }
  if(strpos($data,'ceo_pen_ok:')===0 || strpos($data,'ceo_pen_rej:')===0){
    $pid = explode(':',$data)[1];
    $p = Storage::readJson("penalties/$pid.json", array());
    if(!$p){ $tg->editMessageText($chat,$mid,'یافت نشد.',kb(back('ceo_sign'))); exit; }
    if(strpos($data,'ceo_pen_ok:')===0){
      $p['status']='approved';
      Storage::writeJson("penalties/$pid.json",$p);
      // deduct from payroll
      $led = Storage::readJson('payroll/'.$p['emp'].'.json', array('employee_id'=>$p['emp'],'deductions'=>array()));
      $led['deductions'][] = array('id'=>$pid,'amount'=>$p['amount'],'reason'=>$p['reason'],'time'=>time());
      Storage::writeJson('payroll/'.$p['emp'].'.json', $led);
      $tg->editMessageText($chat,$mid,'تایید شد و از حقوق کسر گردید.', kb(back('ceo_sign'))); exit;
    } else {
      $p['status']='rejected'; Storage::writeJson("penalties/$pid.json",$p);
      $tg->editMessageText($chat,$mid,'رد شد.', kb(back('ceo_sign'))); exit;
    }
  }


  if($data==='payroll_me'){
    $led = Storage::readJson('payroll/'.$uid.'.json', array('salary'=>0,'deductions'=>array(),'bonuses'=>array()));
    $sum_d = 0; foreach(($led['deductions']??array()) as $d){ $sum_d += intval($d['amount']); }
    $sum_b = 0; foreach(($led['bonuses']??array()) as $b){ $sum_b += intval($b['amount']); }
    $net = intval($led['salary']) - $sum_d + $sum_b;
    $txt = "💳 فیش حقوقی شما\nحقوق پایه: ".fa_amount($led['salary'])."\nکسورات: ".fa_amount($sum_d)."\nمزایا: ".fa_amount($sum_b)."\n-----------------\nخالص پرداختی: ".fa_amount($net);
    $tg->editMessageText($chat,$mid,$txt, kb(back('root'))); exit;
  }

  // default
  $tg->editMessageText($chat,$mid,"گزینه نامعتبر. /start",kb(back('root'))); exit;


echo json_encode(array('ok'=>true));
