<?php
// /handlers/hook_accounting_text.php — FINAL v1 (expanded keywords + robust normalization)

declare(strict_types=1);

require_once __DIR__ . '/../functions/telegram.php';
require_once __DIR__ . '/../functions/utils.php';
require_once __DIR__ . '/../handlers/accounting.php';

function _fa_norm($s) {
    $s = str_replace(['ي','ك'], ['ی','ک'], $s);
    $s = preg_replace('/[\x{200c}\x{200f}\x{202a}-\x{202e}]/u','',$s);
    $s = preg_replace('/\p{So}/u','',$s);
    $s = str_replace(['—','–','|','•','·','…'],' ',$s);
    $s = str_replace([' / ','/','\\'],' ',$s);
    $s = trim(preg_replace('/\s+/u',' ',$s));
    return $s;
}
function _has($haystack,$needle){return mb_stripos($haystack,$needle)!==false;}

function hook_accounting_text($update){
    if(!is_array($update))return false;
    if(!isset($update['message']))return false;
    $msg=$update['message'];
    $uid=(int)($msg['from']['id']??0);
    $chat_id=(int)($msg['chat']['id']??0);
    $text=(string)($msg['text']??'');
    if($uid<=0||$chat_id<=0||$text==='')return false;
    if(!function_exists('is_ceo')||!is_ceo($uid))return false;
    $norm=_fa_norm($text);
    $full_invoices=['فاکتورها ایجاد ویرایش پرداخت تخفیف مالیات','فاکتور ها ایجاد ویرایش پرداخت تخفیف مالیات'];
    $full_contracts=['قراردادها ایجاد ویرایش امضا تمدید فسخ','قرارداد ها ایجاد ویرایش امضا تمدید فسخ'];
    $full_account=['گزارش مالی مانده','پنل حسابداری','مالی گزارش','حسابداری'];
    $full_customer_new=['مشتری جدید','ثبت مشتری جدید','افزودن مشتری'];
    foreach($full_invoices as $s){if($norm===_fa_norm($s)){acc_handle($uid,'acc:list_invoices',$chat_id,0);return true;}}
    foreach($full_contracts as $s){if($norm===_fa_norm($s)){acc_handle($uid,'acc:list_contracts',$chat_id,0);return true;}}
    foreach($full_account as $s){if($norm===_fa_norm($s)){acc_menu($uid,$chat_id,0);return true;}}
    foreach($full_customer_new as $s){if($norm===_fa_norm($s)){acc_handle($uid,'acc:cust_demo',$chat_id,0);return true;}}
    if(_has($norm,'فاکتور')){acc_handle($uid,'acc:list_invoices',$chat_id,0);return true;}
    if(_has($norm,'قرارداد')){acc_handle($uid,'acc:list_contracts',$chat_id,0);return true;}
    if(_has($norm,'حسابداری')||_has($norm,'گزارش مالی')){acc_menu($uid,$chat_id,0);return true;}
    return false;
}
