<?php
declare(strict_types=1);
require_once __DIR__ . '/../config.php';
require_once __DIR__ . '/config_boot.php';
require_once __DIR__ . '/utils.php';
function tg_api(string $method, array $params = []): array {
    $url='https://api.telegram.org/bot'.vm_get_token().'/'.$method;
    $ch=curl_init($url);
    curl_setopt_array($ch,[CURLOPT_RETURNTRANSFER=>true,CURLOPT_POST=>true,CURLOPT_POSTFIELDS=>$params,CURLOPT_TIMEOUT=>30]);
    $res=curl_exec($ch);
    if($res===false){ log_line("[TG] curl error: ".curl_error($ch)); return ['ok'=>false]; }
    $j=json_decode($res,true); if(!is_array($j)) $j=['ok'=>false,'raw'=>$res]; if(!( $j['ok']??false )) log_line("[TG] api error: ".$res); return $j;
}
function tg_send_html(int $chat_id, string $html, ?array $kb=null): void {
    $p=['chat_id'=>$chat_id,'text'=>$html,'parse_mode'=>'HTML','disable_web_page_preview'=>true];
    if($kb) $p['reply_markup']=json_encode(['inline_keyboard'=>$kb], JSON_UNESCAPED_UNICODE);
    tg_api('sendMessage',$p);
}
function tg_answer_cb(string $id, string $text=''): void { tg_api('answerCallbackQuery',['callback_query_id'=>$id,'text'=>$text,'show_alert'=>false]); }
