<?php
declare(strict_types=1);
require_once __DIR__ . '/../functions/telegram.php';
require_once __DIR__ . '/../functions/utils.php';
require_once __DIR__ . '/../functions/storage.php';
require_once __DIR__ . '/../functions/photographer_upload_review.php';
function dm_menu(int $chat_id): void {
    $rows = [
        [ kb_btn(icon('files')." فایل‌های خام", 'dm:rawfiles'), kb_btn(icon('assign')." تخصیص/ویرایش", 'dm:assign') ],
        [ kb_btn(icon('back')." بازگشت", 'ceo:menu') ],
    ];
    tg_send_html($chat_id, friendly_greeting()."\n\n".icon('dept')." <b>پنل مدیر دپارتمان</b>", $rows);
}
function dm_handle(string $data, int $chat_id): void {
    if ($data === 'dm:menu') { dm_menu($chat_id); return; }
    if ($data === 'dm:rawfiles') {
        $items = raw_list();
        $txt = "<b>فایل‌های خام:</b>\n".($items? json_encode($items, JSON_UNESCAPED_UNICODE|JSON_PRETTY_PRINT):"خالی");
        $kb = [[ kb_btn(icon('camera')." ثبت فایل خام نمونه", 'dm:raw:add') ]];
        tg_send_html($chat_id, friendly_greeting()."\n\n".$txt, $kb);
    } elseif ($data === 'dm:raw:add') {
        $id = raw_add_zip( SPECIAL_PHOTOGRAPHER_ID, "ZIP Sample #".rand(100,999) );
        tg_send_html($chat_id, friendly_greeting()."\n\n".icon('ok')." فایل خام نمونه ثبت شد (ID: $id).");
    } elseif ($data === 'dm:assign') {
        tg_send_html($chat_id, friendly_greeting()."\n\n"."تخصیص نیرو/ویرایش: در نسخهٔ بعد تکمیل می‌شود.");
    }
}


require_once __DIR__ . '/../functions/offish.php';
require_once __DIR__ . '/../functions/penalties.php';

function dm_team_setup(int $chat_id): void {
    $txt = "<b>تشکیل تیم مشتری</b>\n(نسخهٔ سریع نمونه)";
    $kb = [
        [ kb_btn("ثبت تیم نمونه برای مشتری 1001", "dm:team:set:1001") ],
        [ kb_btn(icon('back')." بازگشت", 'dm:menu') ]
    ];
    tg_send_html($chat_id, $txt, $kb);
}

function dm_offish_schedule(int $chat_id): void {
    $txt = "<b>تنظیم آفیش</b>\nبرای تست: زمان را برای 48 ساعت بعد ثبت می‌کنیم.";
    $kb = [
        [ kb_btn("تنظیم آفیش نمونه برای مشتری 1001", "dm:offish:add:1001") ],
        [ kb_btn(icon('back')." بازگشت", 'dm:menu') ]
    ];
    tg_send_html($chat_id, $txt, $kb);
}

function dm_penalty_menu(int $chat_id): void {
    $txt = "<b>جریمه‌ها</b>\nعمومی: 250,000\nدستی: 50/100/300/500/1,000 هزار";
    $kb = [
        [ kb_btn("ثبت جریمه عمومی", "dm:pen:pub") ],
        [ kb_btn("جریمه دستی 50", "dm:pen:50"), kb_btn("100", "dm:pen:100"), kb_btn("300", "dm:pen:300") ],
        [ kb_btn("500", "dm:pen:500"), kb_btn("1,000", "dm:pen:1000") ],
        [ kb_btn(icon('back')." بازگشت", 'dm:menu') ]
    ];
    tg_send_html($chat_id, $txt, $kb);
}

# extend handler
function dm_handle_plus(string $data, int $chat_id): bool {
    if ($data==='dm:team') { dm_team_setup($chat_id); return true; }
    if ($data==='dm:offish') { dm_offish_schedule($chat_id); return true; }
    if ($data==='dm:pen') { dm_penalty_menu($chat_id); return true; }

    if (strpos($data,'dm:team:set:')===0) {
        $cust = (int)substr($data, strstrlen('dm:team:set:'));
        team_set($cust, $chat_id, ['scenario'=>162160538,'blogger'=>162160538,'photographer'=>620344705,'editor'=>162160538,'admin'=>1055485720]);
        tg_send_html($chat_id, "✅ تیم مشتری $cust ثبت شد."); return true;
    }
    if (strpos($data,'dm:offish:add:')===0) {
        $cust = (int)substr($data, strstrlen('dm:offish:add:'));
        $date_ts = time() + 48*3600;
        $id = offish_create($cust, $chat_id, $date_ts, ['customer_name'=>'مشتری نمونه','ig'=>'@sample','address'=>'کرج','location'=>'35.8,50.9','hour'=>date('H:i',$date_ts),'date'=>date('Y-m-d',$date_ts)]);
        tg_send_html($chat_id, "📅 آفیش #$id برای مشتری $cust تنظیم شد."); return true;
    }
    if (strpos($data,'dm:pen:')===0) {
        $map = ['pub'=>250000,'50'=>50000,'100'=>100000,'300'=>300000,'500'=>500000,'1000'=>1000000];
        $key = substr($data, strlen('dm:pen:'));
        $amount = $map[$key] ?? 250000;
        pen_add($chat_id, $amount, 'جریمه توسط مدیر دپارتمان');
        tg_send_html($chat_id, "🔴 جریمه ثبت شد: ".$amount); return true;
    }
    if (strpos($data,'offish:confirm:')===0) {
        // offish:confirm:{yes|no}:{id}
        $parts = explode(':', $data);
        $ans = $parts[2] ?? 'no';
        $id = (int)($parts[3] ?? 0);
        $rec = offish_get($id);
        if ($rec) {
            // mark based on who answered (photographer/blogger inferred by chat_id vs team)
            $team = team_get((int)$rec['customer_id']);
            $who = ($chat_id == (int)($team['members']['photographer']??0)) ? 'photographer' : 'blogger';
            $rec['confirms'][$who] = ($ans==='yes') ? 'yes':'no';
            offish_update($rec);
            tg_send_html($chat_id, "ثبت شد: پاسخ شما برای آفیش #$id → ".(($ans==='yes')?'تأیید':'رد'));
        }
        return true;
    }
    return false;
}


require_once __DIR__ . '/../functions/tasks.php';

function next7days(): array {
    $arr=[]; for($i=1;$i<=7;$i++){ $ts=strtotime("+$i day"); $arr[]=['ts'=>$ts,'label'=>date('Y-m-d',$ts)]; } return $arr;
}
function dm_calendar_start(int $chat_id, int $customer_id): void {
    $list = next7days();
    $kb=[]; foreach($list as $d){ $kb[]=[ kb_btn($d['label'],'dm:cal:post:toggle:'.$customer_id.':'.$d['label']) ]; }
    $kb[]=[ kb_btn("ادامه → انتخاب روزهای استوری","dm:cal:story:start:".$customer_id) ];
    tg_send_html($chat_id, "🗓️ روزهای <b>پست</b> هفته‌ی پیشِ رو را انتخاب کن:", $kb);
}
function dm_calendar_toggle(string $type, int $customer_id, string $date_label, int $chat_id): void {
    $p = plans_all(); $pkey = (string)$customer_id;
    if (!isset($p[$pkey])) $p[$pkey] = ['posts'=>[],'stories'=>[]];
    $arr = &$p[$pkey][$type];
    $idx = array_search($date_label, $arr);
    if ($idx===false) $arr[] = $date_label; else array_splice($arr,$idx,1);
    plans_save($p);
    tg_send_html($chat_id, "ثبت شد: {$type} @ {$date_label}");
}
function dm_calendar_story(int $chat_id, int $customer_id): void {
    $list = next7days();
    $kb=[]; foreach($list as $d){ $kb[]=[ kb_btn($d['label'],'dm:cal:story:toggle:'.$customer_id.':'.$d['label']) ]; }
    $kb[]=[ kb_btn("اتمام و ارسال به ادمین","dm:cal:done:".$customer_id) ];
    tg_send_html($chat_id, "🗓️ روزهای <b>استوری</b> هفته‌ی پیشِ رو را انتخاب کن:", $kb);
}
function dm_calendar_done(int $chat_id, int $customer_id): void {
    $p = plans_all(); $plan = $p[(string)$customer_id] ?? ['posts'=>[],'stories'=>[]];
    // Assign tasks to admin for each day (posts & stories) with 23:00 due time
    $team = team_get($customer_id); $admin = (int)($team['members']['admin'] ?? 0);
    foreach (['posts','stories'] as $type) {
        foreach ($plan[$type] as $d) {
            $due_ts = strtotime($d + ' 23:00');
            $tid = task_create("آپلود ".($type=='posts'?'پست':'استوری')." مشتری {$customer_id}", $admin, $due_ts, 'upload', ['customer_id'=>$customer_id,'type'=>$type,'date'=>$d]);
        }
    }
    tg_send_html($chat_id, "📬 تقویم محتوایی برای ادمین ارسال شد.");
    if ($admin) tg_send_html($admin, "📢 تقویم محتوایی جدید برای مشتری {$customer_id} ثبت شد.\nپست‌ها: ".implode(', ',$plan['posts'])."\nاستوری‌ها: ".implode(', ',$plan['stories']));
}


function dm_handle_reports(string $data, int $chat_id): bool {
    if ($data==='dm:reports') {
        tg_send_html($chat_id, "گزارش نمونه: تعداد آفیش‌ها، وظایف عقب‌افتاده، جریمه‌ها — (نسخهٔ دمو).");
        return true;
    }
    if ($data==='dm:team:settings') {
        tg_send_html($chat_id, "تنظیمات تیم (آیتم‌های بیشتری به‌زودی).");
        return true;
    }
    return false;
}
