<?php
declare(strict_types=1);

require_once __DIR__ . '/../functions/telegram.php';
require_once __DIR__ . '/../functions/utils.php';
require_once __DIR__ . '/../functions/users.php';
require_once __DIR__ . '/../config.php';

function ceo_menu(int $uid): void {
    if ($uid !== CEO_ID) return;
    $rows = [
        [ kb_btn(icon('dash').' داشبورد', 'ceo:dash') ],
        [ kb_btn(icon('roles').' درخواست‌های نقش', 'ceo:rr') ],
        [ kb_btn(icon('accounting').' حسابداری', 'acc:menu') ],
        [ kb_btn(icon('back').' بازگشت', 'ceo:back') ],
    ];
    tg_send_kb_html($uid,
        icon('ceo') . " <b>پنل مدیرعامل</b>\n"
        ."- وضعیت توکن: " . (strlen(BOT_TOKEN) ? '✅' : '❌') . "\n"
        ."- درخواست‌های نقش در انتظار: " . rr_count_pending(),
        $rows
    );
}

function ceo_handle(int $uid, string $data, int $chat_id, int $mid): void {
    if ($uid !== CEO_ID) return;

    if ($data === 'ceo:dash') {
        tg_edit_html($chat_id, $mid,
            icon('dash')." <b>داشبورد</b>\n"
            ."• وضعیت: فعال\n"
            ."• زمان: " . date('Y-m-d H:i:s') . "\n"
            ."• درخواست‌های نقش در انتظار: " . rr_count_pending()
        );
        return;
    }
    if ($data === 'ceo:rr') {
        tg_edit_html($chat_id, $mid,
            icon('roles')." <b>درخواست‌های نقش</b>\n"
            ."فعلاً فقط شمارش: " . rr_count_pending() . "\n"
            ."در فاز بعدی لیست کامل و تایید/رد اضافه می‌شود."
        );
        return;
    }
    if ($data === 'ceo:back') {
        start_menu($uid);
        return;
    }
}
