<?php
declare(strict_types=1);

require_once __DIR__ . '/../functions/telegram.php';
require_once __DIR__ . '/../functions/utils.php';
require_once __DIR__ . '/../functions/users.php';

function start_menu(int $uid): void {
    $rows = [
        [ kb_btn(icon('employee').' کارمند هستم', 'start:emp') ],
        [ kb_btn(icon('customer').' مشتری هستم', 'start:cust') ],
    ];
    if ($uid === CEO_ID) {
        $rows[] = [ kb_btn(icon('ceo').' ورود مدیرعامل', 'ceo:menu') ];
        $rows[] = [ kb_btn(icon('accounting').' حسابداری', 'acc:menu') ];
    }
    tg_send_kb_html($uid,
        icon('start') . " <b>خوش آمدید به ربات ویژن مدیا</b>\n"
        ."نقش خودتان را انتخاب کنید:",
        $rows
    );
}

function start_handle(int $uid, string $data, int $chat_id, int $mid): void {
    if ($data === 'start:emp') {
        rr_create($uid, 'employee', '');
        tg_edit_html($chat_id, $mid, '✅ درخواست کارمند ثبت شد. منتظر تایید حسابداری باشید.');
        return;
    }
    if ($data === 'start:cust') {
        rr_create($uid, 'customer', '');
        tg_edit_html($chat_id, $mid, '✅ درخواست مشتری ثبت شد. منتظر تماس حسابداری باشید.');
        return;
    }
}
