<?php
// vm_diag.php — Vision Media Bot quick diagnostics (read-only)
header('Content-Type: application/json; charset=UTF-8');

function exists($p){ return file_exists($p) ? '✅' : '❌'; }
function iswritable($p){ return is_writable($p) ? '✅' : '❌'; }

$base = __DIR__;
$report = [
  'php_version' => PHP_VERSION,
  'time' => date('Y-m-d H:i:s'),
  'paths' => [
    'index.php' => exists($base.'/index.php'),
    'router.php' => exists($base.'/router.php'),
    'config.php' => exists($base.'/config.php'),
    'functions/telegram.php' => exists($base.'/functions/telegram.php'),
    'functions/utils.php' => exists($base.'/functions/utils.php'),
    'functions/storage.php' => exists($base.'/functions/storage.php'),
    'functions/users.php' => exists($base.'/functions/users.php'),
    'functions/acc.php' => exists($base.'/functions/acc.php'),
    'handlers/start.php' => exists($base.'/handlers/start.php'),
    'handlers/ceo.php' => exists($base.'/handlers/ceo.php'),
    'handlers/accounting.php' => exists($base.'/handlers/accounting.php'),
    'data/' => exists($base.'/data'),
    'logs/' => exists($base.'/logs'),
  ],
  'writable' => [
    'data/' => iswritable($base.'/data'),
    'logs/' => iswritable($base.'/logs'),
  ],
  'config' => [],
  'data_files' => [],
  'errors' => []
];

// Try include config & read constants (safely)
try {
  @include_once $base.'/config.php';
  if (defined('BOT_TOKEN')) {
    $report['config']['BOT_TOKEN_len'] = strlen(BOT_TOKEN);
  } else {
    $report['config']['BOT_TOKEN_len'] = 0;
  }
  if (defined('CEO_ID')) $report['config']['CEO_ID'] = CEO_ID;
} catch (Throwable $e) {
  $report['errors'][] = 'config include: '.$e->getMessage();
}

// Check data jsons
foreach (['customers.json','contracts.json','invoices.json','role_requests.json'] as $f) {
  $p = $base.'/data/'.$f;
  if (file_exists($p)) {
    $raw = @file_get_contents($p);
    $len = $raw === false ? 0 : strlen($raw);
    $report['data_files'][$f] = ['exists'=>'✅','bytes'=>$len];
  } else {
    $report['data_files'][$f] = ['exists'=>'❌','bytes'=>0];
  }
}

// Try router sanity (includes only; won't execute handlers)
try {
  @include_once $base.'/functions/utils.php';
  @include_once $base.'/functions/telegram.php';
  @include_once $base.'/functions/storage.php';
  @include_once $base.'/functions/users.php';
  @include_once $base.'/functions/acc.php';
  @include_once $base.'/handlers/start.php';
  @include_once $base.'/handlers/ceo.php';
  @include_once $base.'/handlers/accounting.php';
  $report['router_include_check'] = '✅';
} catch (Throwable $e) {
  $report['router_include_check'] = '❌';
  $report['errors'][] = 'include check: '.$e->getMessage();
}

echo json_encode($report, JSON_UNESCAPED_UNICODE|JSON_PRETTY_PRINT);
