<?php
// vm_patch_A1.php — FIXED legacy-safe installer (no short arrays).
// Purpose: add Accounting module to your EXISTING router.php without breaking your flow.
// 1) Backs up router.php to router.php.bak.YYYYMMDD_HHMMSS
// 2) Ensures require_once for acc.php and accounting.php exist
// 3) Injects /acc (CEO) in handle_message and acc: in handle_callback
// Run once in browser: /vm_patch_A1.php

header('Content-Type: text/plain; charset=UTF-8');

$base   = __DIR__;
$router = $base . '/router.php';
if (!file_exists($router)) { http_response_code(500); die("router.php not found\n"); }

$ts  = date('Ymd_His');
$bak = $base . '/router.php.bak.' . $ts;
if (!copy($router, $bak)) { http_response_code(500); die("cannot backup router.php\n"); }

$src  = file_get_contents($router);
$orig = $src;

// ---------- 1) require_once lines ----------
$reqAcc = "require_once __DIR__ . '/functions/acc.php';";
$reqAccH= "require_once __DIR__ . '/handlers/accounting.php';";

if (strpos($src, $reqAcc) === false || strpos($src, $reqAccH) === false) {
    // Find insertion anchor: after the last "require_once __DIR__"
    $anchorPos = -1;
    $offset = 0;
    while (true) {
        $p = strpos($src, "require_once __DIR__", $offset);
        if ($p === false) break;
        $anchorPos = $p;
        $offset = $p + 1;
    }
    if ($anchorPos !== -1) {
        // Move to end of that line
        $lineEnd = strpos($src, "\n", $anchorPos);
        if ($lineEnd === false) $lineEnd = strlen($src);
        $insertion = "";
        if (strpos($src, $reqAcc) === false)  $insertion .= "\n" . $reqAcc;
        if (strpos($src, $reqAccH) === false) $insertion .= "\n" . $reqAccH;
        $src = substr($src, 0, $lineEnd) . $insertion . substr($src, $lineEnd);
        echo "Added require_once lines.\n";
    } else {
        // If not found, prepend after opening PHP tag
        $needle = "<?php";
        $pos = strpos($src, $needle);
        if ($pos !== false) {
            $pos += strlen($needle);
            $insertion = "\n" . $reqAcc . "\n" . $reqAccH . "\n";
            $src = substr($src, 0, $pos) . $insertion . substr($src, $pos);
            echo "Prepended require_once lines.\n";
        } else {
            echo "WARN: could not find insertion point for require_once. Skipped.\n";
        }
    }
} else {
    echo "require_once lines already present.\n";
}

// ---------- 2) handle_message injection (/acc) ----------
if (strpos($src, "acc_menu(") !== false) {
    if (strpos($src, "/acc' &&") === false && strpos($src, "/acc\" &&") === false) {
        $fnPos = strpos($src, "function handle_message");
        if ($fnPos !== false) {
            $brace = strpos($src, "{", $fnPos);
            if ($brace !== false) {
                $inject = "\n    // injected by vm_patch_A1 (accounting)\n"
                        . "    if (\$text === '/acc' && function_exists('acc_menu') && is_ceo(\$uid)) { acc_menu(\$uid); return; }\n";
                $src = substr($src, 0, $brace+1) . $inject . substr($src, $brace+1);
                echo "Injected /acc handler into handle_message.\n";
            }
        }
    } else {
        echo "/acc handler already present.\n";
    }
} else {
    echo "WARN: acc_menu() not found; skipping /acc injection.\n";
}

// ---------- 3) handle_callback injection (acc:) ----------
if (strpos($src, "acc_handle(") !== false) {
    if (strpos($src, "strpos(\$data, 'acc:')") === false) {
        $fnPos = strpos($src, "function handle_callback");
        if ($fnPos !== false) {
            $brace = strpos($src, "{", $fnPos);
            if ($brace !== false) {
                $inject = "\n    // injected by vm_patch_A1 (accounting)\n"
                        . "    if (strpos(\$data, 'acc:') === 0 && function_exists('acc_handle') && is_ceo(\$uid)) { acc_handle(\$uid, \$data, \$chat_id, \$mid); return; }\n";
                $src = substr($src, 0, $brace+1) . $inject . substr($src, $brace+1);
                echo "Injected acc: handler into handle_callback.\n";
            }
        }
    } else {
        echo "acc: callback handler already present.\n";
    }
} else {
    echo "WARN: acc_handle() not found; skipping acc: injection.\n";
}

// ---------- write back if changed ----------
if ($src !== $orig) {
    file_put_contents($router, $src);
    echo "router.php patched. Backup: " . basename($bak) . "\n";
} else {
    echo "No changes were needed. Backup: " . basename($bak) . "\n";
}

// Ensure data files exist
@mkdir($base . '/data', 0775, true);
$files = array('customers.json','contracts.json','invoices.json');
for ($i=0; $i<count($files); $i++) {
    $p = $base . '/data/' . $files[$i];
    if (!file_exists($p)) {
        file_put_contents($p, json_encode(array('last_id'=>0,'items'=>array()), JSON_UNESCAPED_UNICODE|JSON_PRETTY_PRINT));
    }
}

echo "Done.\n";
