<?php
// vm_patch_A1_1.php — binds your existing Persian menu texts to accounting UI (no UI changes to your flow)
// - Adds: require_once __DIR__ . '/handlers/accounting_bind.php';
// - Injects a call inside handle_message(): if acc_bind_handle_text(...) returns true, it stops.
// Run once in browser after upload.

header('Content-Type: text/plain; charset=UTF-8');

$base   = __DIR__;
$router = $base . '/router.php';
if (!file_exists($router)) { http_response_code(500); die("router.php not found\n"); }

$ts  = date('Ymd_His');
$bak = $base . '/router.php.bak.A1_1.' . $ts;
if (!copy($router, $bak)) { http_response_code(500); die("cannot backup router.php\n"); }

$src  = file_get_contents($router);
$orig = $src;

// 1) Add require_once for accounting_bind.php if missing
$reqBind = "require_once __DIR__ . '/handlers/accounting_bind.php';";
if (strpos($src, $reqBind) === false) {
    // Insert after other require_once lines
    $anchorPos = -1;
    $offset = 0;
    while (true) {
        $p = strpos($src, "require_once __DIR__", $offset);
        if ($p === false) break;
        $anchorPos = $p;
        $offset = $p + 1;
    }
    if ($anchorPos !== -1) {
        $lineEnd = strpos($src, "\n", $anchorPos);
        if ($lineEnd === false) $lineEnd = strlen($src);
        $src = substr($src, 0, $lineEnd) . "\n" . $reqBind . substr($src, $lineEnd);
        echo "Added require_once accounting_bind.php\n";
    } else {
        $needle = "<?php";
        $pos = strpos($src, $needle);
        if ($pos !== false) {
            $pos += strlen($needle);
            $src = substr($src, 0, $pos) . "\n" . $reqBind . "\n" . substr($src, $pos);
            echo "Prepended require_once accounting_bind.php\n";
        }
    }
} else {
    echo "require_once accounting_bind.php already present\n";
}

// 2) Inject acc_bind_handle_text(...) call near start of handle_message
if (strpos($src, "acc_bind_handle_text(") === false) {
    $fnPos = strpos($src, "function handle_message");
    if ($fnPos !== false) {
        $brace = strpos($src, "{", $fnPos);
        if ($brace !== false) {
            $inject = "\n    // injected by vm_patch_A1_1\n"
                    . "    if (function_exists('acc_bind_handle_text') && acc_bind_handle_text(\$uid, \$chat_id, \$text)) { return; }\n";
            $src = substr($src, 0, $brace+1) . $inject . substr($src, $brace+1);
            echo "Injected acc_bind_handle_text into handle_message\n";
        } else {
            echo "WARN: could not locate brace of handle_message\n";
        }
    } else {
        echo "WARN: handle_message not found\n";
    }
} else {
    echo "acc_bind_handle_text already present\n";
}

// Write back if changed
if ($src !== $orig) {
    file_put_contents($router, $src);
    echo "router.php patched. Backup: " . basename($bak) . "\n";
} else {
    echo "No changes were necessary. Backup: " . basename($bak) . "\n";
}

echo "Done.\n";
