<?php
// vm_patch_A1_4.php — Inject early accounting text hook at router-level
// 1) adds: require_once __DIR__ . '/handlers/hook_accounting_text.php';
// 2) after the "$update = ..." assignment, inserts:
//    if (function_exists('hook_accounting_text') && hook_accounting_text($update)) { exit; }

header('Content-Type: text/plain; charset=UTF-8');

$base   = __DIR__;
$router = $base . '/router.php';
if (!file_exists($router)) { http_response_code(500); die("router.php not found\n"); }

$ts  = date('Ymd_His');
$bak = $base . '/router.php.bak.A1_4.' . $ts;
if (!copy($router, $bak)) { http_response_code(500); die("cannot backup router.php\n"); }

$src  = file_get_contents($router);
$orig = $src;

// 1) add require_once
$req = "require_once __DIR__ . '/handlers/hook_accounting_text.php';";
if (strpos($src, $req) === false) {
    $anchorPos = -1; $offset = 0;
    while (true) {
        $p = strpos($src, "require_once __DIR__", $offset);
        if ($p === false) break;
        $anchorPos = $p; $offset = $p + 1;
    }
    if ($anchorPos !== -1) {
        $lineEnd = strpos($src, "\n", $anchorPos);
        if ($lineEnd === false) $lineEnd = strlen($src);
        $src = substr($src, 0, $lineEnd) . "\n" . $req . substr($src, $lineEnd);
        echo "Added require hook_accounting_text.php\n";
    } else {
        $needle = "<?php";
        $pos = strpos($src, $needle);
        if ($pos !== false) {
            $pos += strlen($needle);
            $src = substr($src, 0, $pos) . "\n" . $req . "\n" . substr($src, $pos);
            echo "Prepended require hook_accounting_text.php\n";
        }
    }
} else {
    echo "require hook already present\n";
}

// 2) insert early hook after $update assignment
if (strpos($src, "hook_accounting_text(") === false) {
    // Try to find "$update =" line
    $pos = strpos($src, "$update");
    $assignPos = -1;
    while ($pos !== false) {
        // find pattern "$update ="
        if (substr($src, $pos, 9) === "$update =") { $assignPos = $pos; break; }
        $pos = strpos($src, "$update", $pos+1);
    }
    if ($assignPos !== -1) {
        $lineEnd = strpos($src, "\n", $assignPos);
        if ($lineEnd === false) $lineEnd = strlen($src);
        $insertion = "\n// injected by vm_patch_A1_4\nif (function_exists('hook_accounting_text') && hook_accounting_text($update)) { exit; }\n";
        $src = substr($src, 0, $lineEnd) . $insertion . substr($src, $lineEnd);
        echo "Inserted early hook after $update assignment\n";
    } else {
        echo "WARN: could not find $update assignment; no insertion made\n";
    }
} else {
    echo "early hook already present\n";
}

// write back
if ($src !== $orig) {
    file_put_contents($router, $src);
    echo "router.php patched. Backup: " . basename($bak) . "\n";
} else {
    echo "No changes were necessary. Backup: " . basename($bak) . "\n";
}

echo "Done.\n";
