<?php
// vm_patch_A1_4b.php — FIX for routers with different $update assignment
// Strategy:
//   1) ensure require_once __DIR__ . '/handlers/hook_accounting_text.php';
//   2) inject INSIDE the "if (is_array($update)) {" block (guaranteed place where $update exists):
//        if (function_exists('hook_accounting_text') && hook_accounting_text($update)) { return; }

header('Content-Type: text/plain; charset=UTF-8');

$base   = __DIR__;
$router = $base . '/router.php';
if (!file_exists($router)) { http_response_code(500); die("router.php not found\n"); }

$ts  = date('Ymd_His');
$bak = $base . '/router.php.bak.A1_4b.' . $ts;
if (!copy($router, $bak)) { http_response_code(500); die("cannot backup router.php\n"); }

$src  = file_get_contents($router);
$orig = $src;

// 1) add require_once (if missing)
$req = "require_once __DIR__ . '/handlers/hook_accounting_text.php';";
if (strpos($src, $req) === false) {
    $anchorPos = -1; $offset = 0;
    while (true) {
        $p = strpos($src, "require_once __DIR__", $offset);
        if ($p === false) break;
        $anchorPos = $p; $offset = $p + 1;
    }
    if ($anchorPos !== -1) {
        $lineEnd = strpos($src, "\n", $anchorPos);
        if ($lineEnd === false) $lineEnd = strlen($src);
        $src = substr($src, 0, $lineEnd) . "\n" . $req . substr($src, $lineEnd);
        echo "Added require hook_accounting_text.php\n";
    } else {
        $needle = "<?php";
        $pos = strpos($src, $needle);
        if ($pos !== false) {
            $pos += strlen($needle);
            $src = substr($src, 0, $pos) . "\n" . $req . "\n" . substr($src, $pos);
            echo "Prepended require hook_accounting_text.php\n";
        }
    }
} else {
    echo "require hook already present\n";
}

// 2) inject inside "if (is_array($update)) {" block
$marker = "if (is_array($update))";
if (strpos($src, $marker) !== false) {
    $pos = strpos($src, $marker);
    $brace = strpos($src, "{", $pos);
    if ($brace !== false) {
        $inject = "\n    // injected by vm_patch_A1_4b (router early hook)\n"
                . "    if (function_exists('hook_accounting_text') && hook_accounting_text($update)) { return; }\n";
        $src = substr($src, 0, $brace+1) . $inject . substr($src, $brace+1);
        echo "Inserted early hook inside is_array(\$update) block\n";
    } else {
        echo "WARN: could not find opening brace of is_array(\$update) block\n";
    }
} else {
    echo "WARN: could not find \"if (is_array(\$update))\" — no insertion made\n";
}

// write back
if ($src !== $orig) {
    file_put_contents($router, $src);
    echo "router.php patched. Backup: " . basename($bak) . "\n";
} else {
    echo "No changes were necessary. Backup: " . basename($bak) . "\n";
}

echo "Done.\n";
