<?php
declare(strict_types=1);

function tg_api(string $method, array $params): array {
    $cfg = require __DIR__ . '/../config.php';
    $token = $cfg['BOT_TOKEN'] ?? '';
    $url = "https://api.telegram.org/bot{$token}/{$method}";
    $ch = curl_init($url);
    curl_setopt_array($ch, [
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_POST => true,
        CURLOPT_POSTFIELDS => $params,
        CURLOPT_TIMEOUT => 20,
    ]);
    $out = curl_exec($ch);
    $err = curl_error($ch);
    curl_close($ch);
    $j = json_decode($out ?: '{}', true);
    if (!$j || !isset($j['ok']) || !$j['ok']) {
        @file_put_contents(__DIR__.'/../logs/bot.log', '['.date('Y-m-d H:i:s').'] TG '.$method.' ERR: '.$err.' | '.$out."\n", FILE_APPEND);
        return ['ok'=>false,'error'=>$err?:'no-resp','resp'=>$out];
    }
    return $j;
}

function tg_set_webhook(): array {
    $cfg = require __DIR__ . '/../config.php';
    $url = $cfg['BASE_URL'] ?? '';
    return tg_api('setWebhook', ['url'=>$url, 'allowed_updates'=>json_encode(['message','callback_query'])]);
}
