<?php
declare(strict_types=1);

function vm_now(): int { return time(); }

function vm_date_g(int $ts=null): string {
    $ts = $ts ?? time();
    return date('Y-m-d H:i', $ts);
}

function kb_btn(string $title, string $data): array { return ['text'=>$title, 'callback_data'=>$data]; }

function tg_send_html(int $chat_id, string $text, array $inline_kb=null, $reply_to=null): void {
    $params = [
        'chat_id' => $chat_id,
        'text' => $text,
        'parse_mode' => 'HTML',
        'disable_web_page_preview' => true,
    ];
    if ($reply_to) $params['reply_to_message_id'] = $reply_to;
    if ($inline_kb) $params['reply_markup'] = json_encode(['inline_keyboard'=>$inline_kb], JSON_UNESCAPED_UNICODE);
    tg_api('sendMessage', $params);
}

function tg_send_photo(int $chat_id, string $file_id_or_url, string $caption='', array $kb=null): void {
    $params = [
        'chat_id'=>$chat_id,
        'photo'=>$file_id_or_url,
        'caption'=>$caption,
        'parse_mode'=>'HTML'
    ];
    if ($kb) $params['reply_markup'] = json_encode(['inline_keyboard'=>$kb], JSON_UNESCAPED_UNICODE);
    tg_api('sendPhoto',$params);
}

function tg_answer_cb(string $cb_id, string $text=''): void {
    tg_api('answerCallbackQuery', ['callback_query_id'=>$cb_id, 'text'=>$text]);
}

function vm_log(string $msg): void {
    $f = __DIR__ . '/../logs/bot.log';
    @file_put_contents($f, '['.date('Y-m-d H:i:s').'] '.$msg."\n", FILE_APPEND);
}

