<?php
declare(strict_types=1);
require_once __DIR__ . '/../functions/utils.php';
require_once __DIR__ . '/../functions/telegram.php';
require_once __DIR__ . '/../functions/storage.php';

function acc_menu(int $chat_id): void {
    $rows = [
        [ kb_btn('🧾 فاکتور','inv:menu'), kb_btn('📑 قرارداد','ctr:menu') ],
        [ kb_btn('🏬 فروشگاه خدمات','acc:store') ],
        [ kb_btn('💰 پیش‌پرداخت/مانده','inv:remain'), kb_btn('📈 گزارش مالی','acc:reports') ],
        [ kb_btn('📚 دفترکل','ledger:menu') ],
        [ kb_btn('👥 کارمندان','hr:list'), kb_btn('👤 مشترکین','cust:menu') ],
        [ kb_btn('📝 صورتجلسه','minutes:menu'), kb_btn('📢 ابلاغیه','notice:menu') ],
        [ kb_btn('↩️ بازگشت','home') ],
    ];
    tg_send_html($chat_id,'<b>پنل حسابداری</b>', $rows);
}
function acc_handle(string $data, int $chat_id): void {
    if ($data==='acc:menu'){ acc_menu($chat_id); return; }
    if ($data==='inv:menu'){ tg_send_html($chat_id,'فاکتورها—ایجاد/ویرایش/پرداخت شد/تخفیف/مالیات',[[kb_btn('↩️ بازگشت','acc:menu')]]); return; }
    if ($data==='ctr:menu'){ tg_send_html($chat_id,'قراردادها—ارسال/امضا/PDF',[[kb_btn('↩️ بازگشت','acc:menu')]]); return; }
    if ($data==='acc:store'){ tg_send_html($chat_id,'فروشگاه—دسته‌ها/خدمت/قیمت/عکس/کد تخفیف',[[kb_btn('↩️ بازگشت','acc:menu')]]); return; }
    if ($data==='inv:remain'){ tg_send_html($chat_id,'پیش‌پرداخت/مانده—سررسید/دیرکرد',[[kb_btn('↩️ بازگشت','acc:menu')]]); return; }
    if ($data==='acc:reports'){ tg_send_html($chat_id,'گزارش مالی—بازه/خروجی PDF/Excel',[[kb_btn('↩️ بازگشت','acc:menu')]]); return; }
    if ($data==='ledger:menu'){ tg_send_html($chat_id,'دفترکل—همه رویدادها',[[kb_btn('↩️ بازگشت','acc:menu')]]); return; }
    if ($data==='hr:list'){ tg_send_html($chat_id,'لیست/ویرایش پرسنل',[[kb_btn('↩️ بازگشت','acc:menu')]]); return; }
    if ($data==='cust:menu'){ tg_send_html($chat_id,'مشتریان—ایجاد/ویرایش/انتصاب DM',[[kb_btn('↩️ بازگشت','acc:menu')]]); return; }
    if ($data==='minutes:menu'){ tg_send_html($chat_id,'صورتجلسه—زنجیره امضا و PDF',[[kb_btn('↩️ بازگشت','acc:menu')]]); return; }
    if ($data==='notice:menu'){ tg_send_html($chat_id,'ابلاغیه—تأیید مدیرعامل + PDF',[[kb_btn('↩️ بازگشت','acc:menu')]]); return; }
    tg_send_html($chat_id,'دستور ناشناخته در پنل حسابداری.');
}
