<?php
declare(strict_types=1);
require_once __DIR__ . '/../functions/telegram.php';
require_once __DIR__ . '/../functions/utils.php';
require_once __DIR__ . '/../functions/storage.php';

function ceo_menu(int $chat_id): void {
    $rows = [
        [ kb_btn('📊 داشبورد','ceo:dash'), kb_btn('👥 منابع انسانی','hr:menu') ],
        [ kb_btn('💼 حسابداری','acc:menu'), kb_btn('🚨 جریمه‌ها','ceo:pen') ],
        [ kb_btn('📜 گزارش کار','ceo:reports'), kb_btn('⚙️ تنظیمات کل ربات','ceo:settings') ],
        [ kb_btn('👤 ورود به پنل نقش‌ها','ceo:imp') ],
        [ kb_btn('🖋️ منتظر امضا','ceo:signqueue') ],
        [ kb_btn('🌐 وبهوک','ceo:webhook'), kb_btn('🗂 پشتیبان‌گیری','ceo:backup') ],
        [ kb_btn('↩️ خانه','home') ]
    ];
    tg_send_html($chat_id, 'سلام! <b>پنل مدیرعامل</b> آماده‌ست.', $rows);
}

function ceo_handle(string $data, int $chat_id): void {
    if ($data==='ceo:menu'){ ceo_menu($chat_id); return; }
    if ($data==='ceo:dash'){ tg_send_html($chat_id,'نمای کلی (نسخه اول).',[ [kb_btn('↩️ بازگشت','ceo:menu')] ]); return; }
    if ($data==='ceo:pen'){ tg_send_html($chat_id,'تایید نهایی جریمه‌ها (به‌زودی)',[[kb_btn('↩️ بازگشت','ceo:menu')]]); return; }
    if ($data==='ceo:reports'){ tg_send_html($chat_id,'گزارش کار—فیلتر و خروجی‌ها (به‌زودی)',[[kb_btn('↩️ بازگشت','ceo:menu')]]); return; }
    if ($data==='ceo:webhook'){ tg_send_html($chat_id,'تنظیم وبهوک',[[kb_btn('SetWebhook','ceo:webhook:set'), kb_btn('DeleteWebhook','ceo:webhook:del')],[kb_btn('↩️ بازگشت','ceo:menu')]]); return; }
    if ($data==='ceo:webhook:set'){ tg_set_webhook(); tg_send_html($chat_id,'SetWebhook ارسال شد ✅',[[kb_btn('↩️ بازگشت','ceo:webhook')]]); return; }
    if ($data==='ceo:webhook:del'){ tg_api('deleteWebhook',[]); tg_send_html($chat_id,'Webhook حذف شد ✅',[[kb_btn('↩️ بازگشت','ceo:webhook')]]); return; }
    if ($data==='ceo:settings'){ 
        $s = settings_all();
        $txt = "<b>تنظیمات</b>\nپیام خوش‌آمد: ".($s['welcome_enabled']?'روشن ✅':'خاموش ❌');
        tg_send_html($chat_id,$txt,[[kb_btn(($s['welcome_enabled']?'خاموش':'روشن').' کردن خوش‌آمد','ceo:set:welcome'), kb_btn('مشخصات شرکت','ceo:set:company')],[kb_btn('↩️ بازگشت','ceo:menu')]]);
        return;
    }
    if ($data==='ceo:set:welcome'){
        $s = settings_all(); $s['welcome_enabled'] = !($s['welcome_enabled']);
        storage_write_json(STORAGE_DIR.'/settings.json',$s);
        tg_send_html($chat_id,'بروزرسانی شد.',[[kb_btn('↩️ بازگشت','ceo:settings')]]); return;
    }
    if ($data==='ceo:set:company'){
        $s = settings_all(); $c = $s['company'];
        $txt = "<b>مشخصات شرکت</b>\n".$c['name']."\nثبت: ".$c['reg_no']." | شناسه: ".$c['national_id']."\n".$c['address']."\n".implode(' / ',$c['phones'])."\nوب‌سایت: ".$c['website']."\n— اطلاعات پرداخت —\nکارت: ".$c['bank']['card']."\nحساب: ".$c['bank']['account']."\nشبا: ".$c['bank']['iban']."\nبنام: ".$c['bank']['holder'];
        tg_send_html($chat_id,$txt,[[kb_btn('↩️ بازگشت','ceo:settings')]]); return;
    }
    if ($data==='ceo:backup'){ 
        $dst = STORAGE_DIR.'/backup-'.date('Ymd-His').'.zip';
        $zip = new ZipArchive();
        if ($zip->open($dst, ZipArchive::CREATE)===TRUE) {
            foreach (glob(STORAGE_DIR.'/*.json') as $f) $zip->addFile($f, basename($f));
            $zip->close();
        }
        tg_send_html($chat_id,'بکاپ JSON‌ها ساخته شد: <code>'.basename($dst).'</code>',[[kb_btn('↩️ بازگشت','ceo:menu')]]); 
        return;
    }
    if ($data==='ceo:imp'){ 
        $rows = [
            [kb_btn('حسابداری','acc:menu'), kb_btn('مدیر دپارتمان','dm:menu')],
            [kb_btn('ادمین ارشد','leadadmin:menu'), kb_btn('ادمین','admin:menu')],
            [kb_btn('سناریونویس','script:menu'), kb_btn('بلاگر','blogger:menu')],
            [kb_btn('تصویربردار','video:menu'), kb_btn('تدوینگر','editor:menu')],
            [kb_btn('مشتری','cust:menu')],
            [kb_btn('↩️ بازگشت','ceo:menu')],
        ];
        tg_send_html($chat_id,'یک نقش را انتخاب کنید:', $rows); return;
    }
    if ($data==='ceo:signqueue'){ tg_send_html($chat_id,'سندهای منتظر امضا (صف)…',[[kb_btn('↩️ بازگشت','ceo:menu')]]); return; }
    tg_send_html($chat_id,'دستور ناشناخته در پنل مدیرعامل.',[[kb_btn('↩️ بازگشت','ceo:menu')]]);
}
