<?php
declare(strict_types=1);

require_once __DIR__ . '/../core/utils.php';
require_once __DIR__ . '/../core/storage.php';
require_once __DIR__ . '/../core/telegram.php';
require_once __DIR__ . '/../modules/department.php';
require_once __DIR__ . '/../modules/tasks.php';
require_once __DIR__ . '/../config/env.php';

if (!defined('CUSTOMERS_FILE')) define('CUSTOMERS_FILE', VM_STORAGE . '/customers.json');
if (!defined('SHOOTS_FILE'))    define('SHOOTS_FILE',    VM_STORAGE . '/shoots.json');

function mgr_menu_main(int $chat_id): void {
    $kb = kb_inline([
        [ kb_btn('👥 ساخت/ویرایش تیم مشتری', 'mgr:team'), kb_btn('🎬 ثبت آفیش جدید', 'mgr:offish:new') ],
        [ kb_btn('📅 تقویم محتوایی', 'mgr:calendar'),     kb_btn('📋 آفیش‌های من', 'mgr:offish:list') ],
    ]);
    tg_send_kb_html($chat_id, "🧭 <b>پنل مدیر دپارتمان</b>\nاز منو انتخاب کن ✨", $kb);
}
function mgr_pick_customer_kb(): array {
    $custs = storage_load(CUSTOMERS_FILE, []); $rows=[];
    foreach ($custs as $c) { $brand=tg_escape($c['brand']??($c['instagram']??('C'.($c['chat_id']??'')))); $rows[]=[ kb_btn("👤 {$brand}", "mgr:team:c:".(int)$c['chat_id']) ]; }
    return kb_inline($rows ?: [[kb_btn('— هنوز مشتری ثبت نشده —','mgr:none')]]);
}
function mgr_team_menu_for(int $chat_id, int $customer_chat_id): void {
    $team=dept_get_team($customer_chat_id); $label=function($k) use($team){ $uid=(int)($team[$k]??0); return $uid? to_persian_num($uid):'—'; };
    $msg="👥 <b>تیم مشتری #".to_persian_num($customer_chat_id)."</b>\n"
        ."مدیردپارتمان: <code>".$label('manager')."</code>\nسناریونویس: <code>".$label('scenarist')."</code>\nبلاگر: <code>".$label('blogger')."</code>\nتصویربردار: <code>".$label('videographer')."</code>\nتدوینگر: <code>".$label('editor')."</code>\nادمین: <code>".$label('admin')."</code>\n\n"
        ."برای ویرایش هر نقش، روی دکمه بزن و بعد دستور زیر را بفرست:\n<code>set role {$customer_chat_id} employee_user_id</code>";
    $kb = kb_inline([
        [ kb_btn('👑 مدیر', "mgr:team:set:manager:{$customer_chat_id}"), kb_btn('📝 سناریو', "mgr:team:set:scenarist:{$customer_chat_id}") ],
        [ kb_btn('🗣️ بلاگر', "mgr:team:set:blogger:{$customer_chat_id}"), kb_btn('🎥 تصویربردار', "mgr:team:set:videographer:{$customer_chat_id}") ],
        [ kb_btn('✂️ تدوینگر', "mgr:team:set:editor:{$customer_chat_id}"), kb_btn('🧩 ادمین', "mgr:team:set:admin:{$customer_chat_id}") ],
        [ kb_btn('✅ ذخیره نهایی', "mgr:team:save:{$customer_chat_id}") ],
    ]);
    tg_send_kb_html($chat_id,$msg,$kb);
}
function mgr_team_save_role(int $customer_chat_id, string $role, int $employee_user_id): bool {
    $custs=storage_load(CUSTOMERS_FILE,[]); foreach($custs as &$c){ if((int)$c['chat_id']===$customer_chat_id){ $team=$c['team']??[]; $team[$role]=$employee_user_id; $c['team']=$team; return storage_save(CUSTOMERS_FILE,$custs); } } return false;
}

function mgr_offish_new_form(int $chat_id): void {
    $msg="🎬 <b>ثبت آفیش جدید</b>\nقالب (در یک پیام):\n<code>customer_chat_id | 1404/06/20 | 14:30 | آدرس دقیق | لینک/لوکیشن | @handle</code>\nاگر سهمیه پر است و می‌خواهی اضافه ثبت کنی، آخر پیام بنویس <b>extra</b>.";
    tg_send_html($chat_id,$msg);
}
function mgr_offish_try_create_from_line(int $manager_id, string $line): void {
    $parts=array_map('trim', explode('|',$line)); if(count($parts)<6){ tg_send_html($manager_id,'⛔️ قالب ورودی ناقص است.'); return; }
    [$cust,$date,$hour,$addr,$loc,$handle]=$parts; $extra= isset($parts[6]) && stripos($parts[6],'extra')!==false;
    $id = offish_create((int)$cust,$manager_id,$date,$hour,$addr,$loc,$handle,$extra);
    if($id>0){ $quota=offish_month_quota_used((int)$cust); tg_send_html($manager_id,"✅ آفیش #".to_persian_num($id)." ثبت شد. (سهمیه مصرف‌شده: ".to_persian_num($quota).")"); }
}
function mgr_offish_list(int $chat_id, int $manager_id, int $page=1, int $per=6): void {
    $all=storage_load(SHOOTS_FILE,[]); $mine=array_values(array_filter($all, fn($s)=>(int)($s['manager_id']??0)===$manager_id));
    $total=count($mine); if(!$total){ tg_send_html($chat_id,'هنوز آفیشی ثبت نکردی.'); return; }
    $pages=(int)ceil($total/$per); $page=max(1,min($pages,$page)); $slice=array_slice($mine,($page-1)*$per,$per);
    $out="📋 <b>آفیش‌های من</b> (صفحه ".to_persian_num($page)."/".to_persian_num($pages).")\n";
    foreach($slice as $s){ $id=(int)$s['id']; $date=jdate('Y/m/d',(int)$s['date_ts']); $hour=tg_escape($s['hour']??'—'); $st=$s['status']??'—';
        $out.="• #".to_persian_num($id)." — {$date} {$hour} — وضعیت: <b>{$st}</b>\n"; }
    $kb=['inline_keyboard'=>[]]; if($page>1)$kb['inline_keyboard'][]=[kb_btn('⬅️ قبلی',"mgr:offish:list:p:".($page-1))]; if($page<$pages)$kb['inline_keyboard'][]=[kb_btn('بعدی ➡️',"mgr:offish:list:p:".($page+1))];
    tg_send_kb_html($chat_id,$out,$kb);
}

function manager_handle_callback(int $chat_id, int $user_id, string $data): bool {
    if (!str_starts($data,'mgr:')) return false;
    if ($data==='mgr:menu'){ mgr_menu_main($chat_id); return true; }

    if ($data==='mgr:team'){ tg_send_kb_html($chat_id,'یک مشتری را انتخاب کن:', mgr_pick_customer_kb()); return true; }
    if (preg_match('~^mgr:team:c:(\d+)$~',$data,$m)){ mgr_team_menu_for($chat_id,(int)$m[1]); return true; }
    if (preg_match('~^mgr:team:set:(manager|scenarist|blogger|videographer|editor|admin):(\d+)$~',$data,$m)){
        $role=$m[1]; $cust=(int)$m[2]; tg_send_html($chat_id,"لطفاً آی‌دی عددی کارمند برای «{$role}» را بفرست.\nسپس دستور:\n<code>set {$role} {$cust} 162160538</code>"); return true;
    }
    if (preg_match('~^mgr:team:save:(\d+)$~',$data,$m)){
        $cust=(int)$m[1]; dept_assign_team($cust, ['manager'=>$user_id] + dept_get_team($cust)); tg_send_html($chat_id,'✅ تیم ذخیره شد و یادآور ثبت اولین آفیش ایجاد شد.'); return true;
    }

    if ($data==='mgr:offish:new'){ mgr_offish_new_form($chat_id); return true; }
    if ($data==='mgr:offish:list'){ mgr_offish_list($chat_id,$user_id,1,6); return true; }
    if (preg_match('~^mgr:offish:list:p:(\d+)$~',$data,$m)){ mgr_offish_list($chat_id,$user_id,(int)$m[1],6); return true; }

    if ($data==='mgr:calendar'){ tg_send_html($chat_id,"🗓️ <b>تقویم محتوایی</b>\nقالب:\n<code>shoot_id | posts: 0,2,4 | stories: 0,1,2,3,4,6</code>\nراهنما: 0=شنبه … 6=جمعه"); return true; }

    return true;
}
function manager_handle_text(int $chat_id, int $user_id, string $text): bool {
    $t=trim($text);
    if (preg_match('~^set\s+(manager|scenarist|blogger|videographer|editor|admin)\s+(\d+)\s+(\d+)$~i',$t,$m)){ $ok=mgr_team_save_role((int)$m[2], strtolower($m[1]), (int)$m[3]); tg_send_html($chat_id,$ok?'✅ نقش ذخیره شد.':'⛔️ خطا.'); return true; }
    if (str_starts(strtolower($t),'offish ')){ mgr_offish_try_create_from_line($user_id, trim(mb_substr($t,7))); return true; }
    if (str_starts(strtolower($t),'calendar ')){ $line=trim(mb_substr($t,9));
        $ok=preg_match('~^\s*(\d+)\s*\|\s*posts:\s*([0-6,\s]*)\|\s*stories:\s*([0-6,\s]*)\s*$~u',$line,$mm);
        if(!$ok){ tg_send_html($chat_id,'⛔️ قالب نامعتبر.'); return true; }
        $sid=(int)$mm[1]; $posts=array_filter(array_map('intval',array_map('trim',explode(',',$mm[2]?:''))),fn($x)=>$x>=0&&$x<=6);
        $stories=array_filter(array_map('intval',array_map('trim',explode(',',$mm[3]?:''))),fn($x)=>$x>=0&&$x<=6);
        $saved=content_calendar_set($sid,$posts,$stories); tg_send_html($chat_id,$saved?'✅ تقویم ذخیره شد.':'⛔️ ذخیره نشد.'); return true;
    }
    if ($t==='منو' || $t==='menu'){ mgr_menu_main($chat_id); return true; }
    return false;
}

return true;
