<?php
class Storage {
  public static $root;
  public static function init(){
    self::$root = __DIR__.'/../storage';
  }
  public static function path($rel){ return self::$root.'/'.trim($rel,'/'); }
  public static function readJson($rel,$def=null){
    $f=self::path($rel);
    if(!file_exists($f)) return $def;
    $d=json_decode(file_get_contents($f),true);
    return $d===null?$def:$d;
  }
  public static function writeJson($rel,$data){
    $f=self::path($rel); @mkdir(dirname($f),0777,true);
    file_put_contents($f,json_encode($data, JSON_UNESCAPED_UNICODE|JSON_PRETTY_PRINT));
  }
  public static function appendJsonArray($rel,$row){
    $arr=self::readJson($rel, array());
    if(!is_array($arr)) $arr=array();
    $arr[]=$row;
    self::writeJson($rel,$arr);
  }
}
Storage::init();
